/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialPrinter;
import org.openconcerto.erp.core.sales.pos.io.JPOSTicketPrinter;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationEcritures.GenerationMvtTicketCaisse;
import org.openconcerto.erp.generationEcritures.GenerationMvtVirement;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Pair;
import org.openconcerto.utils.i18n.TranslationManager;

public class Caisse {
    private static Document document;
    private static SQLRow rowClient;

    static {
        rowClient = null;
    }

    public static File getConfigFile(String appName, File wd) {
        File confFile;
        File wdFile = new File(wd + "/Configuration", "pos.xml");
        if (wdFile.isFile()) {
            confFile = wdFile;
        } else {
            File preferencesFolder = DesktopEnvironment.getDE().getPreferencesFolder(appName);
            if (!preferencesFolder.exists()) {
                preferencesFolder.mkdir();
            }
            confFile = new File(preferencesFolder, "pos.xml");
        }
        return confFile;
    }

    private static Document getDocument() {
        if (document != null) {
            return document;
        }
        SAXBuilder constructeur = new SAXBuilder();
        File file = Caisse.getConfigFile();
        document = new Document();
        if (!file.exists()) {
            System.err.println("Erreur le fichier " + file.getAbsolutePath() + " n'existe pas!");
            document.setRootElement(new Element("config"));
            return document;
        }
        try {
            System.out.println("Loading:" + file.getAbsolutePath());
            document = constructeur.build(file);
        }
        catch (Exception e) {
            document.setRootElement(new Element("config"));
        }
        return document;
    }

    public static File getConfigFile() {
        return Caisse.getConfigFile(ComptaPropsConfiguration.APP_NAME, new File("."));
    }

    public static void createConnexion() {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
        TranslationManager.getInstance().addTranslationStreamFromClass(MainFrame.class);
        TranslationManager.getInstance().setLocale(Locale.getDefault());
        Configuration.setInstance(conf);
        try {
            conf.getBase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            UserManager.getInstance().setCurrentUser(Caisse.getUserID());
            ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
            comptaPropsConfiguration.setUpSocieteDataBaseConnexion(Caisse.getSocieteID());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Impossible de configurer la connexion \u00e0 la base de donn\u00e9e.\n ID soci\u00e9t\u00e9: " + Caisse.getSocieteID() + " \n ID utilisateur: " + Caisse.getUserID());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static void commitAll(final List<Ticket> tickets) {
        try {
            SQLUtils.executeAtomic(Configuration.getInstance().getSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    SQLElement elt = Configuration.getInstance().getDirectory().getElement("TICKET_CAISSE");
                    SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
                    SQLElement eltEnc = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
                    SQLElement eltMode = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
                    int imported = 0;
                    for (Ticket ticket : tickets) {
                        SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
                        sel.addSelect(elt.getTable().getField("NUMERO"));
                        sel.setWhere(new Where((FieldRef)elt.getTable().getField("NUMERO"), "=", (Object)ticket.getCode()));
                        List l = Configuration.getInstance().getBase().getDataSource().executeCol(sel.asString());
                        if (l == null || l.size() != 0) continue;
                        SQLRowValues rowVals = new SQLRowValues(elt.getTable());
                        rowVals.put("NUMERO", ticket.getCode());
                        rowVals.put("DATE", ticket.getCreationDate());
                        rowVals.put("ID_CAISSE", Caisse.getID());
                        TotalCalculator calc = new TotalCalculator("T_PA_HT", "T_PV_HT", null);
                        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
                        Boolean bServiceActive = Boolean.valueOf(val);
                        calc.setServiceActive(bServiceActive != null && bServiceActive != false);
                        for (Pair<Article, Integer> item : ticket.getArticles()) {
                            SQLRowValues rowValsElt = new SQLRowValues(eltFact.getTable());
                            Article article = item.getFirst();
                            Integer nb = item.getSecond();
                            rowValsElt.put("QTE", nb);
                            rowValsElt.put("PV_HT", article.getPriceHTInCents());
                            Float tauxFromId = TaxeCache.getCache().getTauxFromId(article.getIdTaxe());
                            BigDecimal tauxTVA = new BigDecimal(tauxFromId.floatValue()).movePointLeft(2).add(BigDecimal.ONE);
                            BigDecimal valueHT = article.getPriceHTInCents().multiply(new BigDecimal(nb), MathContext.DECIMAL128);
                            rowValsElt.put("T_PV_HT", valueHT);
                            rowValsElt.put("T_PV_TTC", valueHT.multiply(tauxTVA, MathContext.DECIMAL128));
                            rowValsElt.put("ID_TAXE", article.getIdTaxe());
                            rowValsElt.put("CODE", article.getCode());
                            rowValsElt.put("NOM", article.getName());
                            rowValsElt.put("ID_TICKET_CAISSE", rowVals);
                            rowValsElt.put("ID_ARTICLE", article.getId());
                            calc.addLine(rowValsElt, eltArticle.getTable().getRow(article.getId()), 0, false);
                        }
                        calc.checkResult();
                        long longValueTotalHT = calc.getTotalHT().movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue();
                        rowVals.put("TOTAL_HT", longValueTotalHT);
                        long longValueTotal = calc.getTotalTTC().movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue();
                        rowVals.put("TOTAL_TTC", longValueTotal);
                        long longValueTotalTVA = calc.getTotalTVA().movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue();
                        rowVals.put("TOTAL_TVA", longValueTotalTVA);
                        for (Paiement paiement : ticket.getPaiements()) {
                            if (paiement.getMontantInCents() <= 0) continue;
                            SQLRowValues rowValsElt = new SQLRowValues(eltEnc.getTable());
                            SQLRowValues rowValsEltMode = new SQLRowValues(eltMode.getTable());
                            if (paiement.getType() == 3) {
                                rowValsEltMode.put("ID_TYPE_REGLEMENT", 3);
                            } else if (paiement.getType() == 2) {
                                rowValsEltMode.put("ID_TYPE_REGLEMENT", 2);
                            } else if (paiement.getType() == 1) {
                                rowValsEltMode.put("ID_TYPE_REGLEMENT", 4);
                            }
                            rowValsElt.put("ID_MODE_REGLEMENT", rowValsEltMode);
                            try {
                                rowValsElt.put("ID_CLIENT", Caisse.getClientCaisse().getID());
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            long montant = paiement.getMontantInCents();
                            if (ticket.getPaiements().size() == 1 && paiement.getType() == 1) {
                                montant = longValueTotal;
                            }
                            rowValsElt.put("MONTANT", montant);
                            rowValsElt.put("NOM", "Ticket " + ticket.getCode());
                            rowValsElt.put("DATE", ticket.getCreationDate());
                            rowValsElt.put("ID_TICKET_CAISSE", rowVals);
                        }
                        SQLRow rowFinal = rowVals.insert();
                        ++imported;
                        GenerationMvtTicketCaisse mvt = new GenerationMvtTicketCaisse(rowFinal);
                        try {
                            Integer idMvt = mvt.genereMouvement().call();
                            SQLRowValues valTicket = rowFinal.asRowValues();
                            valTicket.put("ID_MOUVEMENT", idMvt);
                            rowFinal = valTicket.update();
                            Collection rowsEnc = rowFinal.getReferentRows(eltEnc.getTable());
                            long totalEnc = 0L;
                            for (SQLRow sqlRow : rowsEnc) {
                                long montant = sqlRow.getLong("MONTANT");
                                PrixTTC ttc = new PrixTTC(montant);
                                totalEnc += montant;
                                new GenerationReglementVenteNG("R\u00e8glement " + sqlRow.getForeignRow("ID_MODE_REGLEMENT").getForeignRow("ID_TYPE_REGLEMENT").getString("NOM") + " Ticket " + rowFinal.getString("NUMERO"), Caisse.getClientCaisse(), ttc, sqlRow.getDate("DATE").getTime(), sqlRow.getForeignRow("ID_MODE_REGLEMENT"), rowFinal, rowFinal.getForeignRow("ID_MOUVEMENT"), false);
                            }
                            if (totalEnc > longValueTotal) {
                                SQLTable table = Configuration.getInstance().getDirectory().getElement("TYPE_REGLEMENT").getTable();
                                int idComptePceCaisse = table.getRow(4).getInt("ID_COMPTE_PCE_CLIENT");
                                if (idComptePceCaisse == table.getUndefinedID()) {
                                    idComptePceCaisse = ComptePCESQLElement.getId(ComptePCESQLElement.getComptePceDefault("VenteEspece"));
                                }
                                new GenerationMvtVirement(idComptePceCaisse, Caisse.getClientCaisse().getInt("ID_COMPTE_PCE"), 0L, totalEnc - longValueTotal, "Rendu sur r\u00e8glement  Ticket " + rowFinal.getString("NUMERO"), new Date(), 5, " Ticket " + rowFinal.getString("NUMERO")).genereMouvement();
                            }
                        }
                        catch (Exception exn) {
                            exn.printStackTrace();
                            throw new SQLException(exn);
                        }
                        Caisse.updateStock(rowFinal.getID());
                    }
                    for (Ticket ticket : tickets) {
                        ReceiptCode code = ticket.getReceiptCode();
                        try {
                            code.markImported();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        ReceiptCode.archiveCompletelyImported();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    final String count = String.valueOf(imported) + "/" + tickets.size();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, String.valueOf(count) + " ticket(s) import\u00e9(s). Cl\u00f4ture de la caisse termin\u00e9e.");
                        }
                    });
                    return null;
                }
            });
        }
        catch (Exception exn) {
            ExceptionHandler.handle("Une erreur est survenue pendant la cl\u00f4ture.", exn);
        }
    }

    private static SQLRow getClientCaisse() throws SQLException {
        if (rowClient == null) {
            SQLElement elt = Configuration.getInstance().getDirectory().getElement("CLIENT");
            SQLSelect sel = new SQLSelect();
            sel.addSelectStar(elt.getTable());
            sel.setWhere(new Where((FieldRef)elt.getTable().getField("NOM"), "=", (Object)"Caisse OpenConcerto"));
            List l = (List)elt.getTable().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
            if (l.size() > 0) {
                rowClient = (SQLRow)l.get(0);
            } else {
                SQLRowValues rowValues = new SQLRowValues(elt.getTable());
                rowValues.put("NOM", "Caisse OpenConcerto");
                SQLRowValues rowValuesMode = new SQLRowValues(elt.getTable().getTable("MODE_REGLEMENT"));
                rowValuesMode.put("ID_TYPE_REGLEMENT", 3);
                rowValues.put("ID_MODE_REGLEMENT", rowValuesMode);
                SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
                SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
                int idDefaultCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT");
                if (idDefaultCompteClient <= 1) {
                    try {
                        idDefaultCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                rowValues.put("ID_COMPTE_PCE", idDefaultCompteClient);
                rowClient = rowValues.insert();
            }
        }
        return rowClient;
    }

    private static void updateStock(int id) throws SQLException {
        SQLRow row = Caisse.getClientCaisse().getTable().getTable("TICKET_CAISSE").getRow(id);
        StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

            @Override
            public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                return "Ticket N\u00b0" + rowOrigin.getString("NUMERO");
            }
        }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(Caisse.getClientCaisse().getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT")), StockItemsUpdater.Type.REAL_DELIVER);
        stockUpdater.update();
    }

    public static int getID() {
        Document d = Caisse.getDocument();
        return Integer.valueOf(d.getRootElement().getAttributeValue("caisseID", "2"));
    }

    public static List<Ticket> allTickets() {
        ArrayList<Ticket> l = new ArrayList<Ticket>();
        for (File f : ReceiptCode.getReceiptsToImport(Caisse.getID())) {
            Ticket ticket = Ticket.parseFile(f);
            if (ticket == null) continue;
            l.add(ticket);
        }
        return l;
    }

    public static int getUserID() {
        Document d = Caisse.getDocument();
        return Integer.valueOf(d.getRootElement().getAttributeValue("userID", "2"));
    }

    public static int getSocieteID() {
        Document d = Caisse.getDocument();
        return Integer.valueOf(d.getRootElement().getAttributeValue("societeID", "42"));
    }

    public static boolean isCopyActive() {
        Document d = Caisse.getDocument();
        return Boolean.valueOf(d.getRootElement().getAttributeValue("copyTicket", "true"));
    }

    public static TicketPrinter getTicketPrinter() {
        if (Caisse.isUsingJPos()) {
            JPOSTicketPrinter prt = new JPOSTicketPrinter(Caisse.getJPosPrinter());
            return prt;
        }
        return new ESCSerialPrinter(Caisse.getESCPPort());
    }

    public static boolean isUsingJPos() {
        Document d = Caisse.getDocument();
        Element child = d.getRootElement().getChild("printer");
        if (child == null) {
            child = new Element("printer");
            d.getRootElement().addContent(child);
            return false;
        }
        String type = child.getAttributeValue("type");
        return type != null && type.equalsIgnoreCase("jpos");
    }

    public static String getJPosPrinter() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("jpos");
        if (children != null) {
            for (Element e : children) {
                if (e.getAttribute("printer") == null) continue;
                return e.getAttributeValue("printer");
            }
        }
        return "";
    }

    public static String getESCPPort() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("escp");
        if (children != null) {
            for (Element e : children) {
                if (e.getAttribute("port") == null) continue;
                return e.getAttributeValue("port", "COM1:");
            }
        }
        return "COM1:";
    }

    public static String getJPosDirectory() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("jpos");
        if (children != null) {
            for (Element e : children) {
                if (e.getValue() == null) continue;
                return e.getValue();
            }
        }
        return "";
    }

    public static List<TicketLine> getHeaders() {
        ArrayList<TicketLine> l = new ArrayList<TicketLine>();
        Document d = Caisse.getDocument();
        List list = d.getRootElement().getChildren("header");
        if (list != null) {
            for (Element element : list) {
                l.add(new TicketLine(element.getValue(), element.getAttributeValue("style")));
            }
        }
        return l;
    }

    public static List<TicketLine> getFooters() {
        ArrayList<TicketLine> l = new ArrayList<TicketLine>();
        Document d = Caisse.getDocument();
        List list = d.getRootElement().getChildren("footer");
        if (list != null) {
            for (Element element : list) {
                l.add(new TicketLine(element.getValue(), element.getAttributeValue("style")));
            }
        }
        return l;
    }

    public static int getTicketWidth() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("printer");
        if (children != null) {
            for (Element e : children) {
                if (e.getAttribute("printWidth") == null) continue;
                String attributeValue = e.getAttributeValue("printWidth");
                return Integer.parseInt(attributeValue);
            }
        }
        return 20;
    }
}

