/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.order.component.CommandeClientSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;

public class CommandeClientSQLElement
extends ComptaSQLConfElement {
    public CommandeClientSQLElement() {
        super("COMMANDE_CLIENT", "une commande client", "commandes clients");
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("ID_COMMERCIAL");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("NOM");
        l.add("INFOS");
        return l;
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("COMMANDE_CLIENT_ELEMENT");
        return set;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("ID_DEVIS");
        return s;
    }

    @Override
    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        super.archive(row, cutLinks);
        SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(eltMvtStock.getTable().getField("ID"));
        Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
        Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
        sel.setWhere(w.and(w2));
        List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        if (l != null) {
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
    }

    @Override
    protected SQLTableModelSourceOnline createTableSource() {
        SQLTableModelSourceOnline source = super.createTableSource();
        return source;
    }

    @Override
    public SQLComponent createComponent() {
        return new CommandeClientSQLComponent();
    }
}

