/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.account;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.component.TransfertGroupSQLComponent;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteField;
import org.openconcerto.erp.core.common.ui.AcompteRowItemView;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.invoice.ui.FactureSituationItemTable;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class VenteFactureSituationSQLComponent
extends TransfertGroupSQLComponent {
    JCheckBox box = new JCheckBox("partial");
    int countPole = 0;
    JUniqueTextField numberField;
    private final SQLTable tableNum = this.getElement().getTable().getTable("NUMEROTATION_AUTO");

    public VenteFactureSituationSQLComponent(SQLElement element) {
        super(element, (Group)GlobalMapper.getInstance().get("sales.invoice.partial"));
    }

    public VenteFactureSituationSQLComponent(SQLElement element, Group p) {
        super(element, p);
    }

    @Override
    protected Set<String> createRequiredNames() {
        HashSet<String> s = new HashSet<String>(1);
        s.add("ID_CLIENT");
        s.add("NUMERO");
        s.add("DATE");
        s.add("MONTANT_FACTURABLE");
        s.add("ID_MODE_REGLEMENT");
        return s;
    }

    @Override
    protected RowValuesTable getRowValuesTable() {
        return ((AbstractArticleItemTable)this.getEditor("sales.invoice.partial.items.list")).getRowValuesTable();
    }

    @Override
    protected void addViews() {
        super.addViews();
        this.box.setSelected(true);
        this.addView(this.box, "PARTIAL", (Object)"required");
        DeviseField totalHT = (DeviseField)this.getEditor("T_HT");
        DeviseField totalService = (DeviseField)this.getEditor("T_SERVICE");
        DeviseField totalSupply = (DeviseField)this.getEditor("T_HA");
        DeviseField totalDevise = (DeviseField)this.getEditor("T_DEVISE");
        JTextField totalWeight = (JTextField)this.getEditor("T_POIDS");
        DeviseField totalTTC = (DeviseField)this.getEditor("T_TTC");
        DeviseField totalTVA = (DeviseField)this.getEditor("T_TVA");
        DeviseField totalRemise = (DeviseField)this.getEditor("REMISE_HT");
        DeviseField totalPORT = (DeviseField)this.getEditor("PORT_HT");
        this.addView(totalPORT, "PORT_HT");
        this.addView(totalRemise, "REMISE_HT");
        this.addView(totalTVA, "T_TVA");
        this.addView(totalTTC, "T_TTC");
        this.addView(totalWeight, "T_POIDS");
        this.addView(totalDevise, "T_DEVISE");
        this.addView(totalSupply, "T_HA");
        this.addView(totalService, "T_SERVICE");
        this.addView(totalHT, "T_HT");
        final SQLRequestComboBox sqlRequestComboBox = (SQLRequestComboBox)this.getEditor("sales.invoice.customer");
        sqlRequestComboBox.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int idModeRegl;
                SQLElement sqleltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                SQLRow client = sqlRequestComboBox.getSelectedRow();
                if (client != null && !client.isUndefined() && (idModeRegl = client.getInt("ID_MODE_REGLEMENT")) > 1) {
                    SQLRow rowModeRegl = sqleltModeRegl.getTable().getRow(idModeRegl);
                    SQLRowValues rowValsModeRegl = rowModeRegl.createUpdateRow();
                    rowValsModeRegl.clearPrimaryKeys();
                    ((ElementSQLObject)VenteFactureSituationSQLComponent.this.getEditor("ID_MODE_REGLEMENT")).setValue(rowValsModeRegl);
                }
            }
        });
        sqlRequestComboBox.setEnabled(false);
        final AcompteField acompteField = (AcompteField)this.getEditor("sales.invoice.partial.amount");
        final FactureSituationItemTable table = (FactureSituationItemTable)this.getEditor("sales.invoice.partial.items.list");
        acompteField.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                Acompte a = acompteField.getValue();
                table.calculPourcentage(a, AbstractVenteArticleItemTable.TypeCalcul.CALCUL_FACTURABLE);
            }
        });
        final TotalPanel total = (TotalPanel)this.getEditor("sales.invoice.partial.total.amount");
        total.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                acompteField.setTotal(new BigDecimal(total.getTotalHT()).movePointLeft(2));
            }
        });
    }

    @Override
    public JComponent getLabel(String id) {
        if (id.equals("sales.invoice.partial.amount")) {
            JLabel jLabel = new JLabel("Montant \u00e0 facturer");
            jLabel.setHorizontalAlignment(4);
            return jLabel;
        }
        if (id.equals("sales.invoice.partial.total.amount")) {
            return new JLabel();
        }
        return super.getLabel(id);
    }

    @Override
    public JComponent createEditor(String id) {
        if (id.equals("sales.invoice.number")) {
            this.numberField = new JUniqueTextField(20);
            return this.numberField;
        }
        if (id.equals("INFOS")) {
            ITextArea jTextArea = new ITextArea();
            jTextArea.setFont(new JLabel().getFont());
            return jTextArea;
        }
        if (id.equals("sales.invoice.partial.items.list")) {
            return new FactureSituationItemTable();
        }
        if (id.equals("DATE")) {
            return new JDate(true);
        }
        if (id.equals("T_POIDS")) {
            return new JTextField();
        }
        if (id.equals("sales.invoice.partial.total.amount")) {
            AbstractArticleItemTable items = (AbstractArticleItemTable)this.getEditor("sales.invoice.partial.items.list");
            int i = 0;
            while (i < items.getRowValuesTable().getColumnModel().getColumnCount(false)) {
                SQLTableElement sqlTableElementAt = items.getRowValuesTable().getRowValuesTableModel().getSQLTableElementAt(i);
                if (sqlTableElementAt.getField() == null || !sqlTableElementAt.getField().getName().equalsIgnoreCase("ID_TAXE")) {
                    sqlTableElementAt.setEditable(false);
                } else {
                    sqlTableElementAt.setEditable(true);
                }
                ++i;
            }
            DeviseField totalHT = (DeviseField)this.getEditor("T_HT");
            DeviseField totalService = (DeviseField)this.getEditor("T_SERVICE");
            DeviseField totalSupply = (DeviseField)this.getEditor("T_HA");
            DeviseField totalDevise = (DeviseField)this.getEditor("T_DEVISE");
            JTextField totalWeight = (JTextField)this.getEditor("T_POIDS");
            DeviseField totalTTC = (DeviseField)this.getEditor("T_TTC");
            DeviseField totalTVA = (DeviseField)this.getEditor("T_TVA");
            DeviseField totalRemise = (DeviseField)this.getEditor("REMISE_HT");
            DeviseField totalPORT = (DeviseField)this.getEditor("PORT_HT");
            return new TotalPanel(items, totalHT, totalTVA, totalTTC, totalRemise, totalPORT, totalService, totalSupply, totalDevise, totalWeight, null);
        }
        if (id.startsWith("T_")) {
            return new DeviseField();
        }
        if (id.equals("REMISE_HT") || id.equals("PORT_HT")) {
            return new DeviseField();
        }
        if (id.equals("sales.invoice.partial.amount")) {
            return new AcompteField();
        }
        return super.createEditor(id);
    }

    @Override
    public int insert(SQLRow order) {
        int idSaisieVF = -1;
        if (this.numberField.checkValidation()) {
            idSaisieVF = super.insert(order);
            SQLRow rowFacture = this.getTable().getRow(idSaisieVF);
            if (NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, rowFacture.getDate("DATE").getTime()).equalsIgnoreCase(this.numberField.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                String labelNumberFor = NumerotationAutoSQLElement.getLabelNumberFor(SaisieVenteFactureSQLElement.class);
                int val = this.tableNum.getRow(2).getInt(labelNumberFor);
                rowVals.put(labelNumberFor, (Object)(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                ((AbstractArticleItemTable)this.getEditor("sales.invoice.partial.items.list")).updateField("ID_SAISIE_VENTE_FACTURE", idSaisieVF);
                new GenerationMvtSaisieVenteFacture(idSaisieVF);
                try {
                    VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rowFacture);
                    sheet.createDocument();
                    sheet.showPrintAndExport(true, false, false);
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Une erreur est survenue lors de la cr\u00e9ation du document.", e);
                }
            }
        } else {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de facture existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idSaisieVF;
    }

    @Override
    public void update() {
        super.update();
        int id = this.getSelectedID();
        ((AbstractArticleItemTable)this.getEditor("sales.invoice.partial.items.list")).updateField("ID_SAISIE_VENTE_FACTURE", id);
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date()));
        rowVals.put("PARTIAL", Boolean.TRUE);
        return rowVals;
    }

    @Override
    public Component addView(JComponent comp, String id) {
        if (id.equals("sales.invoice.partial.amount")) {
            return super.addView(new AcompteRowItemView((AcompteField)comp), "MONTANT_FACTURABLE,POURCENT_FACTURABLE", (Object)"required");
        }
        return super.addView(comp, id);
    }
}

