/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.employe.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.humanresources.employe.panel.ObjectifEditPanel;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class CommercialSQLComponent
extends BaseSQLComponent {
    private JTextField textInitiale;
    private JTextField textPrenom;
    private JTextField textNom;
    private ObjectifEditPanel objectifPanel = new ObjectifEditPanel(this.getSelectedID());
    DocumentListener listener = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            CommercialSQLComponent.this.updateInititale();
        }
    };
    private final JTabbedPane pane = new JTabbedPane();

    public CommercialSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (r == null) {
            this.objectifPanel.setIdCommercial(-1);
        } else {
            this.objectifPanel.setIdCommercial(r.getID());
        }
    }

    private void updateInititale() {
        String s = "";
        if (this.textPrenom.getText().trim().length() > 0) {
            s = String.valueOf(s) + this.textPrenom.getText().trim().charAt(0);
        }
        if (this.textNom.getText().trim().length() > 0) {
            s = String.valueOf(s) + this.textNom.getText().trim().charAt(0);
        }
        this.textInitiale.setText(s);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JPanel panelInfos = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(this.getLabelFor("ID_TITRE_PERSONNEL"));
        label.setHorizontalAlignment(4);
        panelInfos.add((Component)label, c);
        ElementComboBox selTitre = new ElementComboBox(false, 6);
        ++c.gridx;
        c.fill = 0;
        c.gridwidth = 0;
        panelInfos.add((Component)selTitre, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 2;
        JLabel label2 = new JLabel(this.getLabelFor("NOM"));
        label2.setHorizontalAlignment(4);
        panelInfos.add((Component)label2, c);
        this.textNom = new JTextField(21);
        ++c.gridx;
        c.weightx = 1.0;
        panelInfos.add((Component)this.textNom, c);
        this.textNom.getDocument().addDocumentListener(this.listener);
        ++c.gridx;
        c.weightx = 0.0;
        JLabel label3 = new JLabel(this.getLabelFor("PRENOM"));
        label3.setHorizontalAlignment(4);
        panelInfos.add((Component)label3, c);
        this.textPrenom = new JTextField(21);
        ++c.gridx;
        c.weightx = 1.0;
        panelInfos.add((Component)this.textPrenom, c);
        this.textPrenom.getDocument().addDocumentListener(this.listener);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel label4 = new JLabel("Initiales");
        label4.setHorizontalAlignment(4);
        panelInfos.add((Component)label4, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.textInitiale = new JTextField(4);
        this.textInitiale.setEditable(false);
        panelInfos.add((Component)this.textInitiale, c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 0.0;
        JLabel label5 = new JLabel(this.getLabelFor("FONCTION"));
        label5.setHorizontalAlignment(4);
        panelInfos.add((Component)label5, c);
        JTextField textFonction = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        panelInfos.add((Component)textFonction, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel label6 = new JLabel(this.getLabelFor("TEL_STANDARD"));
        label6.setHorizontalAlignment(4);
        panelInfos.add((Component)label6, c);
        ++c.gridx;
        c.weightx = 1.0;
        JTextField textTel = new JTextField();
        panelInfos.add((Component)textTel, c);
        ++c.gridx;
        c.weightx = 0.0;
        JLabel label7 = new JLabel(this.getLabelFor("TEL_DIRECT"));
        label7.setHorizontalAlignment(4);
        panelInfos.add((Component)label7, c);
        JTextField textTelD = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        panelInfos.add((Component)textTelD, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel label8 = new JLabel(this.getLabelFor("TEL_MOBILE"));
        label8.setHorizontalAlignment(4);
        panelInfos.add((Component)label8, c);
        ++c.gridx;
        c.weightx = 1.0;
        JTextField textTelM = new JTextField();
        panelInfos.add((Component)textTelM, c);
        ++c.gridx;
        c.weightx = 0.0;
        JLabel label9 = new JLabel(this.getLabelFor("TEL_PERSONEL"));
        label9.setHorizontalAlignment(4);
        panelInfos.add((Component)label9, c);
        JTextField textTelP = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        panelInfos.add((Component)textTelP, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel label10 = new JLabel(this.getLabelFor("FAX"));
        label10.setHorizontalAlignment(4);
        panelInfos.add((Component)label10, c);
        ++c.gridx;
        c.weightx = 1.0;
        JTextField textFax = new JTextField();
        panelInfos.add((Component)textFax, c);
        ++c.gridx;
        c.weightx = 0.0;
        JLabel label11 = new JLabel(this.getLabelFor("EMAIL"));
        label11.setHorizontalAlignment(4);
        panelInfos.add((Component)label11, c);
        JTextField textMail = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        panelInfos.add((Component)textMail, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        addP.setOpaque(false);
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 1));
        panelInfos.add((Component)addP, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelUser = new JLabel(this.getLabelFor("ID_USER_COMMON"));
        labelUser.setHorizontalAlignment(4);
        panelInfos.add((Component)labelUser, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        ElementComboBox comboUser = new ElementComboBox(true, 25);
        panelInfos.add((Component)comboUser, c);
        c.weighty = 1.0;
        ++c.gridy;
        JPanel panelLayouter = new JPanel();
        panelLayouter.setOpaque(false);
        panelInfos.add((Component)panelLayouter, c);
        DefaultGridBagConstraints cFull = new DefaultGridBagConstraints();
        cFull.weightx = 1.0;
        cFull.weighty = 1.0;
        cFull.fill = 1;
        if (this.getMode() == SQLComponent.Mode.MODIFICATION) {
            this.pane.add("Informations", panelInfos);
            this.pane.add("Objectifs", this.objectifPanel);
            panelInfos.setOpaque(false);
            this.add((Component)this.pane, cFull);
        } else {
            this.add((Component)panelInfos, cFull);
        }
        this.addRequiredSQLObject(selTitre, "ID_TITRE_PERSONNEL");
        selTitre.setButtonsVisible(false);
        this.addRequiredSQLObject(this.textNom, "NOM");
        this.addRequiredSQLObject(this.textPrenom, "PRENOM");
        this.addSQLObject(textFonction, "FONCTION");
        this.addSQLObject(comboUser, "ID_USER_COMMON");
        this.addSQLObject(textTel, "TEL_STANDARD");
        this.addSQLObject(textTelD, "TEL_DIRECT");
        this.addSQLObject(textTelM, "TEL_MOBILE");
        this.addSQLObject(textTelP, "TEL_PERSONEL");
        this.addSQLObject(textFax, "FAX");
        this.addSQLObject(textMail, "EMAIL");
        DefaultGridBagConstraints.lockMinimumSize(this.textInitiale);
        DefaultGridBagConstraints.lockMinimumSize(selTitre);
    }
}

