/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.tax.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ExceptionHandler;

public final class TaxeCache {
    private final transient Map<Integer, Float> mapTaux = new HashMap<Integer, Float>();
    private final transient Map<SQLRowAccessor, Float> mapRowTaux = new LinkedHashMap<SQLRowAccessor, Float>();
    private static TaxeCache instance;
    private transient SQLRow firstIdTaxe = null;

    private static final SQLSelect getSel() {
        DBRoot root = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete();
        SQLTable table = root.getTable("TAXE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(table.getField("ID_TAXE"));
        sel.addSelect(table.getField("TAUX"));
        sel.addSelect(table.getField("DEFAULT"));
        return sel;
    }

    private TaxeCache() {
        SQLSelect sel = TaxeCache.getSel();
        List<SQLRow> l = SQLRowListRSH.execute(sel);
        for (SQLRow sqlRow : l) {
            this.mapRowTaux.put(sqlRow, Float.valueOf(sqlRow.getFloat("TAUX")));
            this.mapTaux.put(sqlRow.getID(), Float.valueOf(sqlRow.getFloat("TAUX")));
            if (!sqlRow.getBoolean("DEFAULT").booleanValue()) continue;
            this.firstIdTaxe = sqlRow;
        }
    }

    public static synchronized TaxeCache getCache() {
        if (instance == null) {
            instance = new TaxeCache();
        }
        return instance;
    }

    public Float getTauxFromId(int idTaux) {
        return this.mapTaux.get(idTaux);
    }

    public SQLRow getFirstTaxe() {
        if (this.firstIdTaxe == null) {
            SQLSelect sel = TaxeCache.getSel();
            sel.setWhere(new Where((FieldRef)sel.getTable("TAXE").getField("DEFAULT"), "=", (Object)Boolean.TRUE));
            List<SQLRow> rows = SQLRowListRSH.execute(sel);
            if (rows != null && !rows.isEmpty()) {
                this.firstIdTaxe = rows.get(0);
            } else {
                ExceptionHandler.handle("Aucune TVA par d\u00e9faut d\u00e9finie!", new IllegalArgumentException("Aucune TVA par d\u00e9faut d\u00e9finie!"));
                return this.mapRowTaux.keySet().iterator().next().asRow();
            }
        }
        return this.firstIdTaxe;
    }
}

