/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.view.list.KeyTableCellRenderer;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.TimestampTableCellEditor;

public class RegleMontantTable
extends JPanel {
    protected RowValuesTable table;
    protected RowValuesTableModel model;
    SQLTableElement montantRegle;
    SQLTableElement montantARegler;

    public RegleMontantTable() {
        this.init();
        this.uiInit();
    }

    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement tableElement_Mvt = new SQLTableElement(e.getTable().getField("ID_MOUVEMENT_ECHEANCE"), Integer.class, new DefaultCellEditor(new JTextField()));
        tableElement_Mvt.setRenderer(new KeyTableCellRenderer(Configuration.getInstance().getDirectory().getElement("MOUVEMENT")));
        list.add(tableElement_Mvt);
        SQLTableElement dateElement = new SQLTableElement(e.getTable().getField("DATE"), Timestamp.class, new TimestampTableCellEditor());
        list.add(dateElement);
        this.montantARegler = new SQLTableElement(e.getTable().getField("MONTANT_A_REGLER"), Long.class, new DeviseCellEditor());
        this.montantARegler.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.montantARegler);
        this.montantRegle = new SQLTableElement(e.getTable().getField("MONTANT_REGLE"), Long.class, new DeviseCellEditor());
        this.montantRegle.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.montantRegle);
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("MONTANT_REGLE"), false);
        this.table = new RowValuesTable(this.model, null, true);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("REGLER_MONTANT_ELEMENT");
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public RowValuesTable getRowValuesTable() {
        return this.table;
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public SQLTableElement getMontantElement() {
        return this.montantRegle;
    }

    public SQLTableElement getMontantAReglerElement() {
        return this.montantARegler;
    }
}

