/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.model.BanqueModifiedListener;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLSearchableTextCombo;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextCombo;
import org.openconcerto.utils.CollectionUtils;

public class ModeDeReglementSQLComponent
extends BaseSQLComponent {
    private final ElementComboBox boxBanque = new ElementComboBox(true, 20);
    private final JPanel panelBanque = new JPanel(new GridBagLayout());
    private final JPanel panelEcheance = new JPanel(new GridBagLayout());
    private final EventListenerList banqueModifiedListenerList = new EventListenerList();
    private final SQLRequestComboBox comboTypeReglement = new SQLRequestComboBox();
    private ITextCombo comboA;
    private final ITextCombo comboLe = new SQLTextCombo();
    private final SQLSearchableTextCombo comboBanque = new SQLSearchableTextCombo();
    private final JRadioButton buttonFinMois = new JRadioButton("fin de mois");
    private final JRadioButton buttonDateFacture = new JRadioButton("date de facturation");
    private final JRadioButton buttonLe = new JRadioButton("le");
    private final JCheckBox checkboxComptant = new JCheckBox("Comptant");
    private final JDate dateDepot = new JDate(false);
    private final JDate dateVirt = new JDate(false);
    private final JDate dateCheque = new JDate(false);
    private final JTextField numeroChq = new JTextField();
    private final JTextField nom = new JTextField(30);
    private JPanel panelActive = null;
    private final Map<Mode, JPanel> m = new HashMap<Mode, JPanel>();
    private int rowIdMode;
    private final JPanel infosCheque = new JPanel(new GridBagLayout());
    private final JPanel infosVirt = new JPanel(new GridBagLayout());

    private void setComponentModeEnabled(SQLRow rowTypeRegl) {
        if (rowTypeRegl == null || this.rowIdMode == rowTypeRegl.getID()) {
            return;
        }
        this.rowIdMode = rowTypeRegl.getID();
        System.err.println("ModeDeReglementNGSQLComponent.setComponentModeEnabled() " + this.rowIdMode);
        ButtonGroup group = new ButtonGroup();
        group.add(this.buttonFinMois);
        group.add(this.buttonDateFacture);
        group.add(this.buttonLe);
        Boolean forceLater = rowTypeRegl.getBoolean("ECHEANCE");
        Boolean forceNow = rowTypeRegl.getBoolean("COMPTANT");
        if (forceLater.booleanValue() && forceNow.booleanValue()) {
            Log.get().warning("Force opposite for " + rowTypeRegl);
        }
        this.allowEditable(this.getView(this.checkboxComptant), forceLater == false && forceNow == false);
        if (forceLater.booleanValue()) {
            this.checkboxComptant.setSelected(false);
        }
        if (forceNow.booleanValue()) {
            this.checkboxComptant.setSelected(true);
        }
        this.updatePanel();
    }

    public ModeDeReglementSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    protected Set<String> createRequiredNames() {
        return CollectionUtils.createSet("ID_TYPE_REGLEMENT");
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        c.anchor = 17;
        this.comboA = new SQLTextCombo(false);
        DefaultGridBagConstraints cB = new DefaultGridBagConstraints();
        this.panelBanque.add((Component)new JLabel(this.getLabelFor("ID_" + BanqueSQLElement.TABLENAME)), cB);
        cB.weightx = 1.0;
        ++cB.gridx;
        this.panelBanque.add((Component)this.boxBanque, cB);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.panelBanque, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        ++c.gridy;
        c.gridheight = 1;
        this.add((Component)new JLabel("R\u00e8glement par"), c);
        this.comboTypeReglement.setPreferredSize(new Dimension(80, new JTextField().getPreferredSize().height));
        DefaultGridBagConstraints.lockMinimumSize(this.comboTypeReglement);
        ++c.gridx;
        c.fill = 2;
        this.add((Component)this.comboTypeReglement, c);
        c.gridheight = 1;
        ++c.gridx;
        DefaultGridBagConstraints.lockMinimumSize(this.checkboxComptant);
        this.add((Component)this.checkboxComptant, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.fill = 2;
        c.gridheight = 0;
        this.createPanelChequeComptant();
        this.add((Component)this.infosCheque, c);
        this.createPanelVirementComptant();
        this.add((Component)this.infosVirt, c);
        this.createPanelEcheance();
        this.add((Component)this.panelEcheance, c);
        this.addView(this.comboTypeReglement, "ID_TYPE_REGLEMENT");
        this.addView(this.checkboxComptant, "COMPTANT");
        this.addSQLObject(this.comboBanque, "ETS");
        this.addSQLObject(this.numeroChq, "NUMERO");
        this.addSQLObject((JComponent)((Object)this.dateCheque), "DATE");
        this.addSQLObject((JComponent)((Object)this.dateDepot), "DATE_DEPOT");
        this.addSQLObject(this.nom, "NOM");
        this.addSQLObject((JComponent)((Object)this.dateVirt), "DATE_VIREMENT");
        this.addRequiredSQLObject(this.comboA, "AJOURS");
        this.addSQLObject(this.buttonDateFacture, "DATE_FACTURE");
        this.addSQLObject(this.buttonFinMois, "FIN_MOIS");
        this.addRequiredSQLObject(this.comboLe, "LENJOUR");
        this.addSQLObject(this.boxBanque, "ID_" + BanqueSQLElement.TABLENAME);
        this.boxBanque.setButtonsVisible(false);
        this.boxBanque.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer i = ModeDeReglementSQLComponent.this.boxBanque.getWantedID();
                int value = i == null ? -1 : Integer.valueOf(i);
                ModeDeReglementSQLComponent.this.fireBanqueIdChange(value);
            }
        });
        this.comboTypeReglement.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer id = ModeDeReglementSQLComponent.this.comboTypeReglement.getValue();
                if (id != null && id > 1) {
                    SQLRow ligneTypeReg = SQLBackgroundTableCache.getInstance().getCacheForTable(ModeDeReglementSQLComponent.this.getTable().getBase().getTable("TYPE_REGLEMENT")).getRowFromId(id);
                    ModeDeReglementSQLComponent.this.setComponentModeEnabled(ligneTypeReg);
                }
            }
        });
        this.buttonLe.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ModeDeReglementSQLComponent.this.allowEditable(ModeDeReglementSQLComponent.this.getView(ModeDeReglementSQLComponent.this.comboLe), e.getStateChange() == 1 && !ModeDeReglementSQLComponent.this.checkboxComptant.isSelected());
            }
        });
        this.allowEditable(this.getView(this.comboLe), false);
        this.buttonFinMois.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModeDeReglementSQLComponent.this.comboLe.setValue(String.valueOf(31));
                }
            }
        });
        this.buttonDateFacture.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModeDeReglementSQLComponent.this.comboLe.setValue(String.valueOf(0));
                }
            }
        });
        this.getView(this.comboLe).addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Number newVal = (Number)evt.getNewValue();
                if (newVal != null && newVal.intValue() != 0 && newVal.intValue() != 31) {
                    ModeDeReglementSQLComponent.this.buttonLe.setSelected(true);
                }
            }
        });
        this.checkboxComptant.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ModeDeReglementSQLComponent.this.setEcheanceEnabled(e.getStateChange() == 2);
            }
        });
    }

    private void createPanelEcheance() {
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        this.panelEcheance.setOpaque(false);
        this.panelEcheance.add((Component)new JLabel("A"), c);
        ++c.gridx;
        c.gridwidth = 1;
        this.comboA.setMinimumSize(new Dimension(60, this.comboA.getMinimumSize().height));
        this.comboA.setPreferredSize(new Dimension(60, this.comboA.getMinimumSize().height));
        this.comboA.setMaximumSize(new Dimension(60, this.comboA.getMinimumSize().height));
        this.panelEcheance.add((Component)this.comboA, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.panelEcheance.add((Component)new JLabel("jours,"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.fill = 2;
        this.buttonDateFacture.setOpaque(false);
        this.panelEcheance.add((Component)this.buttonDateFacture, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonFinMois.setOpaque(false);
        this.panelEcheance.add((Component)this.buttonFinMois, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.buttonLe.setOpaque(false);
        this.panelEcheance.add((Component)this.buttonLe, c);
        ++c.gridx;
        this.comboLe.setMinimumSize(new Dimension(60, this.comboLe.getMinimumSize().height));
        this.comboLe.setPreferredSize(new Dimension(60, this.comboLe.getMinimumSize().height));
        this.comboLe.setMaximumSize(new Dimension(60, this.comboLe.getMinimumSize().height));
        this.panelEcheance.add((Component)this.comboLe, c);
        this.panelActive = this.panelEcheance;
        this.m.put(Mode.ECHEANCE, this.panelEcheance);
        DefaultGridBagConstraints.lockMinimumSize(this.panelEcheance);
    }

    public void createPanelChequeComptant() {
        DefaultGridBagConstraints cCheque = new DefaultGridBagConstraints();
        this.infosCheque.add((Component)new JLabel("Banque"), cCheque);
        ++cCheque.gridx;
        this.infosCheque.add((Component)this.comboBanque, cCheque);
        ++cCheque.gridx;
        this.infosCheque.add((Component)new JLabel("N\u00b0"), cCheque);
        ++cCheque.gridx;
        DefaultGridBagConstraints.lockMinimumSize(this.numeroChq);
        this.infosCheque.add((Component)this.numeroChq, cCheque);
        ++cCheque.gridy;
        cCheque.gridx = 0;
        this.infosCheque.add((Component)new JLabel("Dat\u00e9 du"), cCheque);
        ++cCheque.gridx;
        this.infosCheque.add((Component)((Object)this.dateCheque), cCheque);
        JLabel labelDepot = new JLabel("A d\u00e9poser apr\u00e8s le");
        ++cCheque.gridx;
        DefaultGridBagConstraints.lockMinimumSize(this.infosCheque);
        this.infosCheque.add((Component)labelDepot, cCheque);
        ++cCheque.gridx;
        this.infosCheque.add((Component)((Object)this.dateDepot), cCheque);
        this.m.put(Mode.CHEQUE, this.infosCheque);
        this.infosCheque.setVisible(false);
        DefaultGridBagConstraints.lockMinimumSize(this.infosCheque);
    }

    public void createPanelVirementComptant() {
        DefaultGridBagConstraints cCheque = new DefaultGridBagConstraints();
        cCheque.weightx = 1.0;
        this.infosVirt.add((Component)new JLabel("Libell\u00e9"), cCheque);
        ++cCheque.gridx;
        this.infosVirt.add((Component)this.nom, cCheque);
        ++cCheque.gridy;
        cCheque.gridx = 0;
        cCheque.fill = 0;
        cCheque.weightx = 0.0;
        this.infosVirt.add((Component)new JLabel("Dat\u00e9 du"), cCheque);
        ++cCheque.gridx;
        this.infosVirt.add((Component)((Object)this.dateVirt), cCheque);
        this.m.put(Mode.VIREMENT, this.infosVirt);
        this.infosVirt.setVisible(false);
        DefaultGridBagConstraints.lockMinimumSize(this.infosVirt);
    }

    private void updatePanel() {
        Integer typeReglt = this.comboTypeReglement.getValue();
        if (typeReglt == null) {
            return;
        }
        boolean comptant = this.checkboxComptant.isSelected();
        Mode mode = comptant && typeReglt == 2 ? Mode.CHEQUE : (comptant && typeReglt == 5 ? Mode.VIREMENT : Mode.ECHEANCE);
        this.replacePanel(mode);
    }

    private void replacePanel(Mode mode) {
        JPanel panel = this.m.get((Object)mode);
        if (panel != this.panelActive) {
            this.panelActive.setVisible(false);
            panel.setVisible(true);
            this.panelActive = panel;
        }
    }

    private void fireBanqueIdChange(int id) {
        BanqueModifiedListener[] l;
        BanqueModifiedListener[] banqueModifiedListenerArray = l = (BanqueModifiedListener[])this.banqueModifiedListenerList.getListeners(BanqueModifiedListener.class);
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            BanqueModifiedListener banqueModifiedListener = banqueModifiedListenerArray[n2];
            banqueModifiedListener.idChange(id);
            ++n2;
        }
    }

    private void setEcheanceEnabled(boolean b) {
        this.allowEditable(this.getView(this.comboA), b);
        this.allowEditable(this.getView(this.comboLe), b && this.buttonLe.isSelected());
        this.allowEditable(this.getView(this.buttonFinMois), b);
        this.allowEditable(this.getView(this.buttonDateFacture), b);
        this.buttonLe.setEnabled(b);
        if (!b) {
            this.comboA.setValue("0");
            this.buttonDateFacture.setSelected(true);
        } else {
            this.comboA.setValue("30");
            this.buttonFinMois.setSelected(true);
        }
        this.updatePanel();
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        vals.put("COMPTANT", Boolean.FALSE);
        vals.put("AJOURS", 30);
        vals.put("FIN_MOIS", Boolean.TRUE);
        return vals;
    }

    private static enum Mode {
        ECHEANCE,
        CHEQUE,
        VIREMENT;

    }
}

