/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.SaisieKmItemTable;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieKm;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SaisieKmSQLElement
extends ComptaSQLConfElement {
    public SaisieKmSQLElement() {
        super("SAISIE_KM", "une saisie au kilom\u00e8tre", "saisies au kilom\u00e8tre");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("ID_JOURNAL");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new SaisieKmComponent();
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("SAISIE_KM_ELEMENT");
        return set;
    }

    public static int createSaisie(int idMvt) throws SQLException {
        SQLTable mouvementTable;
        SQLRow rowMvt;
        int idSaisie = 1;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable ecrTable = base.getTable("ECRITURE");
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLTable saisieKmTable = base.getTable("SAISIE_KM_ELEMENT");
        SQLRowValues vals = new SQLRowValues(base.getTable("SAISIE_KM"));
        vals.put("ID_MOUVEMENT", new Integer(idMvt));
        SQLRow rowSaisieKm = vals.insert();
        idSaisie = rowSaisieKm.getID();
        SQLSelect selEcriture = new SQLSelect();
        selEcriture.addSelect(ecrTable.getField("ID"));
        Where w = new Where((FieldRef)ecrTable.getField("ID_MOUVEMENT"), "=", idMvt);
        selEcriture.setWhere(w);
        String reqEcriture = selEcriture.asString();
        Object obEcriture = base.getDataSource().execute(reqEcriture, new ArrayListHandler());
        List myListEcriture = (List)obEcriture;
        if (myListEcriture.size() != 0) {
            int i = 0;
            while (i < myListEcriture.size()) {
                Object[] objTmp = (Object[])myListEcriture.get(i);
                SQLRow rowEcrTmp = ecrTable.getRow(Integer.parseInt(objTmp[0].toString()));
                SQLRow rowCompteTmp = compteTable.getRow(rowEcrTmp.getInt("ID_COMPTE_PCE"));
                SQLRowValues valsTmp = new SQLRowValues(saisieKmTable);
                valsTmp.put("ID_SAISIE_KM", new Integer(rowSaisieKm.getID()));
                valsTmp.put("NUMERO", rowCompteTmp.getString("NUMERO"));
                valsTmp.put("NOM", rowCompteTmp.getString("NOM"));
                valsTmp.put("NOM_ECRITURE", rowEcrTmp.getString("NOM"));
                valsTmp.put("DEBIT", rowEcrTmp.getObject("DEBIT"));
                valsTmp.put("CREDIT", rowEcrTmp.getObject("CREDIT"));
                valsTmp.put("ID_ECRITURE", new Integer(rowEcrTmp.getID()));
                valsTmp.insert();
                ++i;
            }
            Object[] objTmp = (Object[])myListEcriture.get(0);
            SQLRow rowEcrTmp = ecrTable.getRow(Integer.parseInt(objTmp[0].toString()));
            vals.put("NOM", rowEcrTmp.getString("NOM"));
            vals.put("DATE", rowEcrTmp.getObject("DATE"));
            vals.put("ID_JOURNAL", rowEcrTmp.getObject("ID_JOURNAL"));
            vals.update(idSaisie);
        }
        if ((rowMvt = (mouvementTable = base.getTable("MOUVEMENT")).getRow(idMvt)).getString("SOURCE").trim().length() == 0 || rowMvt.getInt("IDSOURCE") == 1) {
            SQLRowValues valsMouvement = new SQLRowValues(mouvementTable);
            valsMouvement.put("SOURCE", "SAISIE_KM");
            valsMouvement.put("IDSOURCE", new Integer(rowSaisieKm.getID()));
            valsMouvement.update(idMvt);
        }
        return idSaisie;
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".userentry";
    }

    class SaisieKmComponent
    extends BaseSQLComponent {
        private JTextField textNom;
        private JDate date;
        private RowValuesTableModel model;
        private ElementComboBox comboJrnl;
        private JLabel labelTotalDebit;
        private JLabel labelTotalCredit;
        private long totalCred;
        private long totalDeb;
        private int debitIndex;
        private int creditIndex;
        private JCheckBox checkCreateCompte;
        private JCheckBox checkCreateLineAuto;
        private boolean isCompteExist;
        private boolean allLineValid;
        private SaisieKmItemTable tableKm;
        private final JLabel labelMotifWarning;
        private SQLElement eltKmItem;
        private SQLRowValues defaultEcritureRowVals;
        private ValidState validState;
        private ValidState validStateCloture;
        private final SQLRow rowExercice;
        private TableModelListener tableListener;
        private Date dTemp;

        public SaisieKmComponent() {
            super(SaisieKmSQLElement.this);
            this.isCompteExist = false;
            this.allLineValid = true;
            this.labelMotifWarning = new JLabelWarning();
            this.eltKmItem = Configuration.getInstance().getDirectory().getElement("SAISIE_KM_ELEMENT");
            this.defaultEcritureRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.eltKmItem.getTable()));
            this.validState = ValidState.getTrueInstance();
            this.validStateCloture = ValidState.getTrueInstance();
            this.rowExercice = ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getForeign("ID_EXERCICE_COMMON");
            this.tableListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    SaisieKmComponent.this.tableChanged(e);
                }
            };
            this.dTemp = null;
        }

        @Override
        public void addViews() {
            this.setLayout(new GridBagLayout());
            DefaultGridBagConstraints c = new DefaultGridBagConstraints();
            this.textNom = new JTextField();
            this.labelTotalCredit = new JLabel("0.00", 4);
            this.labelTotalDebit = new JLabel("0.00", 4);
            this.date = new JDate();
            this.date.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Calendar cDeb = SaisieKmComponent.this.rowExercice.getDate("DATE_DEB");
                    Calendar cClo = SaisieKmComponent.this.rowExercice.getDate("DATE_CLOTURE");
                    if (SaisieKmComponent.this.date.getValue() != null && cDeb.getTime().after(SaisieKmComponent.this.date.getValue())) {
                        SaisieKmComponent.this.validStateCloture = new ValidState(false, "La date de saisie doit \u00eatre sup\u00e9rieure \u00e0 celle du d\u00e9but de l'exercice!");
                    } else if (SaisieKmComponent.this.date.getValue() != null && cClo != null && cClo.getTime().after(SaisieKmComponent.this.date.getValue())) {
                        SaisieKmComponent.this.validStateCloture = new ValidState(false, "La date de saisie doit \u00eatre sup\u00e9rieure \u00e0 celle de la p\u00e9riode de cl\u00f4ture d\u00e9finie dans l'exercice courant!");
                    } else {
                        SaisieKmComponent.this.validStateCloture = ValidState.getTrueInstance();
                    }
                    SaisieKmComponent.this.fireValidChange();
                }
            });
            this.comboJrnl = new ElementComboBox(false, 20);
            this.add((Component)new JLabel("Libell\u00e9", 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 1;
            this.add((Component)this.textNom, c);
            JLabel labelDate = new JLabel("Date");
            ++c.gridx;
            c.weightx = 0.0;
            c.gridwidth = 1;
            this.add((Component)labelDate, c);
            ++c.gridx;
            c.gridwidth = 1;
            this.add((Component)((Object)this.date), c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Journal", 4), c);
            ++c.gridx;
            c.gridwidth = 3;
            c.fill = 0;
            c.weightx = 1.0;
            this.add((Component)this.comboJrnl, c);
            this.tableKm = new SaisieKmItemTable(this.defaultEcritureRowVals);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            c.fill = 1;
            this.add((Component)this.tableKm, c);
            JPanel panelTotal = new JPanel();
            panelTotal.setLayout(new GridBagLayout());
            panelTotal.setBorder(BorderFactory.createTitledBorder("Totaux"));
            DefaultGridBagConstraints cc = new DefaultGridBagConstraints();
            cc.anchor = 13;
            cc.fill = 0;
            panelTotal.add((Component)new JLabel("D\u00e9bit"), cc);
            cc.fill = 2;
            ++cc.gridx;
            cc.weightx = 1.0;
            panelTotal.add((Component)this.labelTotalDebit, cc);
            ++cc.gridy;
            cc.gridx = 0;
            cc.weightx = 0.0;
            cc.fill = 0;
            panelTotal.add((Component)new JLabel("Cr\u00e9dit"), cc);
            cc.weightx = 1.0;
            ++cc.gridx;
            cc.fill = 2;
            panelTotal.add((Component)this.labelTotalCredit, cc);
            this.checkCreateCompte = new JCheckBox("Cr\u00e9ation automatique des comptes");
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.checkCreateCompte, c);
            this.checkCreateLineAuto = new JCheckBox("Ligne de contrepartie automatique");
            ++c.gridy;
            this.checkCreateLineAuto.setSelected(true);
            this.add((Component)this.checkCreateLineAuto, c);
            ++c.gridy;
            c.weightx = 0.0;
            c.gridwidth = 2;
            this.labelMotifWarning.setText("Le solde des \u00e9critures n'est pas nul!");
            DefaultGridBagConstraints.lockMinimumSize(this.labelMotifWarning);
            this.add((Component)this.labelMotifWarning, c);
            this.labelMotifWarning.setVisible(false);
            c.gridwidth = 1;
            --c.gridy;
            c.gridx = 2;
            c.anchor = 13;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.gridwidth = 2;
            c.gridheight = 2;
            panelTotal.setPreferredSize(new Dimension(250, panelTotal.getPreferredSize().height));
            DefaultGridBagConstraints.lockMinimumSize(panelTotal);
            this.add((Component)panelTotal, c);
            this.model = this.tableKm.getModel();
            this.creditIndex = this.model.getColumnIndexForElement(this.tableKm.getCreditElement());
            this.debitIndex = this.model.getColumnIndexForElement(this.tableKm.getDebitElement());
            this.tableKm.getModel().addTableModelListener(this.tableListener);
            this.addSQLObject(this.textNom, "NOM");
            this.addRequiredSQLObject((JComponent)((Object)this.date), "DATE");
            this.addRequiredSQLObject(this.comboJrnl, "ID_JOURNAL");
            this.comboJrnl.setButtonsVisible(false);
            this.textNom.getDocument().addDocumentListener(new SimpleDocumentListener(){
                String previousName = "";

                @Override
                public void update(DocumentEvent e) {
                    SaisieKmComponent.this.defaultEcritureRowVals.put("NOM_ECRITURE", SaisieKmComponent.this.textNom.getText());
                    SaisieKmComponent.this.tableKm.fillEmptyEntryLabel(this.previousName, SaisieKmComponent.this.textNom.getText());
                    this.previousName = SaisieKmComponent.this.textNom.getText();
                }
            });
            this.checkCreateCompte.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SaisieKmComponent.this.tableKm.setCreateAutoActive(SaisieKmComponent.this.checkCreateCompte.isSelected());
                    SaisieKmComponent.this.updateValidState();
                }
            });
            DefaultGridBagConstraints.lockMinimumSize(this.comboJrnl);
        }

        @Override
        public int insert(SQLRow order) {
            final int id = super.insert(order);
            this.tableKm.updateField("ID_SAISIE_KM", id);
            try {
                SQLUtils.executeAtomic(Configuration.getInstance().getSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

                    @Override
                    public Object create() throws SQLException {
                        GenerationMvtSaisieKm gen = new GenerationMvtSaisieKm(id);
                        int idMvt = gen.genereMouvement();
                        SQLRowValues valEcriture = new SQLRowValues(SaisieKmSQLElement.this.getTable());
                        valEcriture.put("ID_MOUVEMENT", new Integer(idMvt));
                        if (valEcriture.getInvalid() == null) {
                            valEcriture.update(id);
                        }
                        SQLElement eltMvt = Configuration.getInstance().getDirectory().getElement("MOUVEMENT");
                        final SQLRow rowMvt = eltMvt.getTable().getRow(idMvt);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(SaisieKmComponent.this, "Num\u00e9ro de mouvement associ\u00e9 : " + rowMvt.getObject("NUMERO"));
                            }
                        });
                        return null;
                    }
                });
            }
            catch (SQLException exn) {
                ExceptionHandler.handle("Erreur lors de la cr\u00e9ation des \u00e9critures associ\u00e9es \u00e0 la saisie au kilometre.", exn);
            }
            return id;
        }

        @Override
        public void select(SQLRowAccessor r) {
            if (r == null) {
                this.dTemp = this.date.getDate();
            }
            super.select(r);
            if (r != null) {
                this.tableKm.insertFrom(r);
            }
        }

        @Override
        public void update() {
            super.update();
            this.tableKm.updateField("ID_SAISIE_KM", this.getSelectedID());
            System.err.println("UPDATE ECRITURE");
            this.updateEcriture();
        }

        @Override
        protected SQLRowValues createDefaults() {
            assert (SwingUtilities.isEventDispatchThread());
            SQLRowValues rowVals = new SQLRowValues(this.getTable());
            if (this.dTemp != null) {
                rowVals.put("DATE", this.dTemp);
            }
            this.tableKm.getModel().clearRows();
            this.tableKm.revalidate();
            this.tableKm.repaint();
            return rowVals;
        }

        public void updateEcriture() {
            try {
                SQLUtils.executeAtomic(Configuration.getInstance().getSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

                    @Override
                    public Object create() throws SQLException {
                        SQLTable ecritureTable = SaisieKmComponent.this.getTable().getBase().getTable("ECRITURE");
                        SQLRow rowSaisieKm = SaisieKmComponent.this.getElement().getTable().getRow(SaisieKmComponent.this.getSelectedID());
                        Collection myListDevisItem = rowSaisieKm.getReferentRows(SaisieKmComponent.this.getTable().getBase().getTable("SAISIE_KM_ELEMENT"));
                        Collection listEcr = rowSaisieKm.getForeignRow("ID_MOUVEMENT").getReferentRows(ecritureTable);
                        if (myListDevisItem != null) {
                            for (SQLRow rowElement : myListDevisItem) {
                                int idCpt = ComptePCESQLElement.getId(rowElement.getString("NUMERO"), rowElement.getString("NOM"));
                                if (rowElement.getID() <= 1) continue;
                                SQLRowValues vals = new SQLRowValues(ecritureTable);
                                vals.put("ID_COMPTE_PCE", idCpt);
                                vals.put("COMPTE_NUMERO", rowElement.getString("NUMERO"));
                                vals.put("COMPTE_NOM", rowElement.getString("NOM"));
                                vals.put("DEBIT", rowElement.getObject("DEBIT"));
                                vals.put("CREDIT", rowElement.getObject("CREDIT"));
                                vals.put("DATE", rowSaisieKm.getObject("DATE"));
                                SQLRow rowJournal = rowSaisieKm.getForeignRow("ID_JOURNAL");
                                vals.put("ID_JOURNAL", rowJournal.getID());
                                vals.put("JOURNAL_NOM", rowJournal.getString("NOM"));
                                vals.put("JOURNAL_CODE", rowJournal.getString("CODE"));
                                vals.put("NOM", rowElement.getObject("NOM_ECRITURE"));
                                if (rowElement.getInt("ID_ECRITURE") > 1) {
                                    SQLRow rowTmp = ecritureTable.getRow(rowElement.getInt("ID_ECRITURE"));
                                    if (!rowTmp.getBoolean("VALIDE").booleanValue()) {
                                        vals.update(rowElement.getInt("ID_ECRITURE"));
                                    } else {
                                        System.err.println("Impossible de modifier une ecriture valide");
                                    }
                                } else {
                                    vals.put("ID_MOUVEMENT", rowSaisieKm.getObject("ID_MOUVEMENT"));
                                    if (MouvementSQLElement.isEditable(rowSaisieKm.getInt("ID_MOUVEMENT"))) {
                                        SQLRow rowEcr = vals.insert();
                                        SQLRowValues rowElementVals = rowElement.createEmptyUpdateRow();
                                        rowElementVals.put("ID_ECRITURE", rowEcr.getID());
                                        rowElement = rowElementVals.update();
                                    }
                                }
                                ArrayList l = new ArrayList(listEcr);
                                for (SQLRow sqlRow : l) {
                                    if (sqlRow.getID() != rowElement.getInt("ID_ECRITURE")) continue;
                                    listEcr.remove(sqlRow);
                                }
                            }
                        }
                        if (!listEcr.isEmpty()) {
                            EcritureSQLElement e = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement(ecritureTable);
                            for (SQLRow sqlRow : listEcr) {
                                e.archiveEcriture(sqlRow);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (SQLException exn) {
                ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour des \u00e9critures associ\u00e9es \u00e0 la saisie au kilometre.", exn);
            }
        }

        @Override
        public synchronized ValidState getValidState() {
            assert (SwingUtilities.isEventDispatchThread());
            return super.getValidState().and(this.validState).and(this.validStateCloture);
        }

        private void updateValidState() {
            assert (SwingUtilities.isEventDispatchThread());
            ValidState state = ValidState.create(!this.labelMotifWarning.isVisible(), this.labelMotifWarning.getText());
            if (!this.isCompteExist && !this.checkCreateCompte.isSelected()) {
                state = state.and(ValidState.createCached(false, "Certains comptes n'existent pas"));
            }
            if (!this.allLineValid) {
                state = state.and(ValidState.createCached(false, "Certaines lignes n'ont pas de cr\u00e9dit ni de d\u00e9bit"));
            }
            this.setValidState(state);
        }

        private void setValidState(ValidState state) {
            assert (SwingUtilities.isEventDispatchThread());
            if (!state.equals(this.validState)) {
                this.validState = state;
                this.fireValidChange();
            }
        }

        private void setTotals(long totalCred, long totalDeb) {
            assert (SwingUtilities.isEventDispatchThread());
            this.totalCred = totalCred;
            this.totalDeb = totalDeb;
            this.labelTotalCredit.setText(GestionDevise.currencyToString(this.totalCred));
            this.labelTotalDebit.setText(GestionDevise.currencyToString(this.totalDeb));
            long diff = this.totalDeb - this.totalCred;
            String reason = diff == 0L ? null : (diff > 0L ? "Le solde des \u00e9critures n'est pas nul! Il manque " + GestionDevise.currencyToString(diff) + " en cr\u00e9dit." : "Le solde des \u00e9critures n'est pas nul! Il manque " + GestionDevise.currencyToString(diff) + " en d\u00e9bit.");
            this.labelMotifWarning.setVisible(reason != null);
            if (reason != null) {
                this.labelMotifWarning.setText(reason);
            }
        }

        private void tableChanged(TableModelEvent e) {
            assert (SwingUtilities.isEventDispatchThread());
            long totalCred = 0L;
            long totalDeb = 0L;
            long totalCredWithNoValid = 0L;
            long totalDebWithNoValid = 0L;
            boolean isCompteExist = true;
            boolean allLineValid = true;
            int i = 0;
            while (i < this.model.getRowCount()) {
                boolean rowValid = this.model.isRowValid(i);
                long fTc = ((Number)this.model.getValueAt(i, this.creditIndex)).longValue();
                long fTd = ((Number)this.model.getValueAt(i, this.debitIndex)).longValue();
                String numCpt = this.model.getValueAt(i, this.model.getColumnIndexForElement(this.tableKm.getNumeroCompteElement())).toString();
                isCompteExist &= ComptePCESQLElement.isExist(numCpt);
                if (fTc != 0L && fTd != 0L) {
                    return;
                }
                if (rowValid) {
                    totalCred += fTc;
                    totalDeb += fTd;
                }
                totalCredWithNoValid += fTc;
                totalDebWithNoValid += fTd;
                boolean emptyAmount = fTc == 0L && fTd == 0L;
                this.tableKm.setRowDeviseValidAt(!emptyAmount, i);
                allLineValid &= !emptyAmount;
                ++i;
            }
            this.tableKm.revalidate();
            this.tableKm.repaint();
            this.isCompteExist = isCompteExist;
            this.allLineValid = allLineValid;
            this.setTotals(totalCred, totalDeb);
            this.updateValidState();
            long diffWithNoValid = totalDebWithNoValid - totalCredWithNoValid;
            if (diffWithNoValid != 0L) {
                if (diffWithNoValid > 0L) {
                    this.defaultEcritureRowVals.put("DEBIT", 0L);
                    this.defaultEcritureRowVals.put("CREDIT", diffWithNoValid);
                } else {
                    this.defaultEcritureRowVals.put("DEBIT", -diffWithNoValid);
                    this.defaultEcritureRowVals.put("CREDIT", 0L);
                }
                if (this.model.isLastRowValid() && this.checkCreateLineAuto.isSelected()) {
                    this.tableKm.getModel().addRow(new SQLRowValues(this.defaultEcritureRowVals));
                }
            } else {
                this.defaultEcritureRowVals.put("DEBIT", 0L);
                this.defaultEcritureRowVals.put("CREDIT", 0L);
            }
        }
    }
}

