/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.utils.CollectionMap;

public abstract class ContactSQLElementBase
extends ConfSQLElement {
    protected ContactSQLElementBase(String tableName) {
        super(tableName);
    }

    @Override
    protected String createCode() {
        return this.getTable().getName();
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("PRENOM");
        l.add("FONCTION");
        if (this.getTable().contains("ID_CLIENT")) {
            l.add("ID_CLIENT");
        }
        if (this.getTable().contains("ID_FOURNISSEUR")) {
            l.add("ID_FOURNISSEUR");
        }
        l.add("TEL_STANDARD");
        l.add("TEL_DIRECT");
        l.add("EMAIL");
        l.add("TEL_MOBILE");
        if (this.getTable().contains("ORIGINE")) {
            l.add("ORIGINE");
        }
        if (this.getTable().contains("TYPE_DEMANDE")) {
            l.add("TYPE_DEMANDE");
        }
        if (this.getTable().contains("N4DS")) {
            l.add("N4DS");
        }
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("PRENOM");
        l.add("FONCTION");
        if (this.getTable().contains("ID_SITE")) {
            l.add("ID_SITE");
        }
        if (this.getTable().contains("ID_CLIENT")) {
            l.add("ID_CLIENT");
        }
        if (this.getTable().contains("ID_FOURNISSEUR")) {
            l.add("ID_FOURNISSEUR");
        }
        return l;
    }

    @Override
    public CollectionMap<String, String> getShowAs() {
        return CollectionMap.singleton(null, new String[]{"NOM", "TEL_STANDARD"});
    }

    @Override
    public SQLComponent createComponent() {
        return new ContactSQLComponent(this);
    }

    public static class ContactSQLComponent
    extends UISQLComponent {
        public ContactSQLComponent(SQLElement elt) {
            super(elt);
        }

        @Override
        protected Set<String> createRequiredNames() {
            HashSet<String> s = new HashSet<String>();
            s.add("NOM");
            return s;
        }

        @Override
        public void addViews() {
            if (this.getTable().contains("ID_CLIENT")) {
                this.addView("ID_CLIENT");
            }
            if (this.getTable().contains("ID_FOURNISSEUR")) {
                this.addView("ID_FOURNISSEUR");
            }
            if (this.getTable().contains("ID_TITRE_PERSONNEL")) {
                this.addView("ID_TITRE_PERSONNEL", "1");
                this.addView("NOM", "1");
                this.addView("PRENOM", "1");
            } else {
                this.addView("NOM", "left");
                this.addView("PRENOM", "right");
            }
            this.addView("FONCTION", "1");
            if (this.getTable().contains("ID_SITE")) {
                this.addView("ID_SITE");
            }
            if (this.getTable().contains("ACTIF")) {
                this.addView("ACTIF");
            }
            if (this.getTable().contains("SUFFIXE")) {
                this.addView("SUFFIXE");
            }
            this.addView("TEL_STANDARD", "left");
            this.addView("TEL_DIRECT", "right");
            this.addView("TEL_MOBILE", "left");
            this.addView("TEL_PERSONEL", "right");
            this.addView("FAX", "left");
            this.addView("EMAIL", "right");
            if (this.getTable().contains("SERVICE")) {
                this.addView("SERVICE");
            }
            if (this.getTable().contains("NOM_ASSISTANTE")) {
                this.addView("NOM_ASSISTANTE");
            }
            if (this.getTable().contains("EMAIL_ASSISTANTE")) {
                this.addView("EMAIL_ASSISTANTE");
            }
            if (this.getTable().contains("TEL_ASSISTANTE")) {
                this.addView("TEL_ASSISTANTE");
            }
            if (this.getTable().contains("NOM_RESPONSABLE")) {
                this.addView("NOM_RESPONSABLE");
            }
            if (this.getTable().contains("N4DS")) {
                this.addView("N4DS");
            }
        }
    }
}

