/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.ui.DeviseNumericCellEditor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.utils.StringUtils;

public class DeviseNumericHTConvertorCellEditor
extends DeviseNumericCellEditor
implements MouseListener {
    private float taxe = 19.6f;

    public DeviseNumericHTConvertorCellEditor(SQLField field) {
        super(field);
        this.textField.addMouseListener(this);
    }

    public void setTaxe(float d) {
        this.taxe = d;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.textField.getText().trim().length() > 0 && e.getButton() == 3) {
            JPopupMenu menuDroit = new JPopupMenu();
            menuDroit.add(new AbstractAction("Convertir en HT (TVA " + this.taxe + ")"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BigDecimal prixTTC = StringUtils.getBigDecimalFromUserText(DeviseNumericHTConvertorCellEditor.this.textField.getText());
                    if (prixTTC != null) {
                        try {
                            BigDecimal taux = new BigDecimal(DeviseNumericHTConvertorCellEditor.this.taxe).movePointLeft(2).add(BigDecimal.ONE);
                            BigDecimal divide = prixTTC.divide(taux, MathContext.DECIMAL128);
                            divide = divide.setScale(DeviseNumericHTConvertorCellEditor.this.precision, RoundingMode.HALF_UP);
                            DeviseNumericHTConvertorCellEditor.this.textField.setText(divide.toString());
                        }
                        catch (Exception ex) {
                            Log.get().info("Cannot substract tax from " + prixTTC + " for tax " + DeviseNumericHTConvertorCellEditor.this.taxe);
                            ex.printStackTrace();
                        }
                    }
                }
            });
            menuDroit.pack();
            menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            menuDroit.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

