/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.QteUnitRowValuesRenderer;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.ValidStateChecker;

public abstract class AbstractAchatArticleItemTable
extends AbstractArticleItemTable {
    private AutoCompletionManager m;
    private AutoCompletionManager m2;
    private AutoCompletionManager m3;
    private AutoCompletionManager m4;
    private final SQLTable tableArticle = this.getSQLElement().getTable().getTable("ARTICLE");
    private SQLRowAccessor rowDevise;
    private boolean supplierCode;
    private static Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();

    @Override
    protected void init() {
        SQLElement e = this.getSQLElement();
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getSQLElement().getTable().getDBRoot());
        boolean selectArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.USE_CREATED_ARTICLE, false);
        boolean createAuto = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        this.supplierCode = prefs.getBoolean(GestionArticleGlobalPreferencePanel.SUPPLIER_PRODUCT_CODE, false);
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement tableElementCodeFournisseur = null;
        if (e.getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            tableElementCodeFournisseur = new SQLTableElement(e.getTable().getField("ID_CODE_FOURNISSEUR"), true, true, true);
            list.add(tableElementCodeFournisseur);
        }
        SQLTableElement tableElementArticle = new SQLTableElement(e.getTable().getField("ID_ARTICLE"), true, true, true);
        list.add(tableElementArticle);
        if (e.getTable().getFieldsName().contains("ID_FAMILLE_ARTICLE")) {
            SQLTableElement tableFamille = new SQLTableElement(e.getTable().getField("ID_FAMILLE_ARTICLE"));
            list.add(tableFamille);
        }
        if (e.getTable().getFieldsName().contains("PREBILAN")) {
            SQLTableElement tableElementPre = new SQLTableElement(e.getTable().getField("PREBILAN"), Long.class, new DeviseCellEditor());
            tableElementPre.setRenderer(new DeviseNiceTableCellRenderer());
            list.add(tableElementPre);
        }
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        if (e.getTable().getFieldsName().contains("DESCRIPTIF")) {
            SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
            list.add(tableElementDesc);
        }
        if (e.getTable().getFieldsName().contains("COLORIS")) {
            SQLTableElement tableElementColoris = new SQLTableElement(e.getTable().getField("COLORIS"));
            list.add(tableElementColoris);
        }
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class);
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class);
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class);
        list.add(tableElement_ValeurMetrique1);
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), BigDecimal.class);
        tableElement_PrixMetrique1_AchatHT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixMetrique1_AchatHT);
        SQLTableElement tableElement_Devise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
        SQLTableElement tableElement_PA_Devise = new SQLTableElement(e.getTable().getField("PA_DEVISE"), BigDecimal.class);
        tableElement_PA_Devise.setRenderer(new DeviseTableCellRenderer());
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            list.add(tableElement_Devise);
            list.add(tableElement_PA_Devise);
        }
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        this.ha = new SQLTableElement(e.getTable().getField("PA_HT"), BigDecimal.class);
        this.ha.setRenderer(new DeviseTableCellRenderer());
        list.add(this.ha);
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE_UNITAIRE"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                SQLRowAccessor row = vals.getForeign("ID_UNITE_VENTE");
                if (row != null && !row.isUndefined() && row.getBoolean("A_LA_PIECE").booleanValue()) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        list.add(qteU);
        SQLTableElement uniteVente = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(uniteVente);
        SQLTableElement qteElement = new SQLTableElement(e.getTable().getField("QTE"), Integer.class){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }
        };
        list.add(qteElement);
        this.tableElementTVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        list.add(this.tableElementTVA);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class);
        list.add(this.tableElementPoidsTotal);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (b != null && b.booleanValue()) {
            this.service = new SQLTableElement(e.getTable().getField("SERVICE"), Boolean.class);
            list.add(this.service);
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PA_DEVISE_T"), BigDecimal.class);
            this.tableElementTotalDevise.setRenderer(new DeviseTableCellRenderer());
            list.add(this.tableElementTotalDevise);
        }
        SQLTableElement tableElementRemise = null;
        if (e.getTable().contains("POURCENT_REMISE")) {
            tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"));
            list.add(tableElementRemise);
        }
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PA_HT"), BigDecimal.class);
        this.totalHT.setRenderer(new DeviseTableCellRenderer());
        this.totalHT.setEditable(false);
        if (e.getTable().contains("POURCENT_REMISE") && tableElementRemise != null) {
            tableElementRemise.addModificationListener(this.totalHT);
        }
        list.add(this.totalHT);
        this.totalHA = this.totalHT;
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PA_TTC"), BigDecimal.class);
        this.tableElementTotalTTC.setRenderer(new DeviseTableCellRenderer());
        list.add(this.tableElementTotalTTC);
        SQLRowValues defautRow = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        defautRow.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"), false, defautRow);
        this.table = new RowValuesTable(this.model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        ArrayList<String> completionFields = new ArrayList<String>();
        completionFields.add("ID_UNITE_VENTE");
        completionFields.add("PA_HT");
        completionFields.add("PV_HT");
        completionFields.add("POIDS");
        completionFields.add("ID_TAXE");
        completionFields.add("PRIX_METRIQUE_HA_1");
        completionFields.add("PRIX_METRIQUE_HA_2");
        completionFields.add("PRIX_METRIQUE_HA_3");
        completionFields.add("VALEUR_METRIQUE_1");
        completionFields.add("VALEUR_METRIQUE_2");
        completionFields.add("VALEUR_METRIQUE_3");
        completionFields.add("ID_MODE_VENTE_ARTICLE");
        completionFields.add("PRIX_METRIQUE_VT_1");
        completionFields.add("PRIX_METRIQUE_VT_2");
        completionFields.add("PRIX_METRIQUE_VT_3");
        completionFields.add("SERVICE");
        completionFields.add("ID_DEVISE");
        completionFields.add("PA_DEVISE");
        if (e.getTable().getFieldsName().contains("COLORIS")) {
            completionFields.add("COLORIS");
        }
        if (e.getTable().getFieldsName().contains("DESCRIPTIF")) {
            completionFields.add("DESCRIPTIF");
        }
        if (e.getTable().getFieldsName().contains("ID_FAMILLE_ARTICLE")) {
            completionFields.add("ID_FAMILLE_ARTICLE");
        }
        this.m = new AutoCompletionManager(tableElementCode, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.CODE"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        this.m.fill("NOM", "NOM");
        this.m.fill("ID", "ID_ARTICLE");
        for (String string : completionFields) {
            this.m.fill(string, string);
        }
        this.m2 = new AutoCompletionManager(tableElementNom, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        this.m2.fill("CODE", "CODE");
        this.m2.fill("ID", "ID_ARTICLE");
        for (String string : completionFields) {
            this.m2.fill(string, string);
        }
        this.m3 = new AutoCompletionManager(tableElementArticle, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        this.m3.fill("CODE", "CODE");
        this.m3.fill("NOM", "NOM");
        for (String string : completionFields) {
            this.m3.fill(string, string);
        }
        if (e.getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            this.m4 = new AutoCompletionManager(tableElementCodeFournisseur, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

                @Override
                protected Object getValueFrom(SQLRow row, String field) {
                    Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                    if (res == null) {
                        return super.getValueFrom(row, field);
                    }
                    return res;
                }
            };
            this.m4.fill("CODE", "CODE");
            this.m4.fill("NOM", "NOM");
            for (String string : completionFields) {
                this.m4.fill(string, string);
            }
        }
        tableElementCode.addModificationListener(tableElementArticle);
        tableElementArticle.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                SQLRowAccessor foreign = row.getForeign("ID_ARTICLE");
                if (foreign != null && !foreign.isUndefined() && foreign.getObject("CODE") != null && foreign.getString("CODE").equals(row.getString("CODE"))) {
                    return foreign.getID();
                }
                return AbstractAchatArticleItemTable.this.tableArticle.getUndefinedID();
            }
        });
        qteElement.addModificationListener(this.totalHT);
        qteU.addModificationListener(this.totalHT);
        this.ha.addModificationListener(this.totalHT);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal f = row.getObject("PA_HT") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PA_HT");
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), MathContext.DECIMAL128).setScale(AbstractAchatArticleItemTable.this.totalHT.getDecimalDigits(), 4);
                if (row.getTable().contains("POURCENT_REMISE")) {
                    BigDecimal lremise;
                    Object o2 = row.getObject("POURCENT_REMISE");
                    BigDecimal bigDecimal = lremise = o2 == null ? BigDecimal.ZERO : (BigDecimal)o2;
                    if (lremise.compareTo(BigDecimal.ZERO) >= 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 0) {
                        r = r.multiply(new BigDecimal(100).subtract(lremise).movePointLeft(2)).setScale(AbstractAchatArticleItemTable.this.totalHT.getDecimalDigits(), 4);
                    }
                }
                return r;
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            qteElement.addModificationListener(this.tableElementTotalDevise);
            qteU.addModificationListener(this.tableElementTotalDevise);
            tableElement_PA_Devise.addModificationListener(this.tableElementTotalDevise);
            if (e.getTable().contains("POURCENT_REMISE") && tableElementRemise != null) {
                tableElementRemise.addModificationListener(this.tableElementTotalDevise);
            }
            this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row) {
                    int qte = Integer.parseInt(row.getObject("QTE").toString());
                    BigDecimal f = (BigDecimal)row.getObject("PA_DEVISE");
                    BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                    BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), MathContext.DECIMAL128).setScale(AbstractAchatArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                    if (row.getTable().contains("POURCENT_REMISE")) {
                        BigDecimal lremise;
                        Object o2 = row.getObject("POURCENT_REMISE");
                        BigDecimal bigDecimal = lremise = o2 == null ? BigDecimal.ZERO : (BigDecimal)o2;
                        if (lremise.compareTo(BigDecimal.ZERO) >= 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 0) {
                            r = r.multiply(new BigDecimal(100).subtract(lremise).movePointLeft(2)).setScale(AbstractAchatArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                        }
                    }
                    return r;
                }
            });
        }
        qteElement.addModificationListener(this.tableElementTotalTTC);
        qteU.addModificationListener(this.tableElementTotalTTC);
        this.ha.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTVA.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal f = (BigDecimal)row.getObject("PA_HT");
                int idTaux = Integer.parseInt(row.getObject("ID_TAXE").toString());
                if (idTaux < 0) {
                    System.out.println(row);
                }
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte), MathContext.DECIMAL128), MathContext.DECIMAL128).setScale(AbstractAchatArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), 4);
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                BigDecimal total = r.multiply(BigDecimal.ONE.add(new BigDecimal(taux / 100.0f))).setScale(AbstractAchatArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), RoundingMode.HALF_UP);
                return total;
            }
        });
        this.table.readState();
        String valModeAvanceVt = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bModeAvance = Boolean.valueOf(valModeAvanceVt);
        boolean view = bModeAvance == null || bModeAvance != false;
        this.setColumnVisible(this.model.getColumnForField("VALEUR_METRIQUE_1"), view);
        this.setColumnVisible(this.model.getColumnForField("VALEUR_METRIQUE_2"), view);
        this.setColumnVisible(this.model.getColumnForField("VALEUR_METRIQUE_3"), view);
        this.setColumnVisible(this.model.getColumnForField("PRIX_METRIQUE_VT_1"), view);
        this.setColumnVisible(this.model.getColumnForField("ID_MODE_VENTE_ARTICLE"), view);
        this.setColumnVisible(this.model.getColumnForField("PA_HT"), view);
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        this.setColumnVisible(this.model.getColumnForField("QTE_UNITAIRE"), gestionUV);
        this.setColumnVisible(this.model.getColumnForField("ID_UNITE_VENTE"), gestionUV);
        this.setColumnVisible(this.model.getColumnForField("ID_STYLE"), DefaultNXProps.getInstance().getBooleanValue("ArticleShowStyle", true));
        this.setColumnVisible(this.model.getColumnForField("ID_ARTICLE"), selectArticle);
        this.setColumnVisible(this.model.getColumnForField("CODE"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(this.model.getColumnForField("NOM"), !selectArticle || selectArticle && createAuto);
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        qteElement.addModificationListener(this.tableElementPoidsTotal);
        qteU.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                Integer f = row.getObject("POIDS") == null ? (Number)0 : (Number)((Number)row.getObject("POIDS"));
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(((Number)f).floatValue() * (float)qte)).floatValue());
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                BigDecimal prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails.setScale(AbstractAchatArticleItemTable.this.ha.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        uniteVente.addModificationListener(qteU);
        qteU.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                SQLRowAccessor rowUnite = row.getForeign("ID_UNITE_VENTE");
                if (rowUnite != null && !rowUnite.isUndefined() && rowUnite.getBoolean("A_LA_PIECE").booleanValue()) {
                    return BigDecimal.ONE;
                }
                return row.getObject("QTE_UNITAIRE");
            }
        });
        for (String string : visibilityMap.keySet()) {
            this.setColumnVisible(this.model.getColumnForField(string), visibilityMap.get(string));
        }
        this.table.writeState();
    }

    public void setFournisseur(SQLRow rowFournisseur) {
        if (this.getSQLElement().getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            if (rowFournisseur != null && !rowFournisseur.isUndefined()) {
                Where w = new Where((FieldRef)this.getSQLElement().getTable().getTable("CODE_FOURNISSEUR").getField("ID_FOURNISSEUR"), "=", rowFournisseur.getID());
                this.m4.setWhere(w);
            } else {
                this.m4.setWhere(null);
            }
        }
    }

    private Object tarifCompletion(SQLRow row, String field) {
        if (this.getDevise() != null && !this.getDevise().isUndefined()) {
            if (field.equalsIgnoreCase("ID_DEVISE") || field.equalsIgnoreCase("ID_DEVISE_HA")) {
                return this.getDevise().getID();
            }
            if (field.equalsIgnoreCase("PA_DEVISE")) {
                return row.getObject("PA_DEVISE");
            }
        } else {
            if (field.equalsIgnoreCase("ID_DEVISE") || field.equalsIgnoreCase("ID_DEVISE_HA")) {
                return Configuration.getInstance().getDirectory().getElement("DEVISE").getTable().getUndefinedID();
            }
            if (field.equalsIgnoreCase("PA_DEVISE")) {
                return BigDecimal.ZERO;
            }
        }
        return null;
    }

    public SQLRowAccessor getDevise() {
        return this.rowDevise;
    }

    public void setDevise(SQLRowAccessor deviseRow) {
        this.rowDevise = deviseRow;
    }
}

