/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.component;

import java.util.List;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.ExceptionHandler;

public abstract class TransfertGroupSQLComponent
extends GroupSQLComponent {
    private List<SQLRowValues> sourceRows;

    public TransfertGroupSQLComponent(SQLElement element, Group group) {
        super(element, group);
    }

    @Override
    public int insert(SQLRow order) {
        int insertedId = super.insert(order);
        if (insertedId != -1 && this.sourceRows != null && !this.sourceRows.isEmpty()) {
            SQLInjector injector = SQLInjector.getInjector(this.sourceRows.get(0).getTable(), this.getTable());
            try {
                injector.commitTransfert(this.sourceRows, insertedId);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Unable to insert transfert", e);
            }
        }
        return insertedId;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r == null) {
            super.select(null);
            return;
        }
        SQLRowValues singleRowValues = new SQLRowValues(r.asRowValues(), SQLRowValues.ForeignCopyMode.COPY_ID_OR_RM);
        super.select(singleRowValues);
        RowValuesTable table = this.getRowValuesTable();
        if (table != null) {
            table.clear();
            table.insertFrom(r);
        }
    }

    protected RowValuesTable getRowValuesTable() {
        return null;
    }
}

