/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public abstract class TransfertBaseSQLComponent
extends BaseSQLComponent {
    private List<SQLRowValues> sourceRows;

    public TransfertBaseSQLComponent(SQLElement element) {
        super(element);
    }

    public void importFrom(List<SQLRowValues> rows) {
        this.sourceRows = rows;
        if (rows.size() > 0) {
            SQLInjector injector = SQLInjector.getInjector(rows.get(0).getTable(), this.getTable());
            SQLRowValues rValues = injector.createRowValuesFrom(rows);
            this.select(rValues);
        } else {
            this.select(null);
        }
    }

    @Override
    public int insert(SQLRow order) {
        int insertedId = super.insert(order);
        if (insertedId != -1 && this.sourceRows != null && !this.sourceRows.isEmpty()) {
            SQLInjector injector = SQLInjector.getInjector(this.sourceRows.get(0).getTable(), this.getTable());
            try {
                injector.commitTransfert(this.sourceRows, insertedId);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Unable to insert transfert", e);
            }
        }
        return insertedId;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r == null) {
            super.select(null);
            return;
        }
        SQLRowValues singleRowValues = new SQLRowValues(r.asRowValues(), SQLRowValues.ForeignCopyMode.COPY_ID_OR_RM);
        super.select(singleRowValues);
        RowValuesTable table = this.getRowValuesTable();
        if (table != null) {
            table.clear();
            table.insertFrom(r);
        }
    }

    protected RowValuesTable getRowValuesTable() {
        return null;
    }

    public static void openTransfertFrame(List<SQLRowValues> sourceRows, String destTableName) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement(destTableName);
        EditFrame editFrame = new EditFrame(elt);
        editFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SQLComponent sqlComponent = editFrame.getSQLComponent();
        if (sqlComponent instanceof TransfertBaseSQLComponent) {
            TransfertBaseSQLComponent comp = (TransfertBaseSQLComponent)sqlComponent;
            if (!sourceRows.isEmpty()) {
                final ArrayList<Number> ids = new ArrayList<Number>(sourceRows.size());
                for (SQLRowValues sqlRowValues : sourceRows) {
                    ids.add(sqlRowValues.getIDNumber());
                }
                final SQLRowValues row = sourceRows.get(0).deepCopy();
                for (SQLField rk : row.getTable().getDBSystemRoot().getGraph().getReferentKeys(row.getTable())) {
                    Set<SQLRowValues> referentRows = row.getReferentRows(rk);
                    if (referentRows.size() <= 1) continue;
                    Iterator<SQLRowValues> iter = new ArrayList<SQLRowValues>(referentRows).iterator();
                    iter.next();
                    while (iter.hasNext()) {
                        SQLRowValues ref = iter.next();
                        ref.remove(rk.getName());
                    }
                }
                for (SQLRowValues r : row.getGraph().getItems()) {
                    HashSet<String> fields = new HashSet<String>(r.getTable().getFieldsName());
                    fields.removeAll(r.getFields());
                    r.putNulls(fields, false);
                }
                SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(row);
                fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    public SQLSelect transformChecked(SQLSelect input) {
                        input.setWhere(new Where(row.getTable().getKey(), ids));
                        return input;
                    }
                });
                List<SQLRowValues> result = fetcher.fetch();
                comp.importFrom(result);
                FrameUtil.show(editFrame);
            }
        } else {
            throw new IllegalArgumentException("Table " + destTableName + " SQLComponent is not a TransfertBaseSQLComponent");
        }
    }
}

