/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.change;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openconcerto.utils.change.ListChangeIndex;
import org.openconcerto.utils.change.ListChangeRecipe;

public class ListChangeRecorder<E>
extends AbstractList<E> {
    private final List<E> delegate;
    private final ListChangeRecipe<E> recipe;

    public ListChangeRecorder(List<E> delegate) {
        this(delegate, false);
    }

    public ListChangeRecorder(List<E> delegate, boolean keepHistory) {
        this.delegate = delegate;
        this.recipe = new ListChangeRecipe(keepHistory);
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public boolean add(E e) {
        boolean res = this.delegate.add(e);
        this.recipe.add(this.size() - 1, Collections.singleton(e));
        return res;
    }

    @Override
    public void add(int index, E e) {
        this.delegate.add(index, e);
        this.recipe.add(index, Collections.singleton(e));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean res = this.delegate.addAll(c);
        this.recipe.add(this.size() - 1, c);
        return res;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean res = this.delegate.addAll(index, c);
        this.recipe.add(index, c);
        return res;
    }

    @Override
    public void clear() {
        List copy = (List)ListChangeIndex.copy(this);
        this.delegate.clear();
        this.recipe.remove(0, copy.size() - 1, copy);
    }

    @Override
    public E set(int index, E element) {
        E res = this.delegate.set(index, element);
        this.recipe.set(index, res, element);
        return res;
    }

    @Override
    public E remove(int index) {
        E res = this.delegate.remove(index);
        this.recipe.remove(index, index, Collections.singletonList(res));
        return res;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.changeAll(c, true);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.changeAll(c, false);
    }

    private boolean changeAll(Collection<?> c, boolean remove) {
        boolean modified = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next()) != remove) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }
}

