/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.config;

import java.io.File;
import java.util.Properties;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.users.UserCommonSQLElement;
import org.openconcerto.sql.users.rights.RightSQLElement;
import org.openconcerto.sql.users.rights.UserRightSQLElement;
import org.openconcerto.task.element.TaskRightSQLElement;
import org.openconcerto.task.element.TaskSQLElement;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.ProductInfo;

public abstract class ComptaBasePropsConfiguration
extends PropsConfiguration {
    private int idSociete = -1;
    private SQLRow rowSociete = null;

    public static File getConfFile(String appName) {
        return ComptaBasePropsConfiguration.getConfFile(appName, new File("."));
    }

    public static File getConfFile(String appName, File wd) {
        String confFilePath = System.getProperty("gestion.confFile");
        File wdFile = new File(wd + "/Configuration", "main.properties");
        File confFile = confFilePath != null ? new File(confFilePath) : (wdFile.isFile() ? wdFile : new File(DesktopEnvironment.getDE().getPreferencesFolder(appName), "main.properties"));
        return confFile;
    }

    public ComptaBasePropsConfiguration(Properties props, ProductInfo productInfo) {
        super(props);
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        this.setLoggersLevel();
        this.setProductInfo(productInfo);
        String name = "ilm";
        this.setProperty("systemRoot.rootsToMap", String.valueOf(name) + "_Common");
        this.setProperty("systemRoot.rootPath", String.valueOf(name) + "_Common");
    }

    @Override
    protected PropsConfiguration.FileMode getFileMode() {
        return PropsConfiguration.FileMode.NORMAL_FILE;
    }

    @Override
    protected SQLElementDirectory createDirectory() {
        SQLElementDirectory dir = super.createDirectory();
        dir.addSQLElement(new ConfSQLElement("SOCIETE_COMMON", "une soci\u00e9t\u00e9", "soci\u00e9t\u00e9s"));
        dir.addSQLElement(new ConfSQLElement("EXERCICE_COMMON", "un exercice", "exercices"));
        dir.addSQLElement(new ConfSQLElement("ADRESSE_COMMON", "une adresse", "adresses"));
        dir.addSQLElement(new TaskRightSQLElement());
        dir.addSQLElement(new TaskSQLElement());
        dir.addSQLElement(new UserCommonSQLElement());
        dir.addSQLElement(UserRightSQLElement.class);
        dir.addSQLElement(RightSQLElement.class);
        return dir;
    }
}

