/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.xml.JDOMUtils;

public abstract class SQLType {
    private static final Map<List<String>, SQLType> instances = new HashMap<List<String>, SQLType>();
    private final int type;
    private final int size;
    private final Integer decimalDigits;
    private final String typeName;
    private final Class javaType;
    private SQLBase base;
    private SQLSyntax syntax;
    private String xml;

    private static Class getClass(int type, int size) {
        switch (type) {
            case -7: {
                if (size == 1) {
                    return Boolean.class;
                }
                if (size <= 32) {
                    return Integer.class;
                }
                if (size <= 64) {
                    return Long.class;
                }
                return BigInteger.class;
            }
            case 16: {
                return Boolean.class;
            }
            case 8: {
                return Double.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 91: {
                return java.util.Date.class;
            }
            case 92: {
                return Time.class;
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return Blob.class;
            }
            case 2005: {
                return Clob.class;
            }
            case -5: {
                return Long.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
        }
        return Object.class;
    }

    public static SQLType get(SQLBase base, int type, int size, Integer decDigits, String typeName) {
        List<String> typeID = Arrays.asList(base == null ? null : base.getURL(), String.valueOf(type), String.valueOf(size), String.valueOf(decDigits), typeName);
        SQLType res = instances.get(typeID);
        if (res == null) {
            Class clazz = SQLType.getClass(type, size);
            res = Boolean.class.isAssignableFrom(clazz) ? new BooleanType(type, size, typeName, clazz) : (Number.class.isAssignableFrom(clazz) ? new NumberType(type, size, decDigits, typeName, clazz) : (Time.class.isAssignableFrom(clazz) ? new TimeType(type, size, decDigits, typeName, clazz) : (Timestamp.class.isAssignableFrom(clazz) ? new TimestampType(type, size, decDigits, typeName, clazz) : (java.util.Date.class.isAssignableFrom(clazz) ? new DateType(type, size, decDigits, typeName, clazz) : (String.class.isAssignableFrom(clazz) ? new StringType(type, size, typeName, clazz) : new UnknownType(type, size, typeName, clazz))))));
            res.setBase(base);
            instances.put(typeID, res);
        }
        return res;
    }

    public static SQLType get(SQLBase base, Element typeElement) {
        int type = Integer.valueOf(typeElement.getAttributeValue("type"));
        int size = Integer.valueOf(typeElement.getAttributeValue("size"));
        String typeName = typeElement.getAttributeValue("typeName");
        String decDigitsS = typeElement.getAttributeValue("decimalDigits");
        Integer decDigits = decDigitsS == null ? null : Integer.valueOf(decDigitsS);
        return SQLType.get(base, type, size, decDigits, typeName);
    }

    private SQLType(int type, int size, Integer decDigits, String typeName, Class javaType) {
        this.type = type;
        this.size = size;
        this.decimalDigits = decDigits;
        this.typeName = typeName;
        this.javaType = javaType;
        this.xml = null;
    }

    public int getType() {
        return this.type;
    }

    private final boolean isNumeric() {
        return this.getType() == 3 || this.getType() == 2;
    }

    public final int getSize() {
        return this.size;
    }

    public final Integer getDecimalDigits() {
        return this.decimalDigits;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    private final void setBase(SQLBase base) {
        assert (this.base == null);
        if (base != null) {
            this.base = base;
            this.syntax = this.base.getServer().getSQLSystem().getSyntax();
        }
    }

    public final SQLBase getBase() {
        return this.base;
    }

    public final SQLSyntax getSyntax() {
        return this.syntax;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, null);
    }

    public boolean equals(Object obj, SQLSystem otherSystem) {
        if (obj instanceof SQLType) {
            boolean sizeOK;
            boolean typeOK;
            SQLType o = (SQLType)obj;
            boolean javaTypeOK = this.getJavaType().equals(o.getJavaType());
            if (!javaTypeOK) {
                return false;
            }
            if (this.getJavaType() == Boolean.class) {
                return true;
            }
            boolean bl = this.isNumeric() ? o.isNumeric() : (typeOK = this.getType() == o.getType());
            if (!typeOK) {
                return false;
            }
            if (this.getType() == 91 || this.getJavaType() == Float.class || this.getJavaType() == Double.class) {
                sizeOK = true;
            } else {
                boolean isTime;
                if (otherSystem == null && o.getSyntax() != null) {
                    otherSystem = o.getSyntax().getSystem();
                }
                SQLSystem thisSystem = this.getSyntax() == null ? null : this.getSyntax().getSystem();
                boolean bl2 = isTime = this.getType() == 92 || this.getType() == 93;
                boolean decDigitsOK = !this.isNumeric() && !isTime ? true : (this.isNumeric() || thisSystem == null || otherSystem == null || thisSystem.isFractionalSecondsSupported() && otherSystem.isFractionalSecondsSupported() ? CompareUtils.equals(this.getDecimalDigits(), o.getDecimalDigits()) : true);
                sizeOK = decDigitsOK && (isTime || this.getSize() == o.getSize());
            }
            return sizeOK;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getType() + this.getSize() + this.getJavaType().hashCode();
    }

    public final String toString() {
        return "SQLType #" + this.getType() + "(" + this.getSize() + "," + this.getDecimalDigits() + "): " + this.getJavaType();
    }

    public final String toXML() {
        if (this.xml == null) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("<type type=\"");
            sb.append(this.type);
            sb.append("\" size=\"");
            sb.append(this.size);
            if (this.decimalDigits != null) {
                sb.append("\" decimalDigits=\"");
                sb.append(this.decimalDigits);
            }
            sb.append("\" typeName=\"");
            sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.typeName));
            sb.append("\"/>");
            this.xml = sb.toString();
        }
        return this.xml;
    }

    public final String toString(Object o) {
        this.check(o);
        if (o == null) {
            return "NULL";
        }
        return this.toStringRaw(o);
    }

    public final void check(Object o) {
        if (!this.isValid(o)) {
            throw new IllegalArgumentException(o + " is not valid for " + this);
        }
    }

    public boolean isValid(Object o) {
        return o == null || this.getJavaType().isInstance(o);
    }

    protected abstract String toStringRaw(Object var1);

    /* synthetic */ SQLType(int n, int n2, Integer n3, String string, Class clazz, SQLType sQLType) {
        this(n, n2, n3, string, clazz);
    }

    private static class BooleanType
    extends ToStringType {
        public BooleanType(int type, int size, String typeName, Class clazz) {
            super(type, size, typeName, clazz);
        }

        @Override
        protected String toStringRaw(Object o) {
            if (this.getSyntax().getSystem() == SQLSystem.MSSQL) {
                return this.getBase().quoteString(o.toString());
            }
            return super.toStringRaw(o);
        }
    }

    private static abstract class DateOrTimeType
    extends SQLType {
        public DateOrTimeType(int type, int size, Integer decDigits, String typeName, Class clazz) {
            super(type, size, decDigits, typeName, clazz, null);
        }

        @Override
        public final boolean isValid(Object o) {
            return super.isValid(o) || o instanceof java.util.Date || o instanceof Calendar || o instanceof Number;
        }

        protected long getTime(Object o) {
            if (o instanceof java.util.Date) {
                return ((java.util.Date)o).getTime();
            }
            if (o instanceof Calendar) {
                return ((Calendar)o).getTimeInMillis();
            }
            return ((Number)o).longValue();
        }
    }

    private static class DateType
    extends DateOrTimeType {
        public DateType(int type, int size, Integer decDigits, String typeName, Class clazz) {
            super(type, size, decDigits, typeName, clazz);
        }

        @Override
        protected String toStringRaw(Object o) {
            return "'" + new Date(this.getTime(o)).toString() + "'";
        }
    }

    private static class NumberType
    extends ToStringType {
        public NumberType(int type, int size, Integer decDigits, String typeName, Class clazz) {
            super(type, size, decDigits, typeName, clazz);
        }

        @Override
        public boolean isValid(Object o) {
            return super.isValid(o) || o instanceof Number;
        }
    }

    private static class StringType
    extends SQLType {
        public StringType(int type, int size, String typeName, Class clazz) {
            super(type, size, null, typeName, clazz, null);
        }

        @Override
        protected String toStringRaw(Object o) {
            return SQLBase.quoteString(this.getBase(), (String)o);
        }
    }

    private static class TimeType
    extends DateOrTimeType {
        public TimeType(int type, int size, Integer decDigits, String typeName, Class clazz) {
            super(type, size, decDigits, typeName, clazz);
        }

        @Override
        protected String toStringRaw(Object o) {
            Time ts = o instanceof Time ? (Time)o : new Time(this.getTime(o));
            return "'" + ts.toString() + "'";
        }
    }

    private static class TimestampType
    extends DateOrTimeType {
        public TimestampType(int type, int size, Integer decDigits, String typeName, Class clazz) {
            super(type, size, decDigits, typeName, clazz);
        }

        @Override
        protected String toStringRaw(Object o) {
            Timestamp ts = o instanceof Timestamp ? (Timestamp)o : new Timestamp(this.getTime(o));
            return "'" + ts.toString() + "'";
        }
    }

    private static abstract class ToStringType
    extends SQLType {
        public ToStringType(int type, int size, String typeName, Class clazz) {
            this(type, size, null, typeName, clazz);
        }

        public ToStringType(int type, int size, Integer decDigits, String typeName, Class clazz) {
            super(type, size, decDigits, typeName, clazz, null);
        }

        @Override
        protected String toStringRaw(Object o) {
            return o.toString();
        }
    }

    private static final class UnknownType
    extends SQLType {
        public UnknownType(int type, int size, String typeName, Class clazz) {
            super(type, size, null, typeName, clazz, null);
        }

        @Override
        protected String toStringRaw(Object o) {
            throw new IllegalStateException("not implemented");
        }
    }
}

