/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.XMLStructureSource;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.cc.CopyOnWriteMap;
import org.openconcerto.utils.change.CollectionChangeEventCreator;
import org.openconcerto.xml.JDOMUtils;

public final class SQLSchema
extends SQLIdentifier {
    private final CopyOnWriteMap<String, SQLTable> tables = new CopyOnWriteMap();
    private final Map<String, String> procedures = new CopyOnWriteMap<String, String>();
    private boolean fetchAllUndefIDs = true;

    public static final void getVersionAttr(SQLSchema schema, Appendable sb) {
        String version = schema.getVersion();
        if (version != null) {
            try {
                sb.append(' ');
                sb.append("schemaVersion");
                sb.append("=\"");
                sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(version));
                sb.append('\"');
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't append version of " + schema, e);
            }
        }
    }

    public static final String getVersion(Element schemaElem) {
        return schemaElem.getAttributeValue("schemaVersion");
    }

    public static final String getVersion(SQLBase base, String schemaName) {
        return base.getFwkMetadata(schemaName, "VERSION");
    }

    SQLSchema(SQLBase base, String name) {
        super(base, name);
    }

    public final SQLBase getBase() {
        return (SQLBase)this.getParent();
    }

    final void putProcedures(Map<String, String> m) {
        this.procedures.putAll(m);
    }

    void clearNonPersistent() {
        this.procedures.clear();
    }

    void load(Element schemaElem) {
        List l = schemaElem.getChildren("table");
        int i = 0;
        while (i < l.size()) {
            Element elementTable = (Element)l.get(i);
            this.refreshTable(elementTable);
            ++i;
        }
        HashMap<String, String> procMap = new HashMap<String, String>();
        for (Object proc : schemaElem.getChild("procedures").getChildren("proc")) {
            Element procElem = (Element)proc;
            Element src = procElem.getChild("src");
            procMap.put(procElem.getAttributeValue("name"), src == null ? null : src.getText());
        }
        this.putProcedures(procMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLTable fetchTable(String tableName) throws SQLException {
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLSchema sQLSchema = this;
            synchronized (sQLSchema) {
                SQLTable existing = this.getTable(tableName);
                if (existing != null) {
                    existing.fetchFields();
                } else {
                    SQLSchema tmp = new SQLSchema(this.getBase(), this.getName());
                    tmp.addTable(tableName).fetchFields(true);
                    SQLTable newTable = tmp.getTable(tableName);
                    if (newTable != null) {
                        SQLTable res = this.addTable(tableName);
                        res.mutateTo(newTable);
                        this.getDBSystemRoot().descendantsChanged(true);
                        res.save();
                    }
                }
                return this.getTable(tableName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mutateTo(SQLSchema newSchema) {
        assert (Thread.holdsLock(this.getDBSystemRoot().getTreeMutex()));
        SQLSchema sQLSchema = this;
        synchronized (sQLSchema) {
            this.clearNonPersistent();
            this.putProcedures(newSchema.procedures);
            for (SQLTable t : this.getTables()) {
                t.mutateTo(newSchema.getTable(t.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SQLTable addTable(String tableName) {
        Object object = this.getTreeMutex();
        synchronized (object) {
            return this.addTableWithoutSysRootLock(tableName);
        }
    }

    final SQLTable addTableWithoutSysRootLock(String tableName) {
        if (this.contains(tableName)) {
            throw new IllegalStateException(String.valueOf(tableName) + " already in " + this);
        }
        CollectionChangeEventCreator c = this.createChildrenCreator();
        SQLTable res = new SQLTable(this, tableName);
        this.tables.put(tableName, res);
        this.fireChildrenChanged(c);
        return res;
    }

    private final void refreshTable(Element tableElem) {
        String tableName = tableElem.getAttributeValue("name");
        this.getTable(tableName).loadFields(tableElem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Boolean refreshTable(DatabaseMetaData metaData, ResultSet rs) throws SQLException {
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLSchema sQLSchema = this;
            synchronized (sQLSchema) {
                String tableName = rs.getString("TABLE_NAME");
                if (this.contains(tableName)) {
                    return this.getTable(tableName).fetchFields(metaData, rs);
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void rmTable(String tableName) {
        Object object = this.getTreeMutex();
        synchronized (object) {
            this.rmTableWithoutSysRootLock(tableName);
        }
    }

    final void rmTableWithoutSysRootLock(String tableName) {
        CollectionChangeEventCreator c = this.createChildrenCreator();
        SQLTable tableToDrop = this.tables.remove(tableName);
        this.fireChildrenChanged(c);
        if (tableToDrop != null) {
            tableToDrop.dropped();
        }
    }

    public final SQLTable getTable(String tablename) {
        return this.tables.get(tablename);
    }

    public Set<String> getTableNames() {
        return Collections.unmodifiableSet(this.tables.keySet());
    }

    public Set<SQLTable> getTables() {
        return new HashSet<SQLTable>(this.tables.values());
    }

    @Override
    public Map<String, SQLTable> getChildrenMap() {
        return this.tables.getImmutable();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder sb = new StringBuilder(256000);
        sb.append("<schema ");
        if (this.getName() != null) {
            sb.append(" name=\"");
            sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getName()));
            sb.append('\"');
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLSchema sQLSchema = this;
            synchronized (sQLSchema) {
                SQLSchema.getVersionAttr(this, sb);
                sb.append(" >\n");
                sb.append("<procedures>\n");
                for (Map.Entry<String, String> e : this.procedures.entrySet()) {
                    sb.append("<proc name=\"");
                    sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(e.getKey()));
                    sb.append("\" ");
                    if (e.getValue() == null) {
                        sb.append("/>");
                        continue;
                    }
                    sb.append("><src>");
                    sb.append(JDOMUtils.OUTPUTTER.escapeElementEntities(e.getValue()));
                    sb.append("</src></proc>\n");
                }
                sb.append("</procedures>\n");
                for (SQLTable table : this.getTables()) {
                    sb.append(table.toXML());
                    sb.append("\n");
                }
                sb.append("</schema>");
            }
        }
        return sb.toString();
    }

    String getFwkMetadata(String name) {
        if (!this.contains("FWK_SCHEMA_METADATA")) {
            return null;
        }
        return this.getBase().getFwkMetadata(this.getName(), name);
    }

    boolean setFwkMetadata(String name, String value) throws SQLException {
        return this.setFwkMetadata(name, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setFwkMetadata(String name, String value, boolean createTable) throws SQLException {
        if (Boolean.getBoolean("org.openconcerto.sql.noautoCreateMetadata")) {
            return false;
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            boolean res;
            boolean shouldRefresh;
            if (createTable && !this.contains("FWK_SCHEMA_METADATA")) {
                SQLCreateTable create = new SQLCreateTable(this.getDBRoot(), "FWK_SCHEMA_METADATA");
                create.setPlain(true);
                ((SQLCreateTable)create.addVarCharColumn("NAME", 100)).addVarCharColumn("VALUE", 250);
                create.setPrimaryKey("NAME");
                this.getBase().getDataSource().execute(create.asString());
                shouldRefresh = true;
            } else {
                shouldRefresh = false;
            }
            if (createTable || this.contains("FWK_SCHEMA_METADATA")) {
                SQLName tableName = new SQLName(this.getBase().getName(), this.getName(), "FWK_SCHEMA_METADATA");
                final String del = SQLSelect.quote("DELETE FROM %i WHERE %i = %s", tableName, "NAME", name);
                final String ins = SQLSelect.quote("INSERT INTO %i(%i,%i) VALUES(%s,%s)", tableName, "NAME", "VALUE", name, value);
                SQLUtils.executeAtomic(this.getBase().getDataSource(), new SQLUtils.SQLFactory<Object>(){

                    @Override
                    public Object create() throws SQLException {
                        SQLSchema.this.getBase().getDataSource().execute(del);
                        SQLSchema.this.getBase().getDataSource().execute(ins);
                        return null;
                    }
                });
                res = true;
            } else {
                res = false;
            }
            if (shouldRefresh) {
                this.getBase().fetchTables(Collections.singleton(this.getName()));
            }
            return res;
        }
    }

    public final String getVersion() {
        return this.getFwkMetadata("VERSION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String updateVersion() throws SQLException {
        String res;
        DateFormat dateFormat = XMLStructureSource.XMLDATE_FMT;
        synchronized (dateFormat) {
            res = XMLStructureSource.XMLDATE_FMT.format(new Date());
        }
        this.setFwkMetadata("VERSION", res);
        return res;
    }

    public final synchronized boolean isFetchAllUndefinedIDs() {
        return this.fetchAllUndefIDs;
    }
}

