/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.Tuple2;

public final class SQLRowListRSH
implements ResultSetHandler {
    private final SQLTable t;
    private final boolean tableOnly;

    private static Tuple2<SQLTable, List<String>> getIndexes(SQLSelect sel, SQLTable passedTable, boolean findTable) {
        SQLTable t;
        List<SQLField> selectFields = sel.getSelectFields();
        int size = selectFields.size();
        if (size == 0) {
            throw new IllegalArgumentException("empty select : " + sel);
        }
        if (findTable) {
            if (passedTable != null) {
                throw new IllegalArgumentException("non null table " + passedTable);
            }
            t = selectFields.get(0).getTable();
        } else {
            if (passedTable == null) {
                throw new IllegalArgumentException("null table");
            }
            t = passedTable;
        }
        List<AliasedTable> aliases = sel.getAliases(t);
        if (aliases.size() != 1) {
            throw new IllegalArgumentException(t + " isn't exactly once : " + aliases);
        }
        ArrayList<String> l = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            SQLField field = selectFields.get(i);
            if (field.getTable().equals(t)) {
                l.add(field.getName());
            } else {
                if (findTable) {
                    throw new IllegalArgumentException(field + " is not in " + t);
                }
                l.add(null);
            }
            ++i;
        }
        return Tuple2.create(t, l);
    }

    public static ResultSetHandler createFromSelect(SQLSelect sel) {
        return SQLRowListRSH.create(SQLRowListRSH.getIndexes(sel, null, true));
    }

    private static ResultSetHandler create(Tuple2<SQLTable, List<String>> names) {
        return new RSH(names);
    }

    public static List<SQLRow> execute(SQLSelect sel) {
        Tuple2<SQLTable, List<String>> indexes = SQLRowListRSH.getIndexes(sel, null, true);
        return (List)indexes.get0().getDBSystemRoot().getDataSource().execute(sel.asString(), SQLRowListRSH.create(indexes));
    }

    @Override
    public Object handle(ResultSet rs) throws SQLException {
        return SQLRow.createListFromRS(this.t, rs, this.tableOnly);
    }

    private static final class RSH
    implements ResultSetHandler {
        private final Tuple2<SQLTable, List<String>> names;

        private RSH(Tuple2<SQLTable, List<String>> names) {
            this.names = names;
        }

        @Override
        public List<SQLRow> handle(ResultSet rs) throws SQLException {
            return SQLRow.createListFromRS(this.names.get0(), rs, this.names.get1());
        }

        public int hashCode() {
            return this.names.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RSH other = (RSH)obj;
            return this.names.equals(other.names);
        }
    }
}

