/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.cc.IClosure;

public class ServerFinderConfig {
    public String type = "PostgreSQL";
    private String ip;
    private File file;
    private String port;
    private String systemRoot = "OpenConcerto";
    private String dbLogin;
    private String dbPassword;
    private String openconcertoLogin = "openconcerto";
    private String openconcertoPassword = "openconcerto";
    private String product;
    private String error;

    public String getSystemRoot() {
        return this.systemRoot;
    }

    public void setSystemRoot(String systemRoot) {
        this.systemRoot = systemRoot;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null) {
            JOptionPane.showMessageDialog(new JFrame(), "Dossier de base de donn\u00e9es non d\u00e9fini");
        } else if (!file.exists()) {
            JOptionPane.showMessageDialog(new JFrame(), "Dossier de base de donn\u00e9es inexistant");
        } else {
            File h2File = new File(file, "OpenConcerto.h2.db");
            if (!h2File.exists()) {
                JOptionPane.showMessageDialog(new JFrame(), "Le dossier de base de donn\u00e9es ne contient pas OpenConcerto.h2.db");
            } else if (h2File.length() < 50000L) {
                JOptionPane.showMessageDialog(new JFrame(), "Le dossier de base de donn\u00e9es contient un fichier OpenConcerto.h2.db vide");
            }
        }
        this.file = file;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbLogin() {
        return this.dbLogin;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getOpenconcertoLogin() {
        return this.openconcertoLogin;
    }

    public String getOpenconcertoPassword() {
        return this.openconcertoPassword;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public String getProduct() {
        return this.product;
    }

    public void setError(String string) {
        this.error = ServerFinderConfig.getFixedString(string);
    }

    static String getFixedString(String string) {
        char errorUTF = '\ufffd';
        String errorUTF2 = String.valueOf(errorUTF) + errorUTF;
        int length = string.length();
        boolean needFix = false;
        int i = 0;
        while (i < length) {
            if (string.charAt(i) == errorUTF) {
                needFix = true;
                break;
            }
            ++i;
        }
        if (needFix) {
            string = string.replace(" " + errorUTF + "chou" + errorUTF + "e ", " \u00e9chou\u00e9e ");
            string = string.replace(" " + errorUTF2 + "chou" + errorUTF2 + "e ", " \u00e9chou\u00e9e ");
            string = string.replace(errorUTF, ' ');
        }
        return string;
    }

    public String getError() {
        return this.error;
    }

    public String test() {
        String result = "Erreur de connexion. \n";
        try {
            SQLServer server = this.createServer("Common");
            DBSystemRoot r = server.getSystemRoot("OpenConcerto");
            boolean ok = CompareUtils.equals(1, r.getDataSource().executeScalar("SELECT 1"));
            if (ok) {
                result = "Connexion r\u00e9ussie sur la base OpenConcerto.";
                if (r.getChildrenNames().size() == 0) {
                    result = "Attention: la base OpenConcerto est vide";
                }
            }
            server.destroy();
        }
        catch (Exception e) {
            result = String.valueOf(result) + e.getMessage();
        }
        return ServerFinderConfig.getFixedString(result);
    }

    public boolean isOnline() {
        try {
            SQLServer server = this.createServer("public");
            DBSystemRoot r = server.getSystemRoot("OpenConcerto");
            return CompareUtils.equals(1, r.getDataSource().executeScalar("SELECT 1"));
        }
        catch (Exception e) {
            return false;
        }
    }

    public SQLServer createServer(final String root) {
        String host = this.getType().equals("H2") ? "file:" + this.getFile().getAbsolutePath() + "/" : this.getIp();
        SQLServer server = new SQLServer(this.getType(), host, String.valueOf(this.getPort()), this.getOpenconcertoLogin(), this.getOpenconcertoPassword(), new IClosure<DBSystemRoot>(){

            @Override
            public void executeChecked(DBSystemRoot input) {
                input.getRootsToMap().add(root);
            }
        }, null);
        return server;
    }

    public boolean createUserIfNeeded(String user, String password) throws Exception {
        String host = this.getType().equals("H2") ? "file:" + this.getFile().getAbsolutePath() + "/" : this.getIp();
        if (this.getType().equals("PostgreSQL")) {
            SQLServer server = new SQLServer(this.getType(), host, String.valueOf(this.getPort()), user, password, new IClosure<DBSystemRoot>(){

                @Override
                public void executeChecked(DBSystemRoot input) {
                    input.getRootsToMap().add("postgres");
                }
            }, null);
            Number n = (Number)server.getOrCreateBase("postgres").getDataSource().executeScalar("SELECT COUNT(*) FROM pg_user WHERE usename='openconcerto'");
            if (n.intValue() > 0) {
                return false;
            }
            server.getBase("postgres").getDataSource().execute("CREATE ROLE openconcerto LOGIN ENCRYPTED PASSWORD 'md51d6fb5ca62757af27ed31f93fc7751a7' SUPERUSER CREATEDB VALID UNTIL 'infinity'");
            server.destroy();
        } else {
            System.err.println("Not supported for this database");
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getType()) + ":" + this.getIp() + ":" + this.getPort() + " file:" + this.getFile() + " " + this.getOpenconcertoLogin() + "/" + this.getOpenconcertoPassword() + " [" + this.getDbLogin() + "/" + this.getDbPassword() + "]";
    }
}

