/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.sql.changer.convert.AddFK;
import org.openconcerto.sql.changer.correct.CorrectOrder;
import org.openconcerto.sql.changer.correct.FixSerial;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.DropTable;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;

public class InstallationPanel
extends JPanel {
    JProgressBar bar = new JProgressBar();
    boolean error;

    private static void insertUndef(SQLCreateTable ct) {
        String insert = "INSERT into " + InstallationPanel.getTableName(ct).quote() + "(" + SQLBase.quoteIdentifier("ORDRE") + ") VALUES(" + ReOrder.MIN_ORDER + ")";
        ct.getRoot().getDBSystemRoot().getDataSource().execute(insert);
    }

    private static SQLName getTableName(SQLCreateTable ct) {
        return new SQLName(ct.getRoot().getName(), ct.getName());
    }

    public InstallationPanel(final ServerFinderPanel finderPanel) {
        super(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JButton user = new JButton("Cr\u00e9er l'utilisateur");
        user.setOpaque(false);
        final JButton up = new JButton("Mise \u00e0 niveau de la base");
        up.setOpaque(false);
        up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                finderPanel.saveConfigFile();
                InstallationPanel.this.bar.setIndeterminate(true);
                up.setEnabled(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        final ComptaPropsConfiguration conf = ComptaPropsConfiguration.create(true);
                        try {
                            final SQLDataSource ds = conf.getSystemRoot().getDataSource();
                            System.err.println("SystemRoot:" + conf.getSystemRoot());
                            System.err.println("Root:" + conf.getRoot());
                            InstallationPanel.this.fixUnboundedVarchar(conf.getRoot());
                            final SQLTable table = conf.getRoot().getTable("VARIABLE_PAYE");
                            System.out.println("InstallationPanel.InstallationPanel() UPDATE PAYE");
                            InstallationPanel.this.updateVariablePaye(table, "SMIC", 9.0);
                            InstallationPanel.this.updateVariablePaye(table, "TRANCHE_A", 2946.0);
                            InstallationPanel.this.updateVariablePaye(table, "PART_SAL_GarantieMP", 23.83);
                            InstallationPanel.this.updateVariablePaye(table, "PART_PAT_GarantieMP", 38.98);
                            InstallationPanel.this.updateSocieteTable(conf.getRoot());
                            if (!table.getDBRoot().contains("DEVISE")) {
                                System.out.println("InstallationPanel.InstallationPanel() ADD DEVISE");
                                try {
                                    SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                                        @Override
                                        public Object create() throws SQLException {
                                            SQLCreateTable createDevise = new SQLCreateTable(table.getDBRoot(), "DEVISE");
                                            createDevise.addVarCharColumn("CODE", 128);
                                            createDevise.addVarCharColumn("NOM", 128);
                                            createDevise.addVarCharColumn("LIBELLE", 128);
                                            createDevise.addVarCharColumn("LIBELLE_CENT", 128);
                                            createDevise.addColumn("TAUX", "numeric(16,8) default 1");
                                            ds.execute(createDevise.asString());
                                            InstallationPanel.insertUndef(createDevise);
                                            conf.getRoot().getSchema().updateVersion();
                                            return null;
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DEVISE", ex);
                                }
                            }
                            if (!table.getDBRoot().contains("TYPE_MODELE")) {
                                System.out.println("InstallationPanel.InstallationPanel() ADD TYPE_MODELE");
                                try {
                                    SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                                        @Override
                                        public Object create() throws SQLException {
                                            SQLCreateTable createTypeModele = new SQLCreateTable(table.getDBRoot(), "TYPE_MODELE");
                                            createTypeModele.addVarCharColumn("NOM", 128);
                                            createTypeModele.addVarCharColumn("TABLE", 128);
                                            createTypeModele.addVarCharColumn("DEFAULT_MODELE", 128);
                                            ds.execute(createTypeModele.asString());
                                            InstallationPanel.insertUndef(createTypeModele);
                                            conf.getRoot().getSchema().updateVersion();
                                            conf.getRoot().refetch();
                                            return null;
                                        }
                                    });
                                    String[] type = new String[]{"Avoir client", "AVOIR_CLIENT", "Avoir", "Bon de livraison", "BON_DE_LIVRAISON", "BonLivraison", "Commande Client", "COMMANDE_CLIENT", "CommandeClient", "Devis", "DEVIS", "Devis", "Facture", "SAISIE_VENTE_FACTURE", "VenteFacture"};
                                    ArrayList<String> values = new ArrayList<String>();
                                    SQLBase base = table.getDBRoot().getBase();
                                    int i = 0;
                                    while (i < type.length) {
                                        int order = values.size() + 1;
                                        values.add("(" + base.quoteString(type[i]) + ", " + base.quoteString(type[i + 1]) + ", " + base.quoteString(type[i + 2]) + ", " + order + ")");
                                        i += 3;
                                    }
                                    String valuesStr = CollectionUtils.join(values, ", ");
                                    String insertVals = "INSERT INTO " + conf.getRoot().getTable("TYPE_MODELE").getSQLName().quote() + "(" + SQLBase.quoteIdentifier("NOM") + ", " + SQLBase.quoteIdentifier("TABLE") + ", " + SQLBase.quoteIdentifier("DEFAULT_MODELE") + ", " + SQLBase.quoteIdentifier("ORDRE") + ") VALUES" + valuesStr;
                                    ds.execute(insertVals);
                                }
                                catch (Exception ex) {
                                    throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TYPE_MODELE", ex);
                                }
                            }
                            conf.getSystemRoot().getRootsToMap().clear();
                            conf.getSystemRoot().refetch();
                            final Set<String> childrenNames = conf.getSystemRoot().getChildrenNames();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).InstallationPanel.this.bar.setIndeterminate(false);
                                    ((this).this).InstallationPanel.this.bar.setMaximum(childrenNames.size() + 1);
                                }
                            });
                            int i = 1;
                            for (String childName : childrenNames) {
                                System.out.println("InstallationPanel.InstallationPanel() UPDATE SCHEMA " + childName);
                                final int barValue = i++;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((this).this).InstallationPanel.this.bar.setValue(barValue);
                                    }
                                });
                                final DBRoot root = conf.getSystemRoot().getRoot(childName);
                                try {
                                    conf.getSystemRoot().getDataSource().execute("CREATE LANGUAGE plpgsql;");
                                }
                                catch (Exception e) {
                                    System.err.println("Warning: cannot add language plpgsql" + e.getMessage());
                                }
                                SQLTable tableUndef = root.getTable("FWK_UNDEFINED_IDS");
                                if (tableUndef != null && tableUndef.getField("UNDEFINED_ID").isNullable() == Boolean.FALSE) {
                                    AlterTable alterUndef = new AlterTable(tableUndef);
                                    alterUndef.alterColumn("TABLENAME", EnumSet.allOf(SQLField.Properties.class), "varchar(250)", "''", false);
                                    alterUndef.alterColumn("UNDEFINED_ID", EnumSet.allOf(SQLField.Properties.class), "int", null, true);
                                    try {
                                        ds.execute(alterUndef.asString());
                                        tableUndef.getSchema().updateVersion();
                                    }
                                    catch (SQLException ex) {
                                        throw new IllegalStateException("Erreur lors de la modification de UNDEFINED_ID", ex);
                                    }
                                }
                                if (childName.equalsIgnoreCase("Common")) {
                                    InstallationPanel.this.updateCommon(root);
                                    continue;
                                }
                                if (!childName.startsWith(conf.getAppName()) && !childName.equalsIgnoreCase("Default")) continue;
                                SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                                    @Override
                                    public Object create() throws SQLException {
                                        InstallationPanel.this.fixUnboundedVarchar(root);
                                        InstallationPanel.this.fixUnboundedNumeric(root);
                                        try {
                                            InstallationPanel.this.updateSocieteSchema(root);
                                        }
                                        catch (Exception e) {
                                            throw new SQLException(e);
                                        }
                                        InstallationPanel.this.updateToV1Dot2(root);
                                        return null;
                                    }
                                });
                            }
                            (this).InstallationPanel.this.error = false;
                        }
                        catch (Throwable e1) {
                            ExceptionHandler.handle("Echec de mise \u00e0 jour", e1);
                            (this).InstallationPanel.this.error = true;
                        }
                        conf.destroy();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                up.setEnabled(true);
                                ((this).this).InstallationPanel.this.bar.setValue(((this).this).InstallationPanel.this.bar.getMaximum());
                                if (!((this).this).InstallationPanel.this.error) {
                                    JOptionPane.showMessageDialog(InstallationPanel.this, "Mise \u00e0 niveau r\u00e9ussie");
                                }
                            }
                        });
                    }
                }, "Database structure updater").start();
            }
        });
        if (finderPanel.getToken() == null) {
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.add((Component)new JLabelBold("Cr\u00e9ation de l'utilisateur openconcerto dans la base"), c);
            ++c.gridy;
            c.weightx = 1.0;
            this.add((Component)new JLabel("Identifiant de connexion de votre base "), c);
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Login"), c);
            ++c.gridx;
            final JTextField login = new JTextField();
            c.weightx = 1.0;
            this.add((Component)login, c);
            ++c.gridx;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Mot de passe"), c);
            ++c.gridx;
            final JTextField mdp = new JTextField();
            c.weightx = 1.0;
            this.add((Component)mdp, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.anchor = 13;
            c.gridwidth = 0;
            c.fill = 0;
            this.add((Component)user, c);
            c.anchor = 17;
            c.fill = 2;
            c.gridwidth = 1;
            user.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (finderPanel.getServerConfig().createUserIfNeeded(login.getText(), mdp.getText())) {
                            JOptionPane.showMessageDialog(InstallationPanel.this, "L'utilisateur openconcerto a \u00e9t\u00e9 correctement ajout\u00e9.");
                        } else {
                            JOptionPane.showMessageDialog(InstallationPanel.this, "L'utilisateur openconcerto existe d\u00e9j\u00e0 dans la base.");
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(InstallationPanel.this, "Une erreur est survenue pendant la connexion au serveur, v\u00e9rifiez vos param\u00e8tres de connexion.");
                    }
                }
            });
            ++c.gridy;
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = new Insets(10, 3, 2, 2);
            this.add((Component)new JLabelBold("Param\u00e8trages de la base de donn\u00e9es"), c);
            ++c.gridy;
            c.insets = DefaultGridBagConstraints.getDefaultInsets();
            this.add((Component)new JLabel("Cr\u00e9ation des fonctions SQL n\u00e9cessaires (plpgsql)."), c);
            ++c.gridy;
            c.weightx = 0.0;
            c.anchor = 13;
            c.gridwidth = 0;
            c.fill = 0;
            JButton buttonPL = new JButton("Lancer");
            buttonPL.setOpaque(false);
            buttonPL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (finderPanel.getServerConfig().getType().equals("PostgreSQL")) {
                        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create(true);
                        try {
                            SQLDataSource ds = conf.getSystemRoot().getDataSource();
                            ds.execute("CREATE LANGUAGE plpgsql;");
                        }
                        catch (Exception ex) {
                            System.err.println("Impossible d'ajouter le langage PLPGSQL. Peut etre est il d\u00e9j\u00e0 install\u00e9.");
                        }
                    }
                    JOptionPane.showMessageDialog(null, "Param\u00e8trage termin\u00e9.");
                }
            });
            this.add((Component)buttonPL, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(10, 3, 2, 2);
        this.add((Component)new JLabelBold("Mise \u00e0 niveau de la base OpenConcerto"), c);
        ++c.gridy;
        c.insets = DefaultGridBagConstraints.getDefaultInsets();
        this.add((Component)new JLabel("Cette op\u00e9ration est n\u00e9cessaire \u00e0 chaque mise \u00e0 jour du logiciel."), c);
        ++c.gridy;
        this.add((Component)new JLabel("La mise \u00e0 niveau peut prendre plusieurs minutes."), c);
        ++c.gridy;
        this.add((Component)this.bar, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.anchor = 13;
        c.gridwidth = 0;
        c.fill = 0;
        this.add((Component)up, c);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.weighty = 1.0;
        ++c.gridy;
        JPanel comp = new JPanel();
        comp.setOpaque(false);
        this.add((Component)comp, c);
    }

    private void fixUnboundedNumeric(DBRoot root) throws SQLException {
        SQLField fieldRepFacture;
        SQLField fieldRemiseFacture;
        String fName;
        SQLField fieldRemiseAvoir;
        String fName2;
        ArrayList<AlterTable> alters = new ArrayList<AlterTable>();
        SQLTable tableAvoir = root.getTable("AVOIR_CLIENT_ELEMENT");
        AlterTable alter = new AlterTable(tableAvoir);
        SQLField fieldAcompteAvoir = tableAvoir.getField("POURCENT_ACOMPTE");
        if (fieldAcompteAvoir.getType().getSize() > 500) {
            fName2 = fieldAcompteAvoir.getName();
            alter.alterColumn(fName2, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "100", false);
        }
        if ((fieldRemiseAvoir = tableAvoir.getField("POURCENT_REMISE")).getType().getSize() > 500) {
            fName = fieldRemiseAvoir.getName();
            alter.alterColumn(fName, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "0", false);
        }
        if (!alter.isEmpty()) {
            alters.add(alter);
        }
        SQLTable tableFacture = root.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        alter = new AlterTable(tableFacture);
        SQLField fieldAcompteFacture = tableFacture.getField("POURCENT_ACOMPTE");
        if (fieldAcompteFacture.getType().getSize() > 500) {
            fName2 = fieldAcompteFacture.getName();
            alter.alterColumn(fName2, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "100", false);
        }
        if ((fieldRemiseFacture = tableFacture.getField("POURCENT_REMISE")).getType().getSize() > 500) {
            fName = fieldRemiseFacture.getName();
            alter.alterColumn(fName, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "0", false);
        }
        if (tableFacture.getFieldsName().contains("REPARTITION_POURCENT") && (fieldRepFacture = tableFacture.getField("REPARTITION_POURCENT")).getType().getSize() > 500) {
            String fName3 = fieldRepFacture.getName();
            alter.alterColumn(fName3, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "0", false);
        }
        if (!alter.isEmpty()) {
            alters.add(alter);
        }
        if (alters.size() > 0) {
            SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            for (String sql : ChangeTable.cat(alters, root.getName())) {
                ds.execute(sql);
            }
            root.refetch();
        }
    }

    private void fixUnboundedVarchar(DBRoot root) throws SQLException {
        Set<String> namesSet = CollectionUtils.createSet("NOM", "PRENOM", "SURNOM", "LOGIN", "PASSWORD");
        ArrayList<AlterTable> alters = new ArrayList<AlterTable>();
        for (SQLTable t : root.getTables()) {
            AlterTable alter = new AlterTable(t);
            for (SQLField f : t.getFields()) {
                if (f.getType().getType() != 12 || f.getType().getSize() != Integer.MAX_VALUE) continue;
                String fName = f.getName();
                int size = namesSet.contains(fName) ? 128 : (fName.equals("TEL") || fName.startsWith("TEL_") ? 32 : (fName.contains("INFO") ? 2048 : (fName.contains("FORMULE") ? 1024 : (fName.equals("CONTENU") ? 2048 : 256))));
                alter.alterColumn(fName, EnumSet.allOf(SQLField.Properties.class), "varchar(" + size + ")", "''", false);
            }
            if (alter.isEmpty()) continue;
            alters.add(alter);
        }
        if (alters.size() > 0) {
            SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            for (String sql : ChangeTable.cat(alters, root.getName())) {
                ds.execute(sql);
            }
            root.refetch();
        }
    }

    private void updateToV1Dot2(DBRoot root) throws SQLException {
        AlterTable alterCmd;
        SQLCreateTable createTarif;
        SQLCreateTable createModele;
        AlterTable t;
        SQLTable tableLivraisonElement = root.getTable("BON_DE_LIVRAISON_ELEMENT");
        AlterTable alter = new AlterTable(tableLivraisonElement);
        alter.alterColumn("ID_METRIQUE_2", EnumSet.of(SQLField.Properties.TYPE), "integer", null, null);
        String req3 = alter.asString();
        root.getDBSystemRoot().getDataSource().execute(req3);
        SQLTable tableDevis = root.getTable("DEVIS");
        SQLDataSource ds = root.getDBSystemRoot().getDataSource();
        if (!tableDevis.getFieldsName().contains("DATE_VALIDITE")) {
            t = new AlterTable(tableDevis);
            t.addColumn("DATE_VALIDITE", "date");
            try {
                ds.execute(t.asString());
                tableDevis.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout du champ DATE_VALIDITE \u00e0 la table DEVIS", ex);
            }
        }
        t = new AlterTable(tableDevis);
        t.alterColumn("DATE_VALIDITE", EnumSet.allOf(SQLField.Properties.class), "date", null, true);
        try {
            ds.execute(t.asString());
            tableDevis.getSchema().updateVersion();
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Erreur lors de l'ajout du champ DATE_VALIDITE \u00e0 la table DEVIS", ex);
        }
        SQLTable tableEtatDevis = root.getTable("ETAT_DEVIS");
        if (tableEtatDevis.getRow(5) == null && tableEtatDevis.getRowCount() <= 4) {
            SQLRowValues rowVals = new SQLRowValues(tableEtatDevis);
            rowVals.put("NOM", "En cours de r\u00e9daction");
            rowVals.commit();
        }
        SQLSelect selTVA = new SQLSelect(root.getBase());
        SQLTable tableTaxe = root.getTable("TAXE");
        selTVA.addSelect(tableTaxe.getKey(), "COUNT");
        selTVA.setWhere(new Where((FieldRef)tableTaxe.getField("TAUX"), "=", 0));
        Object result = root.getBase().getDataSource().executeScalar(selTVA.asString());
        if (result == null || ((Number)result).longValue() == 0L) {
            SQLRowValues rowVals = new SQLRowValues(tableTaxe);
            rowVals.put("NOM", "Non applicable");
            rowVals.put("TAUX", Float.valueOf(0.0f));
            rowVals.commit();
        }
        SQLTable tableBL = root.getTable("BON_DE_LIVRAISON");
        boolean alterBL = false;
        AlterTable t2 = new AlterTable(tableBL);
        if (!tableBL.getFieldsName().contains("SOURCE")) {
            t2.addVarCharColumn("SOURCE", 512);
            alterBL = true;
        }
        if (!tableBL.getFieldsName().contains("IDSOURCE")) {
            t2.addColumn("IDSOURCE", "integer DEFAULT 1");
            alterBL = true;
        }
        if (!tableBL.getFieldsName().contains("DATE_LIVRAISON")) {
            t2.addColumn("DATE_LIVRAISON", "date");
            alterBL = true;
        }
        if (alterBL) {
            try {
                ds.execute(t2.asString());
                tableBL.getSchema().updateVersion();
                tableBL.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table BON_DE_LIVRAISON", ex);
            }
        }
        tableBL = root.getTable("FOURNISSEUR");
        alterBL = false;
        t2 = new AlterTable(tableBL);
        if (!tableBL.getFieldsName().contains("ID_COMPTE_PCE_CHARGE")) {
            t2.addForeignColumn("ID_COMPTE_PCE_CHARGE", root.getTable("COMPTE_PCE"));
            alterBL = true;
        }
        if (alterBL) {
            try {
                ds.execute(t2.asString());
                tableBL.getSchema().updateVersion();
                tableBL.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table FOURNISSEUR", ex);
            }
        }
        SQLTable tableNum = root.getTable("NUMEROTATION_AUTO");
        boolean alterNum = false;
        t2 = new AlterTable(tableNum);
        if (!tableNum.getFieldsName().contains("AVOIR_F_START")) {
            t2.addColumn("AVOIR_F_START", "integer DEFAULT 0");
            alterNum = true;
        }
        if (!tableNum.getFieldsName().contains("AVOIR_F_FORMAT")) {
            t2.addVarCharColumn("AVOIR_F_FORMAT", 48);
            alterNum = true;
        }
        if (alterNum) {
            try {
                ds.execute(t2.asString());
                tableNum.getSchema().updateVersion();
                tableNum.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table NUMEROTATION_AUTO", ex);
            }
        }
        SQLTable tableArticle = root.getTable("ARTICLE");
        AlterTable t3 = new AlterTable(tableArticle);
        boolean alterArticle = false;
        if (!tableArticle.getFieldsName().contains("QTE_ACHAT")) {
            t3.addColumn("QTE_ACHAT", "integer DEFAULT 1");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("DESCRIPTIF")) {
            t3.addVarCharColumn("DESCRIPTIF", 2048);
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("CODE_BARRE")) {
            t3.addVarCharColumn("CODE_BARRE", 256);
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("GESTION_STOCK")) {
            t3.addColumn("GESTION_STOCK", "boolean DEFAULT true");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("CODE_DOUANIER")) {
            t3.addVarCharColumn("CODE_DOUANIER", 256);
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("QTE_MIN")) {
            t3.addColumn("QTE_MIN", "integer DEFAULT 1");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_DEVISE")) {
            t3.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_FOURNISSEUR")) {
            t3.addForeignColumn("ID_FOURNISSEUR", root.findTable("FOURNISSEUR", true));
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("PV_U_DEVISE")) {
            t3.addColumn("PV_U_DEVISE", "bigint default 0");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_DEVISE_HA")) {
            t3.addForeignColumn("ID_DEVISE_HA", root.findTable("DEVISE", true));
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("PA_DEVISE")) {
            t3.addColumn("PA_DEVISE", "bigint default 0");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_PAYS")) {
            t3.addForeignColumn("ID_PAYS", root.findTable("PAYS", true));
            alterArticle = true;
        }
        if (alterArticle) {
            try {
                ds.execute(t3.asString());
                tableArticle.getSchema().updateVersion();
                tableArticle.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table ARTICLE", ex);
            }
        }
        boolean refetchRoot = false;
        if (!root.contains("OBJECTIF_COMMERCIAL")) {
            SQLCreateTable createObjectif = new SQLCreateTable(root, "OBJECTIF_COMMERCIAL");
            createObjectif.addVarCharColumn("MOIS", 32);
            createObjectif.addColumn("ANNEE", "integer");
            createObjectif.addColumn("MARGE_HT", "bigint DEFAULT 0");
            createObjectif.addColumn("POURCENT_MARGE", "numeric (16,8)");
            createObjectif.addColumn("CHIFFRE_AFFAIRE", "bigint DeFAULT 0");
            createObjectif.addForeignColumn("COMMERCIAL");
            try {
                ds.execute(createObjectif.asString());
                InstallationPanel.insertUndef(createObjectif);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table OBJECTIF_COMMERCIAL", ex);
            }
        }
        if (!root.contains("LANGUE")) {
            SQLCreateTable createLangue = new SQLCreateTable(root, "LANGUE");
            createLangue.addVarCharColumn("CODE", 256);
            createLangue.addVarCharColumn("NOM", 256);
            createLangue.addVarCharColumn("CHEMIN", 256);
            try {
                ds.execute(createLangue.asString());
                InstallationPanel.insertUndef(createLangue);
                tableDevis.getSchema().updateVersion();
                root.refetch(createLangue.getName());
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table LANGUE", ex);
            }
            String[] langs = new String[]{"FR", "Fran\u00e7ais", "EN", "Anglais", "SP", "Espagnol", "DE", "Allemand", "NL", "N\u00e9erlandais", "IT", "Italien"};
            ArrayList<String> values = new ArrayList<String>();
            SQLBase base = root.getBase();
            int i = 0;
            while (i < langs.length) {
                int order = values.size() + 1;
                values.add("(" + base.quoteString(langs[i]) + ", " + base.quoteString(langs[i + 1]) + ", " + order + ")");
                i += 2;
            }
            String valuesStr = CollectionUtils.join(values, ", ");
            String insertVals = "INSERT INTO " + InstallationPanel.getTableName(createLangue).quote() + "(" + SQLBase.quoteIdentifier("CODE") + ", " + SQLBase.quoteIdentifier("NOM") + ", " + SQLBase.quoteIdentifier("ORDRE") + ") VALUES" + valuesStr;
            ds.execute(insertVals);
        }
        if (!root.contains("MODELE")) {
            createModele = new SQLCreateTable(root, "MODELE");
            createModele.addVarCharColumn("NOM", 256);
            createModele.addForeignColumn("ID_TYPE_MODELE", root.findTable("TYPE_MODELE", true));
            try {
                ds.execute(createModele.asString());
                InstallationPanel.insertUndef(createModele);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MODELE", ex);
            }
        }
        if (!root.contains("CONTACT_FOURNISSEUR")) {
            createModele = new SQLCreateTable(root, "CONTACT_FOURNISSEUR");
            createModele.addVarCharColumn("NOM", 256);
            createModele.addVarCharColumn("PRENOM", 256);
            createModele.addVarCharColumn("TEL_DIRECT", 256);
            createModele.addVarCharColumn("TEL_MOBILE", 256);
            createModele.addVarCharColumn("EMAIL", 256);
            createModele.addVarCharColumn("FAX", 256);
            createModele.addVarCharColumn("FONCTION", 256);
            createModele.addVarCharColumn("TEL_PERSONEL", 256);
            createModele.addVarCharColumn("TEL_STANDARD", 256);
            createModele.addForeignColumn("ID_TITRE_PERSONNEL", root.findTable("TITRE_PERSONNEL"));
            createModele.addForeignColumn("ID_FOURNISSEUR", root.findTable("FOURNISSEUR"));
            try {
                ds.execute(createModele.asString());
                InstallationPanel.insertUndef(createModele);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MODELE", ex);
            }
        }
        if (!root.contains("TARIF")) {
            createTarif = new SQLCreateTable(root, "TARIF");
            createTarif.addVarCharColumn("NOM", 256);
            createTarif.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            createTarif.addForeignColumn("ID_TAXE", root.findTable("TAXE", true));
            createTarif.asString();
            try {
                ds.execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                tableDevis.getSchema().updateVersion();
                root.refetch(createTarif.getName());
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TARIF", ex);
            }
        }
        if (!root.contains("ARTICLE_TARIF")) {
            createTarif = new SQLCreateTable(root, "ARTICLE_TARIF");
            createTarif.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            createTarif.addForeignColumn("ID_TAXE", root.findTable("TAXE", true));
            createTarif.addForeignColumn("ID_TARIF", root.findTable("TARIF", true));
            createTarif.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            createTarif.addColumn("PV_HT", "bigint DEFAULT 0");
            createTarif.addColumn("PV_TTC", "bigint DEFAULT 0");
            createTarif.addColumn("PRIX_METRIQUE_VT_1", "bigint DEFAULT 0");
            createTarif.addColumn("PRIX_METRIQUE_VT_2", "bigint DEFAULT 0");
            createTarif.addColumn("PRIX_METRIQUE_VT_3", "bigint DEFAULT 0");
            createTarif.asString();
            try {
                ds.execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARTICLE_TARIF", ex);
            }
        }
        if (!root.contains("ARTICLE_DESIGNATION")) {
            createTarif = new SQLCreateTable(root, "ARTICLE_DESIGNATION");
            createTarif.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            createTarif.addForeignColumn("ID_LANGUE", root.findTable("LANGUE", true));
            createTarif.addVarCharColumn("NOM", 1024);
            createTarif.asString();
            try {
                ds.execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARTICLE_DESIGNATION", ex);
            }
        }
        if (!root.contains("UNITE_VENTE")) {
            SQLCreateTable createUnite = new SQLCreateTable(root, "UNITE_VENTE");
            createUnite.addVarCharColumn("CODE", 32);
            createUnite.addVarCharColumn("NOM", 256);
            createUnite.addColumn("A_LA_PIECE", "boolean DEFAULT false");
            createUnite.addVarCharColumn("INFOS", 256);
            try {
                ds.execute(createUnite.asString());
                InstallationPanel.insertUndef(createUnite);
                String insert = "INSERT into " + InstallationPanel.getTableName(createUnite).quote() + "(\"CODE\",\"NOM\",\"A_LA_PIECE\",\"ORDRE\") VALUES('pi\u00e8ce','\u00e0 la pi\u00e8ce',true,1),('m','m\u00e8tres',false,2),('m\u00b2','m\u00e8tres carr\u00e9',false,3),('m3','m\u00e8tres cube',false,4),('l','litres',false,5),('kg','kilos',false,6),('h','heures',false,7),('j','jours',false,8),('mois','mois',false,9)";
                root.getDBSystemRoot().getDataSource().execute(insert);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table UNITE_VENTE", ex);
            }
        }
        if (refetchRoot) {
            root.refetch();
        }
        if (!tableArticle.getFieldsName().contains("ID_UNITE_VENTE")) {
            AlterTable alterTableArticle = new AlterTable(tableArticle);
            alterTableArticle.addForeignColumn("ID_UNITE_VENTE", root.findTable("UNITE_VENTE", true).getSQLName(), "ID", "2");
            try {
                ds.execute(alterTableArticle.asString());
                tableArticle.getSchema().updateVersion();
                tableArticle.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout du champ UNITE_VENTE sur la table ARTICLE", ex);
            }
        }
        SQLTable tableVFElt = root.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        this.addVenteEltField(tableVFElt, root);
        SQLTable tableDevisElt = root.getTable("DEVIS_ELEMENT");
        this.addVenteEltField(tableDevisElt, root);
        SQLTable tableCmdElt = root.getTable("COMMANDE_CLIENT_ELEMENT");
        this.addVenteEltField(tableCmdElt, root);
        SQLTable tableBonElt = root.getTable("BON_DE_LIVRAISON_ELEMENT");
        this.addVenteEltField(tableBonElt, root);
        SQLTable tableAvoirElt = root.getTable("AVOIR_CLIENT_ELEMENT");
        this.addVenteEltField(tableAvoirElt, root);
        SQLTable tableCmdFournElt = root.getTable("COMMANDE_ELEMENT");
        this.addHAElementField(tableCmdFournElt, root);
        SQLTable tableBonRecptElt = root.getTable("BON_RECEPTION_ELEMENT");
        this.addHAElementField(tableBonRecptElt, root);
        SQLTable tableBonRecpt = root.getTable("BON_RECEPTION");
        this.addDeviseHAField(tableBonRecpt, root);
        SQLTable tableCommande = root.getTable("COMMANDE");
        this.addDeviseHAField(tableCommande, root);
        if (!tableCommande.getFieldsName().contains("ID_ADRESSE")) {
            alterCmd = new AlterTable(tableCommande);
            alterCmd.addForeignColumn("ID_ADRESSE", root.findTable("ADRESSE", true));
            try {
                ds.execute(alterCmd.asString());
                tableCommande.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table COMMANDE", ex);
            }
        }
        if (!tableCommande.getFieldsName().contains("ID_CLIENT")) {
            alterCmd = new AlterTable(tableCommande);
            alterCmd.addForeignColumn("ID_CLIENT", root.findTable("CLIENT"));
            try {
                ds.execute(alterCmd.asString());
                tableCommande.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table COMMANDE", ex);
            }
        }
        this.addTotalDeviseField(tableDevis, root);
        this.addModeleField(tableDevis, root);
        SQLTable tableVF = root.getTable("SAISIE_VENTE_FACTURE");
        this.addTotalDeviseField(tableVF, root);
        this.addModeleField(tableVF, root);
        this.addTotalDeviseField(tableDevis, root);
        this.addModeleField(tableDevis, root);
        SQLTable tableCmd = root.getTable("COMMANDE_CLIENT");
        this.addTotalDeviseField(tableCmd, root);
        this.addModeleField(tableCmd, root);
        SQLTable tableBon = root.getTable("BON_DE_LIVRAISON");
        this.addTotalDeviseField(tableBon, root);
        this.addModeleField(tableBon, root);
        SQLTable tableAvoir = root.getTable("AVOIR_CLIENT");
        this.addTotalDeviseField(tableAvoir, root);
        this.addModeleField(tableAvoir, root);
        SQLTable tableClient = root.getTable("CLIENT");
        AlterTable tClient = new AlterTable(tableClient);
        boolean alterClient = false;
        if (!tableClient.getFieldsName().contains("ID_TARIF")) {
            tClient.addForeignColumn("ID_TARIF", root.findTable("TARIF", true));
            alterClient = true;
        }
        if (!tableClient.getFieldsName().contains("ID_PAYS")) {
            tClient.addForeignColumn("ID_PAYS", root.findTable("PAYS", true));
            alterClient = true;
        }
        if (!tableClient.getFieldsName().contains("ID_LANGUE")) {
            tClient.addForeignColumn("ID_LANGUE", root.findTable("LANGUE", true));
            alterClient = true;
        }
        if (!tableClient.getFieldsName().contains("ID_DEVISE")) {
            tClient.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alterClient = true;
        }
        if (alterClient) {
            try {
                ds.execute(tClient.asString());
                tableClient.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table CLIENT", ex);
            }
        }
        SQLTable tablePays = root.getTable("PAYS");
        AlterTable tPays = new AlterTable(tablePays);
        boolean alterPays = false;
        if (!tablePays.getFieldsName().contains("ID_TARIF")) {
            tPays.addForeignColumn("ID_TARIF", root.findTable("TARIF", true));
            alterPays = true;
        }
        if (!tablePays.getFieldsName().contains("ID_LANGUE")) {
            tPays.addForeignColumn("ID_LANGUE", root.findTable("LANGUE", true));
            alterPays = true;
        }
        if (alterPays) {
            try {
                ds.execute(tPays.asString());
                tablePays.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table PAYS", ex);
            }
        }
        SQLTable tableCmd2 = root.getTable("COMMANDE");
        AlterTable tCmd = new AlterTable(tableCmd2);
        boolean alterCmd2 = false;
        if (!tableCmd2.getFieldsName().contains("EN_COURS")) {
            tCmd.addColumn("EN_COURS", "boolean default true");
            alterCmd2 = true;
        }
        if (alterCmd2) {
            try {
                ds.execute(tCmd.asString());
                tableCmd2.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table COMMANDE", ex);
            }
        }
        SQLTable tableFournisseur = root.getTable("FOURNISSEUR");
        AlterTable tFourn = new AlterTable(tableFournisseur);
        boolean alterFourn = false;
        if (!tableFournisseur.getFieldsName().contains("ID_LANGUE")) {
            tFourn.addForeignColumn("ID_LANGUE", root.findTable("LANGUE", true));
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("ID_DEVISE")) {
            tFourn.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("RESPONSABLE")) {
            tFourn.addVarCharColumn("RESPONSABLE", 256);
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("TEL_P")) {
            tFourn.addVarCharColumn("TEL_P", 256);
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("MAIL")) {
            tFourn.addVarCharColumn("MAIL", 256);
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("INFOS")) {
            tFourn.addVarCharColumn("INFOS", 2048);
            alterFourn = true;
        }
        if (alterFourn) {
            try {
                ds.execute(tFourn.asString());
                tableFournisseur.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table FOURNISSEUR", ex);
            }
        }
        this.updateN4DS(root);
        root.refetch();
    }

    private void updateN4DS(DBRoot root) throws SQLException {
        SQLTable table = root.findTable("INFOS_SALARIE_PAYE");
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("CODE_AT")) {
            t.addVarCharColumn("CODE_AT", 18);
            alter = true;
        }
        if (!table.getFieldsName().contains("CODE_SECTION_AT")) {
            t.addVarCharColumn("CODE_SECTION_AT", 18);
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
        if (!root.contains("CODE_STATUT_CAT_CONV")) {
            SQLCreateTable createTarif = new SQLCreateTable(root, "CODE_STATUT_CAT_CONV");
            createTarif.addVarCharColumn("CODE", 6);
            createTarif.addVarCharColumn("NOM", 256);
            createTarif.asString();
            try {
                root.getBase().getDataSource().execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                String insert = "INSERT into " + InstallationPanel.getTableName(createTarif).quote() + "(\"CODE\",\"NOM\") VALUES ";
                insert = String.valueOf(insert) + " ('01','agriculteur salari\u00e9 de son exploitation')";
                insert = String.valueOf(insert) + ", ('02','artisan ou commer\u00e7ant salari\u00e9 de son entreprise')";
                insert = String.valueOf(insert) + ", ('03','cadre dirigeant (votant au coll\u00e8ge employeur des \u00e9lections prud''''hommales)')";
                insert = String.valueOf(insert) + ", ('04','autres cadres au sens de la convention collective (ou du statut pour les r\u00e9gimes sp\u00e9ciaux)')";
                insert = String.valueOf(insert) + ", ('05','profession interm\u00e9diaire (technicien, contrema\u00eetre, agent de ma\u00eetrise, clerg\u00e9)')";
                insert = String.valueOf(insert) + ", ('06','employ\u00e9 administratif d''''entreprise, de commerce, agent de service')";
                insert = String.valueOf(insert) + ", ('07','ouvriers qualifi\u00e9s et non qualifi\u00e9s y compris ouvriers agricoles');";
                createTarif.getRoot().getDBSystemRoot().getDataSource().execute(insert);
                root.getSchema().updateVersion();
                root.refetch();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_STATUT_CAT_CONV", ex);
            }
        }
        if (!root.contains("CONTACT_ADMINISTRATIF")) {
            SQLCreateTable createModele = new SQLCreateTable(root, "CONTACT_ADMINISTRATIF");
            createModele.addVarCharColumn("NOM", 256);
            createModele.addVarCharColumn("PRENOM", 256);
            createModele.addVarCharColumn("TEL_DIRECT", 256);
            createModele.addVarCharColumn("TEL_MOBILE", 256);
            createModele.addVarCharColumn("EMAIL", 256);
            createModele.addVarCharColumn("FAX", 256);
            createModele.addVarCharColumn("FONCTION", 256);
            createModele.addVarCharColumn("TEL_PERSONEL", 256);
            createModele.addVarCharColumn("TEL_STANDARD", 256);
            createModele.addForeignColumn("ID_TITRE_PERSONNEL", root.findTable("TITRE_PERSONNEL"));
            createModele.addColumn("N4DS", "boolean DEFAULT false");
            try {
                root.getBase().getDataSource().execute(createModele.asString());
                InstallationPanel.insertUndef(createModele);
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MODELE", ex);
            }
        }
        SQLTable tableContrat = root.findTable("CONTRAT_SALARIE", true);
        boolean alter2 = false;
        AlterTable t2 = new AlterTable(tableContrat);
        if (!tableContrat.getFieldsName().contains("CODE_IRC_UGRR")) {
            t2.addVarCharColumn("CODE_IRC_UGRR", 18);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("NUMERO_RATTACHEMENT_UGRR")) {
            t2.addVarCharColumn("NUMERO_RATTACHEMENT_UGRR", 64);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("CODE_IRC_UGRC")) {
            t2.addVarCharColumn("CODE_IRC_UGRC", 18);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("NUMERO_RATTACHEMENT_UGRC")) {
            t2.addVarCharColumn("NUMERO_RATTACHEMENT_UGRC", 64);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("CODE_IRC_RETRAITE")) {
            t2.addVarCharColumn("CODE_IRC_RETRAITE", 18);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("NUMERO_RATTACHEMENT_RETRAITE")) {
            t2.addVarCharColumn("NUMERO_RATTACHEMENT_RETRAITE", 64);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("ID_CODE_STATUT_CAT_CONV")) {
            t2.addForeignColumn("ID_CODE_STATUT_CAT_CONV", root.findTable("CODE_STATUT_CAT_CONV", true));
            alter2 = true;
        }
        if (alter2) {
            try {
                tableContrat.getBase().getDataSource().execute(t2.asString());
                tableContrat.getSchema().updateVersion();
                tableContrat.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + tableContrat.getName(), ex);
            }
        }
    }

    private void addDeviseHAField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("T_DEVISE")) {
            t.addColumn("T_DEVISE", "bigint default 0");
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addHAElementField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("QTE_ACHAT")) {
            t.addColumn("QTE_ACHAT", "integer DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("QTE_UNITAIRE")) {
            t.addColumn("QTE_UNITAIRE", "numeric(16,6) DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_UNITE_VENTE")) {
            t.addForeignColumn("ID_UNITE_VENTE", root.findTable("UNITE_VENTE", true).getSQLName(), "ID", "2");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_ARTICLE")) {
            t.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("PA_DEVISE")) {
            t.addColumn("PA_DEVISE", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("PA_DEVISE_T")) {
            t.addColumn("PA_DEVISE_T", "bigint default 0");
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addModeleField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("ID_MODELE")) {
            t.addForeignColumn("ID_MODELE", root.findTable("MODELE"));
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addTotalDeviseField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("T_DEVISE")) {
            t.addColumn("T_DEVISE", "bigint default 0");
            alter = true;
        } else {
            table.getBase().getDataSource().execute("UPDATE " + table.getSQLName().quote() + " SET \"T_DEVISE\"=0 WHERE \"T_DEVISE\" IS NULL");
            t.alterColumn("T_DEVISE", EnumSet.allOf(SQLField.Properties.class), "bigint", "0", false);
        }
        if (!table.getFieldsName().contains("T_POIDS")) {
            t.addColumn("T_POIDS", "real default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_TARIF")) {
            t.addForeignColumn("ID_TARIF", root.findTable("TARIF", true));
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addVenteEltField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("QTE_ACHAT")) {
            t.addColumn("QTE_ACHAT", "integer DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("QTE_UNITAIRE")) {
            t.addColumn("QTE_UNITAIRE", "numeric(16,6) DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_UNITE_VENTE")) {
            t.addForeignColumn("ID_UNITE_VENTE", root.findTable("UNITE_VENTE", true).getSQLName(), "ID", "2");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_ARTICLE")) {
            t.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("CODE_DOUANIER")) {
            t.addVarCharColumn("CODE_DOUANIER", 256);
            alter = true;
        }
        if (!table.getFieldsName().contains("DESCRIPTIF")) {
            t.addVarCharColumn("DESCRIPTIF", 2048);
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_PAYS")) {
            t.addForeignColumn("ID_PAYS", root.findTable("PAYS", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("MARGE_HT")) {
            t.addColumn("MARGE_HT", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("PV_U_DEVISE")) {
            t.addColumn("PV_U_DEVISE", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("POURCENT_REMISE")) {
            t.addColumn("POURCENT_REMISE", "numeric(6,2) default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("PV_T_DEVISE")) {
            t.addColumn("PV_T_DEVISE", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("TAUX_DEVISE")) {
            t.addColumn("TAUX_DEVISE", "numeric (16,8) DEFAULT 1");
            alter = true;
        }
        if (alter) {
            try {
                root.getDBSystemRoot().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void updateSocieteSchema(DBRoot root) throws IOException, Exception {
        DBSystemRoot sysRoot = root.getDBSystemRoot();
        SQLDataSource ds = sysRoot.getDataSource();
        System.out.println("InstallationPanel.InstallationPanel() UPDATE COMMERCIAL " + root);
        SQLTable tableCommercial = root.getTable("COMMERCIAL");
        CorrectOrder orderCorrect = new CorrectOrder(sysRoot);
        orderCorrect.change(tableCommercial);
        new AddFK(sysRoot).change(root);
        root.getSchema().updateVersion();
        root.refetch();
        sysRoot.getGraph();
        try {
            SQLTable tableArticle = root.getTable("ARTICLE");
            if (!tableArticle.getFieldsName().contains("INFOS")) {
                AlterTable t = new AlterTable(tableArticle);
                t.addVarCharColumn("INFOS", 2048);
                try {
                    ds.execute(t.asString());
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Erreur lors de l'ajout du champ INFO \u00e0 la table ARTICLE", ex);
                }
            }
            if (sysRoot.getServer().getSQLSystem().equals((Object)SQLSystem.POSTGRESQL)) {
                SQLTable tableCaisse = root.getTable("CAISSE");
                FixSerial f = new FixSerial(sysRoot);
                try {
                    f.change(tableCaisse);
                }
                catch (SQLException e2) {
                    throw new IllegalStateException("Erreur lors la mise \u00e0 jours des sequences de la table CAISSE", e2);
                }
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE TICKET_CAISSE " + root);
            SQLTable tableTicket = root.getTable("TICKET_CAISSE");
            if (!tableTicket.getFieldsName().contains("ID_MOUVEMENT")) {
                AlterTable t = new AlterTable(tableTicket);
                t.addForeignColumn("ID_MOUVEMENT", root.getTable("MOUVEMENT"));
                try {
                    ds.execute(t.asString());
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Erreur lors de l'ajout du champ ID_MOUVEMENT \u00e0 la table TICKET_CAISSE", ex);
                }
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE TYPE_REGLEMENT " + root);
            SQLTable tableReglmt = root.getTable("TYPE_REGLEMENT");
            SQLSelect sel = new SQLSelect(tableReglmt.getBase());
            sel.addSelect(tableReglmt.getKey());
            sel.setWhere(new Where((FieldRef)tableReglmt.getField("NOM"), "=", (Object)"Virement"));
            List l = ds.executeCol(sel.asString());
            if (l.size() == 0) {
                SQLRowValues rowVals = new SQLRowValues(tableReglmt);
                rowVals.put("NOM", "Virement");
                rowVals.put("COMPTANT", Boolean.FALSE);
                rowVals.put("ECHEANCE", Boolean.FALSE);
                try {
                    rowVals.commit();
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Erreur lors de l'ajout du type de paiement par virement", e);
                }
            }
            SQLSelect sel2 = new SQLSelect(tableReglmt.getBase());
            sel2.addSelect(tableReglmt.getKey());
            sel2.setWhere(new Where((FieldRef)tableReglmt.getField("NOM"), "=", (Object)"CESU"));
            List l2 = ds.executeCol(sel2.asString());
            if (l2.size() == 0) {
                SQLRowValues rowVals = new SQLRowValues(tableReglmt);
                rowVals.put("NOM", "CESU");
                rowVals.put("COMPTANT", Boolean.FALSE);
                rowVals.put("ECHEANCE", Boolean.FALSE);
                try {
                    rowVals.commit();
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Erreur lors de l'ajout du type CESU", e);
                }
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE FAMILLE_ARTICLE " + root);
            SQLTable tableFam = root.getTable("FAMILLE_ARTICLE");
            int nomSize = 256;
            if (tableFam.getField("NOM").getType().getSize() < 256) {
                AlterTable t = new AlterTable(tableFam);
                t.alterColumn("NOM", EnumSet.allOf(SQLField.Properties.class), "varchar(256)", "''", false);
                try {
                    ds.execute(t.asString());
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Erreur lors de la modification du champs NOM sur la table FAMILLE_ARTICLE", ex);
                }
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE FROM 1.0 " + root);
            ArrayList<ChangeTable> changes = new ArrayList<ChangeTable>();
            ArrayList<String> tablesToRemove = new ArrayList<String>();
            tablesToRemove.add("AFFAIRE");
            tablesToRemove.add("AFFAIRE_ELEMENT");
            tablesToRemove.add("RAPPORT");
            tablesToRemove.add("CODE_MISSION");
            tablesToRemove.add("FICHE_RENDEZ_VOUS");
            tablesToRemove.add("NATURE_MISSION");
            tablesToRemove.add("AVIS_INTERVENTION");
            tablesToRemove.add("POURCENT_CCIP");
            tablesToRemove.add("SECRETAIRE");
            tablesToRemove.add("FICHE_RENDEZ_VOUS_ELEMENT");
            tablesToRemove.add("POURCENT_SERVICE");
            tablesToRemove.add("PROPOSITION");
            tablesToRemove.add("PROPOSITION_ELEMENT");
            tablesToRemove.add("POLE_PRODUIT");
            tablesToRemove.add("BANQUE_POLE_PRODUIT");
            tablesToRemove.add("AFFACTURAGE");
            tablesToRemove.add("SECTEUR_ACTIVITE");
            ModuleManager instance = new ModuleManager();
            instance.setRoot(root);
            Set<String> modulesIds = instance.getDBInstalledModules().keySet();
            HashSet<String> allUsedTable = new HashSet<String>();
            for (String id : modulesIds) {
                Set<String> tableNames = instance.getCreatedItems(id).get0();
                allUsedTable.addAll(tableNames);
            }
            System.out.println("Tables used by modules:" + allUsedTable);
            DatabaseGraph graph = sysRoot.getGraph();
            for (String tableName : tablesToRemove) {
                if (allUsedTable.contains(tableName) || !root.contains(tableName)) continue;
                SQLTable table = root.getTable(tableName);
                for (Link link : graph.getReferentLinks(table)) {
                    if (((SQLTable)link.getSource()).getDBRoot() == root && tablesToRemove.contains(((SQLTable)link.getSource()).getName())) continue;
                    AlterTable alter = new AlterTable((SQLTable)link.getSource());
                    alter.dropForeignColumns(link);
                    changes.add(alter);
                }
                changes.add(new DropTable(table));
            }
            List<String> alterRequests = ChangeTable.cat(changes, root.getName());
            try {
                for (String req : alterRequests) {
                    ds.execute(req);
                }
            }
            catch (Exception e1) {
                throw new IllegalStateException("Erreur lors de la mise \u00e0 jour des tables v1.0", e1);
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE CAISSE " + root);
            try {
                SQLTable.setUndefID(tableTicket.getSchema(), tableTicket.getName(), 1);
                SQLTable.setUndefID(tableTicket.getSchema(), "CAISSE", 1);
            }
            catch (SQLException e1) {
                throw new IllegalStateException("Erreur lors de la mise \u00e0 jour des ind\u00e9finis de la table CAISSE", e1);
            }
        }
        finally {
            root.getSchema().updateVersion();
            root.refetch();
        }
    }

    private void updateCommon(DBRoot root) throws SQLException {
        SQLTable tableSociete = root.getTable("SOCIETE_COMMON");
        String req3 = "DELETE FROM " + tableSociete.getSQLName().quote() + " WHERE ";
        req3 = String.valueOf(req3) + new Where((FieldRef)tableSociete.getKey(), 43, (Object)47).getClause();
        root.getDBSystemRoot().getDataSource().execute(req3);
        SQLTable tableExercice = root.getTable("EXERCICE_COMMON");
        String req1a = "DELETE FROM " + tableExercice.getSQLName().quote() + " WHERE ";
        req1a = String.valueOf(req1a) + new Where((FieldRef)tableExercice.getKey(), 3, (Object)49).getClause();
        root.getDBSystemRoot().getDataSource().execute(req1a);
        root.getDBSystemRoot().getDataSource().execute(req1a);
        String req1b = "DELETE FROM " + tableExercice.getSQLName().quote() + " WHERE ";
        req1b = String.valueOf(req1b) + new Where((FieldRef)tableExercice.getKey(), 53, (Object)57).getClause();
        root.getDBSystemRoot().getDataSource().execute(req1b);
        for (String f : Arrays.asList("ID_USER_COMMON_TO", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_ASSIGN_BY")) {
            SQLTable tableTache = root.getTable("TACHE_COMMON");
            UpdateBuilder updateBuilder = new UpdateBuilder(tableTache);
            updateBuilder.set(f, "1").setWhere(new Where((FieldRef)tableTache.getField(f), "=", 0));
            String req2 = updateBuilder.asString();
            root.getDBSystemRoot().getDataSource().execute(req2);
        }
        new AddFK(root.getDBSystemRoot()).change(root);
    }

    private void updateSocieteTable(DBRoot root) throws SQLException {
        SQLTable table = root.findTable("SOCIETE_COMMON");
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("RCS")) {
            t.addVarCharColumn("RCS", 256);
            alter = true;
        }
        if (!table.getFieldsName().contains("CAPITAL")) {
            t.addColumn("CAPITAL", "bigint DEFAULT 0");
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void updateVariablePaye(SQLTable table, String var, double value) throws SQLException {
        if (table == null) {
            throw new IllegalArgumentException("null table");
        }
        SQLSelect sel = new SQLSelect(table.getBase());
        sel.addSelectStar(table);
        sel.setWhere(new Where((FieldRef)table.getField("NOM"), "=", (Object)var));
        List l = (List)table.getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        for (SQLRow sqlRow : l) {
            SQLRowValues rowVals = sqlRow.asRowValues();
            rowVals.put("VALEUR", value);
            rowVals.update();
        }
    }
}

