/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;

public class LobStorage {
    private Connection conn;
    private HashMap<String, PreparedStatement> prepared = New.hashMap();
    private long nextBlock;
    private CompressTool compress = CompressTool.getInstance();
    private final DataHandler handler;
    private boolean init;

    public LobStorage(DataHandler dataHandler) {
        this.handler = dataHandler;
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.conn = this.handler.getLobConnection();
        this.init = true;
        if (this.conn == null) {
            return;
        }
        try {
            Statement statement = this.conn.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOBS(ID BIGINT PRIMARY KEY, BYTE_COUNT BIGINT, TABLE INT) HIDDEN");
            statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_MAP(LOB BIGINT, SEQ INT, BLOCK BIGINT, PRIMARY KEY(LOB, SEQ)) HIDDEN");
            statement.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_MAP_DATA_LOB ON INFORMATION_SCHEMA.LOB_MAP(BLOCK, LOB)");
            statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_DATA(BLOCK BIGINT PRIMARY KEY, COMPRESSED INT, DATA BINARY) HIDDEN");
            ResultSet resultSet = statement.executeQuery("SELECT MAX(BLOCK) FROM INFORMATION_SCHEMA.LOB_DATA");
            resultSet.next();
            this.nextBlock = resultSet.getLong(1) + 1L;
            this.nextBlock = Math.max(65536L, this.nextBlock);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    private long getNextLobId() throws SQLException {
        PreparedStatement preparedStatement = this.prepare("SELECT MAX(ID) FROM INFORMATION_SCHEMA.LOBS");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        return resultSet.getLong(1) + 1L;
    }

    public void removeAllForTable(int n) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            try {
                PreparedStatement preparedStatement = this.prepare("SELECT ID FROM INFORMATION_SCHEMA.LOBS WHERE TABLE = ?");
                preparedStatement.setInt(1, n);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.deleteLob(resultSet.getLong(1));
                }
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
            if (n == -1) {
                this.removeAllForTable(-2);
            }
        }
        ValueLob.removeAllForTable(this.handler, n);
    }

    public static Value createSmallLob(int n, byte[] byArray) {
        if (SysProperties.LOB_IN_DATABASE) {
            int n2 = n == 16 ? StringUtils.utf8Decode(byArray).length() : byArray.length;
            return ValueLobDb.createSmallLob(n, byArray, n2);
        }
        return ValueLob.createSmallLob(n, byArray);
    }

    private synchronized PreparedStatement prepare(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepared.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.conn.prepareStatement(string);
            this.prepared.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    private void deleteLob(long l) throws SQLException {
        PreparedStatement preparedStatement = this.prepare("DELETE FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?");
        preparedStatement.setLong(1, l);
        preparedStatement.execute();
        preparedStatement = this.prepare("DELETE FROM INFORMATION_SCHEMA.LOB_DATA D WHERE BLOCK IN(SELECT M.BLOCK FROM INFORMATION_SCHEMA.LOB_MAP M WHERE LOB = ?) AND NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.LOB_MAP M WHERE M.BLOCK = D.BLOCK AND M.LOB <> ?)");
        preparedStatement.setLong(1, l);
        preparedStatement.setLong(2, l);
        preparedStatement.execute();
        preparedStatement = this.prepare("DELETE FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?");
        preparedStatement.setLong(1, l);
        preparedStatement.execute();
    }

    public InputStream getInputStream(long l) throws IOException {
        this.init();
        return new LobInputStream(this.conn, l);
    }

    private ValueLobDb addLob(InputStream inputStream, long l, int n) {
        byte[] byArray = new byte[20000];
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        long l2 = 0L;
        int n2 = this.handler.getMaxLengthInplaceLob();
        String string = this.handler.getLobCompressionAlgorithm(n);
        try {
            long l3 = this.getNextLobId();
            try {
                int n3 = 0;
                while (l > 0L) {
                    byte[] byArray2;
                    int n4 = (int)Math.min(20000L, l);
                    if ((n4 = IOUtils.readFully(inputStream, byArray, 0, n4)) <= 0) break;
                    l2 += (long)n4;
                    l -= (long)n4;
                    if (n4 != byArray.length) {
                        byArray2 = new byte[n4];
                        System.arraycopy(byArray, 0, byArray2, 0, n4);
                    } else {
                        byArray2 = byArray;
                    }
                    if (n3 == 0 && byArray2.length < 20000 && byArray2.length <= n2) {
                        ValueLobDb valueLobDb = ValueLobDb.createSmallLob(n, byArray2, byArray2.length);
                        return valueLobDb;
                    }
                    this.storeBlock(l3, n3, byArray2, string);
                    ++n3;
                }
                return this.registerLob(n, l3, -2, l2);
            }
            catch (IOException iOException) {
                this.deleteLob(l3);
                throw DbException.convertIOException(iOException, "adding blob");
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    private ValueLobDb registerLob(int n, long l, int n2, long l2) {
        try {
            PreparedStatement preparedStatement = this.prepare("INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) VALUES(?, ?, ?)");
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setInt(3, n2);
            preparedStatement.execute();
            ValueLobDb valueLobDb = ValueLobDb.create(n, this, null, n2, l, l2);
            return valueLobDb;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public ValueLobDb copyLob(int n, long l, int n2, long l2) {
        try {
            long l3 = this.getNextLobId();
            PreparedStatement preparedStatement = this.prepare("INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, BLOCK) SELECT ?, SEQ, BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?");
            preparedStatement.setLong(1, l3);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
            preparedStatement = this.prepare("INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) SELECT ?, BYTE_COUNT, ? FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?");
            preparedStatement.setLong(1, l3);
            preparedStatement.setLong(2, n2);
            preparedStatement.setLong(3, l);
            preparedStatement.executeUpdate();
            ValueLobDb valueLobDb = ValueLobDb.create(n, this, null, n2, l3, l2);
            return valueLobDb;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    synchronized void storeBlock(long l, int n, byte[] byArray, String string) throws SQLException {
        boolean bl = false;
        if (string != null) {
            byArray = this.compress.compress(byArray, string);
        }
        long l2 = (long)Arrays.hashCode(byArray) & 0xFFFFL;
        PreparedStatement preparedStatement = this.prepare("SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?");
        preparedStatement.setLong(1, l2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            boolean bl2 = resultSet.getInt(1) != 0;
            byte[] byArray2 = resultSet.getBytes(2);
            if (Arrays.equals(byArray, byArray2) && bl2 == (string != null)) {
                bl = true;
            } else {
                l2 = this.nextBlock++;
            }
        }
        if (!bl) {
            preparedStatement = this.prepare("INSERT INTO INFORMATION_SCHEMA.LOB_DATA(BLOCK, COMPRESSED, DATA) VALUES(?, ?, ?)");
            preparedStatement.setLong(1, l2);
            preparedStatement.setInt(2, string == null ? 0 : 1);
            preparedStatement.setBytes(3, byArray);
            preparedStatement.execute();
        }
        preparedStatement = this.prepare("INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, BLOCK) VALUES(?, ?, ?)");
        preparedStatement.setLong(1, l);
        preparedStatement.setInt(2, n);
        preparedStatement.setLong(3, l2);
        preparedStatement.execute();
    }

    public Value createBlob(InputStream inputStream, long l) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.conn == null) {
                return ValueLobDb.createTempBlob(inputStream, l, this.handler);
            }
            return this.addLob(inputStream, l, 15);
        }
        return ValueLob.createBlob(inputStream, l, this.handler);
    }

    public Value createClob(Reader reader, long l) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.conn == null) {
                return ValueLobDb.createTempClob(reader, l, this.handler);
            }
            long l2 = l == -1L ? Long.MAX_VALUE : l;
            CountingReaderInputStream countingReaderInputStream = new CountingReaderInputStream(reader, l2);
            ValueLobDb valueLobDb = this.addLob(countingReaderInputStream, Long.MAX_VALUE, 16);
            valueLobDb.setPrecision(countingReaderInputStream.getLength());
            return valueLobDb;
        }
        return ValueLob.createClob(reader, l, this.handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTable(long l, int n) {
        try {
            PreparedStatement preparedStatement = this.prepare("UPDATE INFORMATION_SCHEMA.LOBS SET TABLE = ? WHERE ID = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            int n2 = preparedStatement.executeUpdate();
            if (n2 == 1) return;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    static class CountingReaderInputStream
    extends InputStream {
        private final Reader reader;
        private long length;
        private long remaining;
        private int pos;
        private char[] charBuffer = new char[4096];
        private byte[] buffer;

        CountingReaderInputStream(Reader reader, long l) {
            this.reader = reader;
            this.remaining = l;
            this.buffer = Utils.EMPTY_BYTES;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.pos >= this.buffer.length) {
                this.fillBuffer();
                if (this.buffer == null) {
                    return -1;
                }
            }
            n2 = Math.min(n2, this.buffer.length - this.pos);
            System.arraycopy(this.buffer, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }

        public int read() throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.pos >= this.buffer.length) {
                this.fillBuffer();
                if (this.buffer == null) {
                    return -1;
                }
            }
            return this.buffer[this.pos++];
        }

        private void fillBuffer() throws IOException {
            int n = (int)Math.min((long)this.charBuffer.length, this.remaining);
            n = n > 0 ? this.reader.read(this.charBuffer, 0, n) : -1;
            if (n < 0) {
                this.buffer = null;
            } else {
                this.buffer = StringUtils.utf8Encode(new String(this.charBuffer, 0, n));
                this.length += (long)n;
                this.remaining -= (long)n;
            }
            this.pos = 0;
        }

        public long getLength() {
            return this.length;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    public static class LobInputStream
    extends InputStream {
        private final Connection conn;
        private PreparedStatement prepSelect;
        private byte[] buffer;
        private int pos;
        private long remainingBytes;
        private long lob;
        private int seq;
        private CompressTool compress;

        public LobInputStream(Connection connection, long l) throws IOException {
            this.conn = connection;
            try {
                this.lob = l;
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT BYTE_COUNT FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?");
                preparedStatement.setLong(1, l);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.get(90028, "Missing lob: " + l).getSQLException();
                }
                this.remainingBytes = resultSet.getLong(1);
                resultSet.close();
            }
            catch (SQLException sQLException) {
                throw DbException.convertToIOException(sQLException);
            }
        }

        public int read() throws IOException {
            this.fillBuffer();
            if (this.remainingBytes <= 0L) {
                return -1;
            }
            --this.remainingBytes;
            return this.buffer[this.pos++] & 0xFF;
        }

        public int read(byte[] byArray) throws IOException {
            return this.readFully(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.readFully(byArray, n, n2);
        }

        private int readFully(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            while (n2 > 0) {
                this.fillBuffer();
                if (this.remainingBytes <= 0L) break;
                int n4 = (int)Math.min((long)n2, this.remainingBytes);
                n4 = Math.min(n4, this.buffer.length - this.pos);
                System.arraycopy(this.buffer, this.pos, byArray, n, n4);
                this.pos += n4;
                n3 += n4;
                this.remainingBytes -= (long)n4;
                n += n4;
                n2 -= n4;
            }
            return n3 == 0 ? -1 : n3;
        }

        private void fillBuffer() throws IOException {
            if (this.buffer != null && this.pos < this.buffer.length) {
                return;
            }
            if (this.remainingBytes <= 0L) {
                return;
            }
            try {
                if (this.prepSelect == null) {
                    this.prepSelect = this.conn.prepareStatement("SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_MAP M INNER JOIN INFORMATION_SCHEMA.LOB_DATA D ON M.BLOCK = D.BLOCK WHERE M.LOB = ? AND M.SEQ = ?");
                }
                this.prepSelect.setLong(1, this.lob);
                this.prepSelect.setInt(2, this.seq);
                ResultSet resultSet = this.prepSelect.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.get(90028, "Missing lob entry: " + this.lob + "/" + this.seq).getSQLException();
                }
                ++this.seq;
                int n = resultSet.getInt(1);
                this.buffer = resultSet.getBytes(2);
                if (n != 0) {
                    if (this.compress == null) {
                        this.compress = CompressTool.getInstance();
                    }
                    this.buffer = this.compress.expand(this.buffer);
                }
                this.pos = 0;
            }
            catch (SQLException sQLException) {
                throw DbException.convertToIOException(sQLException);
            }
        }
    }
}

