/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.openconcerto.utils.convertor.NumberConvertor;

public class NumberUtils {
    static final int MAX_LONG_LENGTH = String.valueOf(Long.MAX_VALUE).length();

    public static final boolean areNumericallyEqual(Number n1, Number n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return NumberUtils.compare(n1, n2) == 0;
    }

    public static final int compare(Number n1, Number n2) {
        Class<? extends Number> biggerClass = NumberUtils.getWiderClass(n1, n2);
        if (biggerClass == AtomicInteger.class) {
            biggerClass = Integer.class;
        } else if (biggerClass == AtomicLong.class) {
            biggerClass = Long.class;
        }
        return NumberUtils.compare(n1, n2, biggerClass);
    }

    private static final <N extends Number> int compare(Number n1, Number n2, Class<N> clazz) {
        N n1Converted = NumberConvertor.convertExact(n1, clazz);
        N n2Converted = NumberConvertor.convertExact(n2, clazz);
        Comparable comparable = (Comparable)n1Converted;
        return comparable.compareTo(n2Converted);
    }

    public static final Class<? extends Number> getWiderClass(Number n1, Number n2) {
        boolean n2isFloat;
        Class<?> n2Class;
        Class<?> n1Class = n1.getClass();
        if (n1Class == (n2Class = n2.getClass())) {
            return n1Class;
        }
        if (n1Class == BigDecimal.class || n2Class == BigDecimal.class) {
            return BigDecimal.class;
        }
        boolean n1isFloat = n1Class == Float.class || n1Class == Double.class;
        boolean bl = n2isFloat = n2Class == Float.class || n2Class == Double.class;
        if (n1isFloat && n2isFloat) {
            return Double.class;
        }
        if (n1isFloat || n2isFloat) {
            if (n1Class == BigInteger.class || n2Class == BigInteger.class) {
                return BigDecimal.class;
            }
            return Double.class;
        }
        if (n1Class == BigInteger.class || n2Class == BigInteger.class) {
            return BigInteger.class;
        }
        if (n1Class == Long.class || n2Class == Long.class || n1Class == AtomicLong.class || n2Class == AtomicLong.class) {
            return Long.class;
        }
        if (n1Class == Integer.class || n2Class == Integer.class || n1Class == AtomicInteger.class || n2Class == AtomicInteger.class) {
            return Integer.class;
        }
        if (n1Class == Short.class || n2Class == Short.class) {
            return Short.class;
        }
        if (n1Class == Byte.class || n2Class == Byte.class) {
            return Byte.class;
        }
        throw new IllegalStateException("Unknown classes " + n1Class + " / " + n2Class);
    }
}

