/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;

public class SQLTableModelLinesSourceOnline
extends SQLTableModelLinesSource {
    private final SQLTableModelSourceOnline parent;
    private final PropertyChangeListener listener;

    public SQLTableModelLinesSourceOnline(SQLTableModelSourceOnline parent, ITableModel model) {
        super(model);
        this.parent = parent;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLTableModelLinesSourceOnline.this.fireChanged(evt);
            }
        };
        this.getReq().addWhereListener(this.listener);
    }

    @Override
    protected void die() {
        this.getReq().rmWhereListener(this.listener);
        super.die();
    }

    @Override
    public final SQLTableModelSourceOnline getParent() {
        return this.parent;
    }

    public final ListSQLRequest getReq() {
        return this.getParent().getReq();
    }

    @Override
    public List<ListSQLLine> getAll() {
        List<SQLRowValues> values = this.getReq().getValues();
        ArrayList<ListSQLLine> res = new ArrayList<ListSQLLine>(values.size());
        for (SQLRowValues v : values) {
            ListSQLLine newLine = this.createLine(v);
            if (newLine == null) continue;
            res.add(newLine);
        }
        return res;
    }

    @Override
    public ListSQLLine get(int id) {
        return this.createLine(this.getReq().getValues(id));
    }

    @Override
    protected int getID(SQLRowValues r) {
        return r.getID();
    }

    private BigDecimal getOrder(SQLRowAccessor r) {
        return (BigDecimal)r.getObject(r.getTable().getOrderField().getName());
    }

    @Override
    public int compare(ListSQLLine l1, ListSQLLine l2) {
        return this.getOrder(l1.getRow()).compareTo(this.getOrder(l2.getRow()));
    }

    @Override
    public void commit(ListSQLLine l, Path path, SQLRowValues vals) throws SQLException {
        vals.update();
    }
}

