/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.LineListener;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.utils.cc.IPredicate;

public abstract class SQLTableModelLinesSource {
    private final ITableModel model;
    private final List<WeakReference<ListSQLLine>> lines;
    private final List<LineListener> lineListeners = new ArrayList<LineListener>();
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private IPredicate<SQLRowValues> filter = null;

    protected SQLTableModelLinesSource(ITableModel model) {
        this.lines = new ArrayList<WeakReference<ListSQLLine>>();
        this.model = model;
    }

    void die() {
    }

    public abstract SQLTableModelSource getParent();

    public abstract List<ListSQLLine> getAll();

    public abstract ListSQLLine get(int var1);

    public abstract int compare(ListSQLLine var1, ListSQLLine var2);

    public final void addListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public final void rmListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    protected final void fireChanged(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(evt);
        }
    }

    public final void addLineListener(LineListener l) {
        this.lineListeners.add(l);
    }

    public final void rmLineListener(LineListener l) {
        this.lineListeners.remove(l);
    }

    final void fireLineChanged(int id, ListSQLLine line, Set<Integer> colIndexes) {
        for (LineListener l : this.lineListeners) {
            l.lineChanged(id, line, colIndexes);
        }
        if (line != null && colIndexes != null) {
            HashSet<Integer> dependantIndex = new HashSet<Integer>();
            for (int colIndex : colIndexes) {
                SQLTableModelColumn colChanged = this.getParent().getColumn(colIndex);
                String colID = colChanged.getIdentifier();
                int i = 0;
                for (SQLTableModelColumn col : this.getParent().getColumns()) {
                    if (col != colChanged && col.getUsedCols().contains(colID)) {
                        dependantIndex.add(i);
                    }
                    ++i;
                }
            }
            if (!dependantIndex.isEmpty()) {
                line.updateValueAt(dependantIndex);
            }
        }
    }

    protected final ListSQLLine createLine(SQLRowValues v) {
        if (v == null || this.filter != null && !this.filter.evaluateChecked(v)) {
            return null;
        }
        ListSQLLine res = new ListSQLLine(this, v, this.getID(v));
        this.lines.add(new WeakReference<ListSQLLine>(res));
        this.lineCreated(res);
        return res;
    }

    protected abstract int getID(SQLRowValues var1);

    protected void lineCreated(ListSQLLine res) {
    }

    final void colsChanged() {
        int i = 0;
        while (i < this.lines.size()) {
            WeakReference<ListSQLLine> l = this.lines.get(i);
            ListSQLLine line = (ListSQLLine)l.get();
            if (line == null) {
                this.lines.remove(i);
                continue;
            }
            line.clearCache();
            ++i;
        }
    }

    public abstract void commit(ListSQLLine var1, Path var2, SQLRowValues var3) throws SQLException;
}

