/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;

public class KeyTableCellRenderer
extends DefaultTableCellRenderer {
    private String lastStringValue;
    private Object toSelect;
    private boolean isLoading = false;
    private final SQLElement el;
    private static final Map<SQLElement, Map<Integer, IComboSelectionItem>> cacheMap = new HashMap<SQLElement, Map<Integer, IComboSelectionItem>>();

    public KeyTableCellRenderer(SQLElement el) {
        this.el = el;
        if (cacheMap.get(this.el) == null) {
            this.loadCacheAsynchronous();
        }
    }

    @Override
    public void setValue(Object value) {
        if (this.isLoading) {
            this.toSelect = value;
            this.setText("Chargement ...");
            return;
        }
        String newValue = "id non trouv\u00e9 pour:" + value;
        if (value == null) {
            return;
        }
        try {
            if (value instanceof SQLRowValues) {
                newValue = ((SQLRowValues)value).getString("CODE");
            } else {
                int id = Integer.parseInt(value.toString());
                if (id > 1) {
                    IComboSelectionItem item = cacheMap.get(this.el).get(id);
                    if (item != null) {
                        newValue = item.getLabel();
                    }
                } else {
                    newValue = "-- Ind\u00e9fini --";
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (!newValue.equals(this.lastStringValue)) {
            this.lastStringValue = newValue;
            this.setText(newValue);
        }
    }

    private void loadCacheAsynchronous() {
        this.isLoading = true;
        Configuration.getInstance().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<IComboSelectionItem> items = KeyTableCellRenderer.this.el.getComboRequest().getComboItems();
                final HashMap<Integer, IComboSelectionItem> m = new HashMap<Integer, IComboSelectionItem>();
                for (IComboSelectionItem comboSelectionItem : items) {
                    m.put(comboSelectionItem.getId(), comboSelectionItem);
                }
                cacheMap.put(KeyTableCellRenderer.this.el, m);
                KeyTableCellRenderer.this.el.getTable().addPremierTableModifiedListener(new SQLTableModifiedListener(){

                    @Override
                    public void tableModified(SQLTableEvent evt) {
                        int id = evt.getId();
                        if (evt.getMode() == SQLTableEvent.Mode.ROW_DELETED) {
                            m.remove(id);
                        } else {
                            m.put(id, KeyTableCellRenderer.this.el.getComboRequest().getComboItem(id));
                        }
                    }
                });
                KeyTableCellRenderer.this.isLoading = false;
                if (KeyTableCellRenderer.this.toSelect != null) {
                    KeyTableCellRenderer.this.setValue(KeyTableCellRenderer.this.toSelect);
                }
            }
        });
    }
}

