/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextCombo;
import org.openconcerto.ui.component.ITextComboCache;

public class SQLTextCombo
extends ITextCombo
implements RowItemViewComponent {
    public SQLTextCombo() {
    }

    public SQLTextCombo(boolean locked) {
        super(locked);
    }

    public SQLTextCombo(ComboLockedMode mode) {
        super(mode);
    }

    @Override
    public void init(SQLRowItemView v) {
        ITextComboCacheSQL cache = new ITextComboCacheSQL(v.getField());
        if (cache.isValid()) {
            this.initCache(cache);
        }
    }

    public static class ITextComboCacheSQL
    implements ITextComboCache {
        private final String field;
        private final SQLTable t;
        private final List<String> cache;
        private boolean loadedOnce;

        public ITextComboCacheSQL(SQLField f) {
            this(f.getDBRoot(), f.getFullName());
        }

        public ITextComboCacheSQL(DBRoot r, String id) {
            this.field = id;
            this.t = r.findTable("COMPLETION");
            if (!this.isValid()) {
                Log.get().warning("no completion found for " + this.field);
            }
            this.cache = new ArrayList<String>();
            this.loadedOnce = false;
        }

        @Override
        public final boolean isValid() {
            return this.t != null;
        }

        private final SQLDataSource getDS() {
            return this.t.getDBSystemRoot().getDataSource();
        }

        @Override
        public List<String> loadCache(final boolean dsCache) {
            SQLSelect sel = new SQLSelect(this.t.getBase());
            sel.addSelect(this.t.getField("LABEL"));
            sel.setWhere(new Where((FieldRef)this.t.getField("CHAMP"), "=", (Object)this.field));
            List items = (List)this.getDS().execute(sel.asString(), new IResultSetHandler(SQLDataSource.COLUMN_LIST_HANDLER){

                @Override
                public boolean readCache() {
                    return dsCache;
                }

                @Override
                public boolean writeCache() {
                    return true;
                }
            });
            this.cache.clear();
            this.cache.addAll(items);
            return this.cache;
        }

        @Override
        public List<String> getCache() {
            if (!this.loadedOnce) {
                this.loadCache(true);
                this.loadedOnce = true;
            }
            return this.cache;
        }

        @Override
        public void addToCache(String string) {
            if (!this.cache.contains(string)) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("CHAMP", this.field);
                m.put("LABEL", string);
                try {
                    new SQLRowValues(this.t, m).insert(true, false);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.cache.add(string);
            }
        }

        @Override
        public void deleteFromCache(String string) {
            Where w = new Where((FieldRef)this.t.getField("CHAMP"), "=", (Object)this.field).and(new Where((FieldRef)this.t.getField("LABEL"), "=", (Object)string));
            this.getDS().executeScalar("DELETE FROM " + this.t.getSQLName().quote() + " WHERE " + w.getClause());
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + " on " + this.field;
        }
    }
}

