/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseSQLRequest;
import org.openconcerto.utils.cc.ITransformer;

public abstract class BaseFillSQLRequest
extends BaseSQLRequest {
    public static final boolean lockSelect = !Boolean.getBoolean("org.openconcerto.sql.noSelectLock");
    private final SQLTable primaryTable;
    private Where where;
    private ITransformer<SQLSelect, SQLSelect> selTransf;
    private SQLRowValues graph;
    private SQLRowValues graphToFetch;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    public static void setupForeign(SQLRowValuesListFetcher fetcher) {
        fetcher.setFullOnly(false);
        fetcher.setIncludeForeignUndef(false);
    }

    public BaseFillSQLRequest(SQLTable primaryTable, Where w) {
        if (primaryTable == null) {
            throw new NullPointerException();
        }
        this.primaryTable = primaryTable;
        this.where = w;
        this.selTransf = null;
        this.graph = null;
        this.graphToFetch = null;
    }

    public BaseFillSQLRequest(BaseFillSQLRequest req) {
        this.primaryTable = req.getPrimaryTable();
        this.where = req.where;
        this.selTransf = req.selTransf;
        this.graph = req.getGraph();
        this.graphToFetch = req.getGraphToFetch();
    }

    private final SQLRowValues computeGraph() {
        if (this.getFields() == null) {
            return null;
        }
        SQLRowValues vals = new SQLRowValues(this.getPrimaryTable());
        for (SQLField f : this.getFields()) {
            vals.put(f.getName(), null);
        }
        for (Path orderP : this.getOrder()) {
            SQLRowValues orderVals = vals.followPath(orderP);
            if (orderVals == null || !orderVals.getTable().isOrdered()) continue;
            orderVals.put(orderVals.getTable().getOrderField().getName(), null);
        }
        this.getShowAs().expand(vals);
        return vals;
    }

    public final SQLRowValues getGraph() {
        if (this.graph == null) {
            this.graph = this.computeGraph();
        }
        return this.graph;
    }

    public final SQLRowValues getGraphToFetch() {
        if (this.graphToFetch == null && this.getGraph() != null) {
            this.graphToFetch = this.getGraph().deepCopy();
            this.customizeToFetch(this.graphToFetch);
        }
        return this.graphToFetch;
    }

    protected void customizeToFetch(SQLRowValues graphToFetch) {
    }

    protected final SQLRowValuesListFetcher getFetcher(final Where w) {
        final String tableName = this.getPrimaryTable().getName();
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(this.getGraphToFetch());
        BaseFillSQLRequest.setupForeign(fetcher);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                sel = BaseFillSQLRequest.this.transformSelect(sel);
                if (lockSelect) {
                    sel.addWaitPreviousWriteTXTable(tableName);
                }
                for (Path orderP : BaseFillSQLRequest.this.getOrder()) {
                    sel.addOrderSilent(sel.assurePath(BaseFillSQLRequest.this.getPrimaryTable().getName(), orderP));
                }
                return sel.andWhere(BaseFillSQLRequest.this.getWhere()).andWhere(w);
            }
        });
        return fetcher;
    }

    protected List<Path> getOrder() {
        return Collections.singletonList(new Path(this.getPrimaryTable()));
    }

    public final void setWhere(Where w) {
        this.where = w;
        this.fireWhereChange();
    }

    public final Where getWhere() {
        return this.where;
    }

    @Override
    public final Collection<SQLField> getAllFields() {
        return this.getFetcher(null).getReq().getFields();
    }

    protected abstract Collection<SQLField> getFields();

    protected SQLSelect transformSelect(SQLSelect sel) {
        return this.selTransf == null ? sel : this.selTransf.transformChecked(sel);
    }

    public final ITransformer<SQLSelect, SQLSelect> getSelectTransf() {
        return this.selTransf;
    }

    public final void setSelectTransf(ITransformer<SQLSelect, SQLSelect> transf) {
        this.selTransf = transf;
        this.fireWhereChange();
    }

    protected abstract FieldExpander getShowAs();

    public final SQLTable getPrimaryTable() {
        return this.primaryTable;
    }

    protected final void fireWhereChange() {
        this.supp.firePropertyChange("where", null, null);
    }

    public final void addWhereListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener("where", l);
    }

    public final void rmWhereListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener("where", l);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " on " + this.getPrimaryTable();
    }
}

