/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.request.MutableRowItemView;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.request.RowNotFound;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.request.SQLRowView;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLSearchableTextCombo;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.sqlobject.itemview.SimpleRowItemView;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.DisplayabilityListener;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.text.TextBehaviour;
import org.openconcerto.ui.component.text.TextComponentUtils;
import org.openconcerto.ui.coreanimation.Animator;
import org.openconcerto.ui.valuewrapper.BooleanValueWrapper;
import org.openconcerto.ui.valuewrapper.ValidatedValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapperFactory;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public abstract class BaseSQLComponent
extends SQLComponent
implements Scrollable {
    private final SQLRowView requete;
    private final Set<SQLRowItemView> required;
    private final Set<String> requiredNames;
    private final List<ValidListener> listeners;
    private boolean editable;
    private boolean alwaysEditable;
    private final Set<SQLField> hide;
    private FormLayouter additionalFieldsPanel;

    public BaseSQLComponent(SQLElement element) {
        super(element);
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BaseSQLComponent.this.requestFocusInWindow();
            }
        });
        this.required = new HashSet<SQLRowItemView>();
        this.requiredNames = this.createRequiredNames();
        this.listeners = new ArrayList<ValidListener>();
        this.hide = new HashSet<SQLField>();
        this.editable = true;
        this.setNonExistantEditable(false);
        this.requete = new SQLRowView(this.getTable());
    }

    private final SQLRowView getRequest() {
        return this.requete;
    }

    private SQLField getField(String field) {
        return this.getTable().getField(field);
    }

    public Component addView(String field) {
        return this.addView(field, null);
    }

    public Component addView(String field, String spec) {
        return this.addViewJComponent(field, spec);
    }

    private Component addViewJComponent(String field, Object spec) {
        if (this.getElement().getPrivateElement(field) != null) {
            SQLComponent comp = this.getElement().getPrivateElement(field).createDefaultComponent();
            SpecParser parser = SpecParser.create(spec);
            DefaultElementSQLObject dobj = new DefaultElementSQLObject(this, comp);
            dobj.setDecorated(parser.isDecorated());
            dobj.showSeparator(parser.showSeparator());
            return this.addView(dobj, field, (Object)parser);
        }
        return this.addView(BaseSQLComponent.createRowItemView(this.getComp(field, Object.class)), field, spec);
    }

    private static <T, U> ValueWrapper<? extends T> castVW(ValueWrapper<? extends U> vw, Class<U> vwType, Class<T> wantedType) {
        if (wantedType.isAssignableFrom(vwType)) {
            return vw;
        }
        throw new IllegalArgumentException("Value wrapper isn't of the wanted type");
    }

    private <T> ValueWrapper<? extends T> getComp(String field, Class<T> wantedType) {
        ValueWrapper<T> comp;
        if (this.getElement().getPrivateElement(field) != null) {
            throw new IllegalArgumentException("Private fields not supported");
        }
        SQLType type = this.getField(field).getType();
        if (this.getField(field).isKey()) {
            comp = BaseSQLComponent.createValueWrapper(new ElementComboBox(), type, wantedType);
        } else if (Boolean.class.isAssignableFrom(type.getJavaType())) {
            JCheckBox cb = new JCheckBox(" ");
            cb.setOpaque(false);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)cb, "Before");
            comp = BaseSQLComponent.addValidatedValueWrapper(BaseSQLComponent.castVW(new BooleanValueWrapper(panel, cb), Boolean.class, wantedType), type);
        } else {
            comp = Date.class.isAssignableFrom(type.getJavaType()) ? BaseSQLComponent.createValueWrapper((JComponent)((Object)new JDate()), type, wantedType) : (String.class.isAssignableFrom(type.getJavaType()) && type.getSize() >= 512 ? BaseSQLComponent.createValueWrapper(new SQLSearchableTextCombo(ComboLockedMode.UNLOCKED, true), type, wantedType) : BaseSQLComponent.createValueWrapper(new SQLTextCombo(), type, wantedType));
        }
        comp.getComp().setOpaque(false);
        return comp;
    }

    public final void addSQLObject(JComponent obj, String field) {
        this.addSQLObject(obj, field, null);
    }

    public Component addSQLObject(JComponent obj, String field, Object spec) {
        return this.addView(obj, field, spec);
    }

    public void addRequiredSQLObject(JComponent obj, String field, Object spec) {
        this.addSQLObject(obj, field, "required;" + spec);
    }

    public void addRequiredSQLObject(JComponent obj, String field) {
        this.addSQLObject(obj, field, "required");
    }

    public Component addView(JComponent comp, String fields) {
        return this.addView(comp, fields, null);
    }

    public Component addView(JComponent comp, String fields, Object specObj) {
        SimpleRowItemView<?> rowItemView;
        if (comp instanceof MutableRowItemView) {
            rowItemView = (SimpleRowItemView<?>)((Object)comp);
        } else {
            SQLField field = this.getField(SQLRow.toList(fields).get(0));
            rowItemView = BaseSQLComponent.createRowItemView(comp, field);
        }
        return this.addView(rowItemView, fields, specObj);
    }

    public static SimpleRowItemView<?> createRowItemView(JComponent comp, SQLField field) {
        if (comp == null) {
            throw new NullPointerException("comp for " + field + " is null");
        }
        if (comp instanceof MutableRowItemView) {
            throw new IllegalStateException("Comp is a MutableRowItemView, creating a SimpleRowItemView would ignore its methods : " + comp);
        }
        return BaseSQLComponent.createRowItemView(BaseSQLComponent.createValueWrapper(comp, field.getType(), Object.class));
    }

    private static <T> SimpleRowItemView<T> createRowItemView(ValueWrapper<T> vw) {
        if (vw instanceof MutableRowItemView) {
            throw new IllegalStateException("Comp is a MutableRowItemView, creating a SimpleRowItemView would ignore its methods : " + vw);
        }
        return new SimpleRowItemView<T>(vw);
    }

    private static <T> ValueWrapper<? extends T> createValueWrapper(JComponent comp, SQLType type, Class<T> wantedType) {
        Class<?> fieldClass = type.getJavaType();
        ValueWrapper<T> res = ValueWrapperFactory.create(comp, fieldClass.asSubclass(wantedType));
        return BaseSQLComponent.addValidatedValueWrapper(res, type);
    }

    private static <T> ValueWrapper<? extends T> addValidatedValueWrapper(ValueWrapper<? extends T> res, final SQLType type) {
        Class<?> fieldClass = type.getJavaType();
        if (String.class.isAssignableFrom(fieldClass)) {
            res = ValidatedValueWrapper.add(res, new ITransformer<T, ValidState>(){

                @Override
                public ValidState transformChecked(T t) {
                    String s = (String)t;
                    boolean ok = s == null || s.length() <= type.getSize();
                    return ok ? ValidState.getTrueInstance() : ValidState.create(ok, "La valeur fait " + (s.length() - type.getSize()) + " caract\u00e8re(s) de trop");
                }
            });
        } else if (BigDecimal.class.isAssignableFrom(fieldClass)) {
            final Integer decimalDigits = type.getDecimalDigits();
            final int intDigits = type.getSize() - decimalDigits;
            final String reason = "Nombre trop grand, il doit faire moins de " + intDigits + " chiffre(s) avant la virgule (" + decimalDigits + " apr\u00e8s)";
            res = ValidatedValueWrapper.add(res, new ITransformer<T, ValidState>(){

                @Override
                public ValidState transformChecked(T t) {
                    BigDecimal bd = (BigDecimal)t;
                    return ValidState.create(bd == null || DecimalUtils.intDigits(DecimalUtils.round(bd, decimalDigits)) <= intDigits, reason);
                }
            });
        }
        return res;
    }

    public Component addView(MutableRowItemView rowItemView, String fields, Object specObj) {
        return this.addInitedView(this.initRIV(rowItemView, fields), specObj);
    }

    private final <R extends MutableRowItemView> R initRIV(R rowItemView, String fields) {
        List<String> fieldListS = SQLRow.toList(fields);
        HashSet<SQLField> fieldList = new HashSet<SQLField>(fieldListS.size());
        for (String fieldName : fieldListS) {
            fieldList.add(this.getField(fieldName));
        }
        String sqlName = fields;
        rowItemView.init(sqlName, fieldList);
        return rowItemView;
    }

    public Component addInitedView(SQLRowItemView v, Object specObj) {
        JTextComponent textComp;
        SpecParser spec = SpecParser.create(specObj);
        String fieldName = v.getField().getName();
        if (spec.isRequired() || fieldName.equals(this.getElement().getParentForeignField()) || this.getRequiredNames() == null || this.getRequiredNames().contains(v.getSQLName())) {
            this.required.add(v);
            if (v instanceof ElementSQLObject) {
                ((ElementSQLObject)v).setRequired(true);
            }
        }
        this.getRequest().add(v);
        if (!this.hide.contains(v.getField())) {
            if (spec.isAdditional()) {
                if (this.additionalFieldsPanel == null) {
                    Log.get().warning("No additionalFieldsPanel for " + v.getField() + " : " + v);
                } else {
                    this.additionalFieldsPanel.add(this.getDesc(v), v.getComp());
                }
            } else {
                this.addToUI(v, spec.getWhere());
            }
        }
        if (this.dontEdit(v)) {
            v.setEditable(false);
        }
        if ((textComp = TextComponentUtils.getTextComp(v.getComp())) != null) {
            TextBehaviour.manage(textComp);
        }
        return v.getComp();
    }

    private boolean dontEdit(SQLRowItemView v) {
        String fieldName = v.getField().getName();
        return this.getElement().getReadOnlyFields().contains(fieldName) || this.getMode() != SQLComponent.Mode.INSERTION && this.getElement().getInsertOnlyFields().contains(fieldName);
    }

    @Override
    protected final void inited() {
        super.inited();
        for (Map.Entry<String, JComponent> e : this.getElement().getAdditionalFields().entrySet()) {
            SpecParser spec = new SpecParser(null, true);
            JComponent comp = e.getValue();
            if (comp == null) {
                this.addViewJComponent(e.getKey(), spec);
                continue;
            }
            this.addView(comp, e.getKey(), (Object)spec);
        }
        this.setChildrenEditable(this.isEditable());
        for (SQLRowItemView v : this.getRequest().getViews()) {
            v.addEmptyListener(new EmptyListener(){

                @Override
                public void emptyChange(EmptyObj src, boolean newValue) {
                    BaseSQLComponent.this.emptyOrValidChanged((SQLRowItemView)src);
                }
            });
            v.addValidListener(new ValidListener(){

                @Override
                public void validChange(ValidObject src, ValidState newValue) {
                    BaseSQLComponent.this.emptyOrValidChanged((SQLRowItemView)src);
                }
            });
            this.updateAnimate(v);
        }
        this.addHierarchyListener(new DisplayabilityListener(){

            @Override
            protected void displayabilityChanged(Component c) {
                BaseSQLComponent.this.getRequest().activate(c.isDisplayable());
            }
        });
        this.getRequest().activate(this.isDisplayable());
        this.fireValidChange();
        this.initDone();
    }

    protected void initDone() {
    }

    private void updateAnimate(SQLRowItemView v) {
        if (v.getComp() != null) {
            Animator.getInstance().animate(v.getComp(), !this.isItemViewValid(v));
        }
    }

    protected void emptyOrValidChanged(SQLRowItemView v) {
        this.fireValidChange();
        this.updateAnimate(v);
    }

    protected void addToUI(SQLRowItemView v, String where) {
    }

    protected final void setAdditionalFieldsPanel(FormLayouter panel) {
        this.additionalFieldsPanel = panel;
    }

    public final SQLRowItemView getView(String name) {
        return this.getRequest().getView(name);
    }

    protected final SQLRowItemView getView(Component comp) {
        return this.getRequest().getView(comp);
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.listeners.add(l);
    }

    protected final synchronized void fireValidChange() {
        ValidState validated = this.getValidState();
        for (ValidListener l : this.listeners) {
            l.validChange(this, validated);
        }
    }

    private boolean isItemViewValid(SQLRowItemView v) {
        return v.getValidState().isValid() && (!this.getRequired().contains(v) || !v.isEmpty());
    }

    @Override
    public synchronized ValidState getValidState() {
        boolean res = true;
        ArrayList<String> pbs = new ArrayList<String>();
        for (SQLRowItemView obj : this.getRequest().getViews()) {
            ValidState state = obj.getValidState();
            if (!state.isValid()) {
                String explanation = "'" + this.getDesc(obj) + "' n'est pas valide";
                String txt = state.getValidationText();
                if (txt != null) {
                    explanation = String.valueOf(explanation) + " (" + txt + ")";
                }
                pbs.add(explanation);
                res = false;
                continue;
            }
            if (!this.getRequired().contains(obj) || !obj.isEmpty()) continue;
            pbs.add("'" + this.getDesc(obj) + "' est vide");
            res = false;
        }
        return ValidState.create(res, CollectionUtils.join(pbs, "\n"));
    }

    protected final String getDesc(SQLRowItemView obj) {
        return BaseSQLComponent.getDesc(obj.getSQLName(), this.getRIVDesc(obj.getSQLName())).get0();
    }

    protected static final Tuple2<String, Boolean> getDesc(String itemName, RowItemDesc desc) {
        boolean emptyLabel = desc.getLabel() == null || desc.getLabel().trim().length() == 0;
        return Tuple2.create(emptyLabel ? itemName : desc.getLabel(), !emptyLabel);
    }

    @Override
    public void setEditable(boolean b) {
        if (b != this.editable) {
            this.editable = b;
            this.setChildrenEditable(b);
        }
    }

    private final void setChildrenEditable(boolean b) {
        for (SQLRowItemView o : this.getRequest().getViews()) {
            if (this.dontEdit(o)) continue;
            o.setEditable(this.isEditable() && b);
        }
    }

    private final boolean isEditable() {
        return this.editable;
    }

    @Override
    public final void resetValue() {
        this.select(null);
    }

    @Override
    public final int insert() {
        return this.insert(null);
    }

    @Override
    public int insert(SQLRow order) {
        try {
            if (!UserRightsManager.getCurrentUserRights().canAdd(this.getTable())) {
                throw new SQLException("forbidden");
            }
            if (order == null) {
                return this.getRequest().insert().getID();
            }
            return this.getRequest().insert(order).getID();
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, "Impossible d'ins\u00e9rer", e);
            return -1;
        }
    }

    @Override
    public final void select(int id) {
        this.select(this.getTable().getRow(id));
    }

    @Override
    public void select(SQLRowAccessor r) {
        try {
            if (r != null && !UserRightsManager.getCurrentUserRights().canView(this.getTable())) {
                throw new IllegalStateException("forbidden");
            }
            this.getRequest().select(r);
            this.setChildrenEditable(this.isNonExistantEditable() || r != null && r.getID() != -1);
            if (r == null && this.isNonExistantEditable()) {
                this.selectDefaults();
            }
        }
        catch (RowNotFound e) {
            this.getTable().fireRowDeleted(e.getRow().getID());
            ExceptionHandler.handle(this, "La ligne n'est plus dans la base : " + e.getRow(), e);
        }
        catch (IllegalStateException e) {
            ExceptionHandler.handle(this, "Impossible de s\u00e9lectionner " + r, e);
        }
    }

    private final void selectDefaults() {
        SQLRowValues defaults = this.createDefaults();
        if (defaults != null && defaults.getFields().size() > 0) {
            this.getRequest().select(defaults);
        }
    }

    public final void addFillingListener(PropertyChangeListener l) {
        this.getRequest().addListener(l, "filling");
    }

    public final void rmFillingListener(PropertyChangeListener l) {
        this.getRequest().rmListener(l, "filling");
    }

    public final void addSelectionListener(PropertyChangeListener l) {
        this.getRequest().addListener(l, "selectedID");
    }

    @Override
    public void detach() {
        this.getRequest().detach();
    }

    public final boolean isFilling() {
        return this.getRequest().isFilling();
    }

    @Override
    public int getSelectedID() {
        return this.getRequest().getSelectedID();
    }

    @Override
    public void update() {
        try {
            if (!UserRightsManager.getCurrentUserRights().canModify(this.getTable())) {
                throw new SQLException("forbidden");
            }
            this.getRequest().update();
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, "Impossible de mettre \u00e0 jour", e);
        }
    }

    @Override
    public void archive() {
        try {
            if (!UserRightsManager.getCurrentUserRights().canDelete(this.getTable())) {
                throw new SQLException("forbidden");
            }
            this.getElement().archive(this.getSelectedID());
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, "Impossible d'archiver " + this + ": ", e);
        }
    }

    protected final Set<SQLRowItemView> getRequired() {
        return this.required;
    }

    protected final Set<String> getRequiredNames() {
        return this.requiredNames;
    }

    protected Set<String> createRequiredNames() {
        return new HashSet<String>(Collections.singleton("DESIGNATION"));
    }

    @Override
    public String toString() {
        return this.getClass() + " on " + this.getTable() + " " + this.getSelectedID();
    }

    public final boolean isNonExistantEditable() {
        return this.alwaysEditable;
    }

    @Override
    public final void setNonExistantEditable(boolean alwaysEditable) {
        this.alwaysEditable = alwaysEditable;
    }

    public final String getLabelFor(String field) {
        return BaseSQLComponent.getDesc(field, this.getRIVDesc(field)).get0();
    }

    public final RowItemDesc getRIVDesc(String field) {
        return Configuration.getInstance().getTranslator().getDescFor(this.getTable(), this.getCode(), this.getElement().getMDPath(), field);
    }

    public final void setRIVDesc(String itemName, RowItemDesc desc) {
        try {
            Configuration.getTranslator(this.getTable()).storeDescFor(this.getTable(), this.getCode(), itemName, desc);
            this.updateUI(itemName, desc);
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, "Impossible d'enregistrer la documentation de " + itemName, e);
        }
    }

    protected void updateUI(String itemName, RowItemDesc desc) {
    }

    protected static void updateUI(String itemName, JComponent label, RowItemDesc desc) {
        BaseSQLComponent.updateUI(itemName, label, desc, null);
    }

    protected static void updateUI(String itemName, JComponent label, RowItemDesc desc, Color emptyLabelColor) {
        label.setToolTipText(desc.getDocumentation().trim().length() == 0 ? null : desc.getDocumentation());
        Tuple2<String, Boolean> tuple = BaseSQLComponent.getDesc(itemName, desc);
        String s = tuple.get0();
        if (label instanceof JLabel) {
            ((JLabel)label).setText(s);
        } else if (label instanceof JTextComponent) {
            ((JTextComponent)label).setText(s);
        } else if (label.getBorder() instanceof TitledBorder) {
            ((TitledBorder)label.getBorder()).setTitle(s);
        } else {
            Log.get().warning("Couldn't change label for " + itemName);
        }
        if (emptyLabelColor != null && !tuple.get1().booleanValue()) {
            label.setForeground(emptyLabelColor);
        }
        label.repaint();
    }

    public void doNotShow(SQLField f) {
        this.hide.add(f);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() >= this.getMinimumSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        double length = orientation == 1 ? visibleRect.getHeight() : visibleRect.getWidth();
        return (int)(length - 30.0);
    }

    private static interface Spec {
        public boolean isRequired();

        public String getWhere();

        public boolean isAdditional();
    }

    private static final class SpecParser
    implements Spec {
        private boolean isRequired;
        private String where;
        private boolean showSeparator = true;
        private boolean isDecorated = true;
        private final boolean isAdditional;

        public static SpecParser create(Object specObj) {
            SpecParser spec = specObj == null || specObj instanceof String ? new SpecParser((String)specObj) : (SpecParser)specObj;
            return spec;
        }

        public SpecParser(String spec) {
            this(spec, false);
        }

        public SpecParser(String spec, boolean isAdditional) {
            this.isAdditional = isAdditional;
            if (spec == null || spec.length() == 0) {
                this.isRequired = false;
                this.where = null;
            } else {
                String[] specs = spec.split(";");
                if (specs.length > 4) {
                    throw new IllegalArgumentException(spec);
                }
                int i = 0;
                while (i < specs.length) {
                    String sp = specs[i];
                    if (sp.equals("required")) {
                        this.isRequired = true;
                    } else if (sp.equals("notdecorated")) {
                        this.isDecorated = false;
                    } else if (sp.equals("noseparator")) {
                        this.showSeparator = false;
                    } else {
                        this.where = sp;
                    }
                    ++i;
                }
            }
        }

        public boolean showSeparator() {
            return this.showSeparator;
        }

        public boolean isDecorated() {
            return this.isDecorated;
        }

        @Override
        public final boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public final String getWhere() {
            return this.where;
        }

        @Override
        public final boolean isAdditional() {
            return this.isAdditional;
        }
    }
}

