/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;

public class ListeFastPrintFrame
extends JFrame {
    private final Class<? extends AbstractSheetXml> clazz;
    private final JPanel panel;
    private final List<SQLRowAccessor> liste;
    private final JLabel operation = new JLabel("");
    private final JProgressBar bar = new JProgressBar();
    private final JSpinner spin;
    Thread thread;
    private boolean cancelOp = false;
    private final JButton valid;
    private final JButton cancel;

    public ListeFastPrintFrame(List<SQLRowAccessor> liste, Class<? extends AbstractSheetXml> clazz) {
        this.panel = new JPanel(new GridBagLayout());
        this.liste = liste;
        this.clazz = clazz;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLRowAccessor row = this.liste.get(0);
        AbstractSheetXml bSheet = this.createAbstractSheet(row.asRow());
        if (this.liste.size() <= 1) {
            this.panel.add((Component)new JLabel("Lancer l'impression document"), c);
        } else {
            this.panel.add((Component)new JLabel("Lancer l'impression des " + this.liste.size() + " documents"), c);
        }
        ++c.gridx;
        c.gridwidth = 1;
        this.panel.add((Component)new JLabel("en "), c);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 15, 1);
        this.spin = new JSpinner(model);
        ++c.gridx;
        this.panel.add((Component)this.spin, c);
        ++c.gridx;
        this.panel.add(new JLabel(" exemplaire(s) sur " + bSheet.getPrinter()));
        ++c.gridy;
        c.gridx = 0;
        JPanel panelOp = new JPanel(new FlowLayout(0));
        panelOp.setBorder(BorderFactory.createEmptyBorder());
        c.gridwidth = 0;
        c.weightx = 0.0;
        panelOp.add(new JLabel("Op\u00e9ration en cours : "));
        panelOp.add(this.operation);
        this.panel.add((Component)panelOp, c);
        ++c.gridy;
        c.gridx = 0;
        this.panel.add((Component)new JLabel("Progression des impressions"), c);
        ++c.gridy;
        c.gridx = 0;
        this.panel.add((Component)this.bar, c);
        this.bar.setMaximum(this.liste.size());
        this.cancel = new JButton("Annuler");
        this.valid = new JButton("Valider");
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 13;
        c.gridx = 0;
        JPanel panelButton = new JPanel();
        panelButton.add(this.valid);
        panelButton.add(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListeFastPrintFrame.this.thread != null && ListeFastPrintFrame.this.thread.isAlive()) {
                    ListeFastPrintFrame.this.cancelOp = true;
                } else {
                    ListeFastPrintFrame.this.dispose();
                }
            }
        });
        this.valid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeFastPrintFrame.this.printAll();
            }
        });
        this.panel.add((Component)panelButton, c);
        this.getContentPane().add(this.panel);
        this.setTitle("Impressions multiples");
        this.setLocationRelativeTo(null);
        this.pack();
    }

    public void printAll() {
        this.valid.setEnabled(false);
        this.spin.setEnabled(false);
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                short copies = Short.valueOf(ListeFastPrintFrame.this.spin.getValue().toString());
                int i = 0;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ListeFastPrintFrame.this.bar.setStringPainted(true);
                        ListeFastPrintFrame.this.bar.setString("0/" + ListeFastPrintFrame.this.liste.size());
                    }
                });
                for (SQLRowAccessor rowAt : ListeFastPrintFrame.this.liste) {
                    final AbstractSheetXml bSheet = ListeFastPrintFrame.this.createAbstractSheet(rowAt.asRow());
                    if (!bSheet.getGeneratedFile().exists()) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ListeFastPrintFrame.this.operation.setText("Cr\u00e9ation du document " + bSheet.getGeneratedFile());
                                }
                            });
                            bSheet.createDocument();
                            bSheet.showPrintAndExportAsynchronous(false, false, true);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Erreur lors de l'impression du document " + bSheet.getGeneratedFile());
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ListeFastPrintFrame.this.operation.setText("Impression du document " + bSheet.getGeneratedFile());
                        }
                    });
                    bSheet.fastPrintDocument(copies);
                    final int progress = ++i;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ListeFastPrintFrame.this.bar.setValue(progress);
                            ListeFastPrintFrame.this.bar.setString(String.valueOf(progress) + "/" + ListeFastPrintFrame.this.liste.size());
                        }
                    });
                    if (ListeFastPrintFrame.this.cancelOp) break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(ListeFastPrintFrame.this, ListeFastPrintFrame.this.cancelOp ? "Impressions annul\u00e9es!" : "Impressions termin\u00e9es!");
                        ListeFastPrintFrame.this.dispose();
                    }
                });
            }
        });
        this.thread.start();
    }

    private AbstractSheetXml createAbstractSheet(SQLRow row) {
        try {
            Constructor<? extends AbstractSheetXml> ctor = this.clazz.getConstructor(SQLRow.class);
            return ctor.newInstance(row);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }
}

