/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.jopendocument.link.Component;
import org.jopendocument.model.OpenDocument;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.FastPrintAskFrame;
import org.openconcerto.erp.core.common.ui.PreviewFrame;
import org.openconcerto.erp.generationDoc.DefaultNXDocumentPrinter;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.element.TypeModeleSQLElement;
import org.openconcerto.erp.storage.CloudStorageEngine;
import org.openconcerto.erp.storage.StorageEngine;
import org.openconcerto.erp.storage.StorageEngines;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.ExceptionHandler;

public abstract class SheetXml {
    private static StorageDirs STORAGE_DIRS;
    protected SQLElement elt;
    protected String printer;
    protected SQLRow row;
    protected SQLRow rowLanguage;
    protected static final SQLBase base;
    protected static final ExecutorService runnableQueue;
    protected static Thread.UncaughtExceptionHandler DEFAULT_HANDLER;

    static {
        base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        runnableQueue = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        DEFAULT_HANDLER = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ExceptionHandler.handle("Erreur de generation", e);
            }
        };
    }

    public Future<SheetXml> showPrintAndExportAsynchronous(final boolean showDocument, final boolean printDocument, final boolean exportToPDF) {
        Callable<SheetXml> c = new Callable<SheetXml>(){

            @Override
            public SheetXml call() throws Exception {
                SheetXml.this.showPrintAndExport(showDocument, printDocument, exportToPDF);
                return SheetXml.this;
            }
        };
        return runnableQueue.submit(c);
    }

    public void showPrintAndExport(boolean showDocument, boolean printDocument, boolean exportToPDF) {
        this.showPrintAndExport(showDocument, printDocument, exportToPDF, Boolean.getBoolean("org.openconcerto.oo.useODSViewer"));
    }

    public void showPrintAndExport(boolean showDocument, boolean printDocument, boolean exportToPDF, boolean useODSViewer) {
        block10: {
            final File generatedFile = this.getGeneratedFile();
            final File pdfFile = this.getGeneratedPDFFile();
            if (generatedFile == null || !generatedFile.exists()) {
                ExceptionHandler.handle("Fichier g\u00e9n\u00e9r\u00e9 manquant: " + generatedFile);
                return;
            }
            try {
                if (!useODSViewer) {
                    Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(generatedFile, !showDocument);
                    if (printDocument) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("Name", this.printer);
                        doc.printDocument(map);
                    }
                    if (exportToPDF) {
                        doc.saveToPDF(pdfFile).get();
                    }
                    doc.close();
                    break block10;
                }
                OpenDocument doc = new OpenDocument(generatedFile);
                if (showDocument) {
                    this.showPreviewDocument();
                }
                if (printDocument) {
                    DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter();
                    printer.print(doc);
                }
                if (!exportToPDF) break block10;
                try {
                    SheetUtils.convert2PDF(doc, pdfFile);
                }
                catch (Throwable e) {
                    ExceptionHandler.handle("Impossible de cr\u00e9er le PDF.", e);
                }
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        List<StorageEngine> engines = StorageEngines.getInstance().getActiveEngines();
                        for (StorageEngine storageEngine : engines) {
                            String path;
                            BufferedInputStream inStream;
                            if (!storageEngine.isConfigured() || !storageEngine.allowAutoStorage()) continue;
                            try {
                                storageEngine.connect();
                                inStream = new BufferedInputStream(new FileInputStream(pdfFile));
                                path = SheetXml.this.getStoragePath();
                                storageEngine.store(inStream, path, pdfFile.getName(), true);
                                inStream.close();
                                storageEngine.disconnect();
                            }
                            catch (IOException e) {
                                ExceptionHandler.handle("Impossible de sauvegarder le PDF");
                            }
                            if (!(storageEngine instanceof CloudStorageEngine)) continue;
                            try {
                                storageEngine.connect();
                                inStream = new BufferedInputStream(new FileInputStream(generatedFile));
                                path = SheetXml.this.getStoragePath();
                                storageEngine.store(inStream, path, generatedFile.getName(), true);
                                inStream.close();
                                storageEngine.disconnect();
                            }
                            catch (IOException e) {
                                ExceptionHandler.handle("Impossible de sauvegarder le fichier g\u00e9n\u00e9r\u00e9");
                            }
                        }
                    }
                });
                t.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        }
    }

    public abstract String getDefaultTemplateId();

    public final String getStoragePath() {
        String res;
        String string = res = STORAGE_DIRS == null ? null : STORAGE_DIRS.getStoragePath(this);
        if (res != null) {
            return res;
        }
        return this.getStoragePathP();
    }

    public final File getDocumentOutputDirectory() {
        File res;
        File file = res = STORAGE_DIRS == null ? null : STORAGE_DIRS.getDocumentOutputDirectory(this);
        if (res != null) {
            return res;
        }
        return this.getDocumentOutputDirectoryP();
    }

    protected abstract String getStoragePathP();

    protected abstract File getDocumentOutputDirectoryP();

    public abstract String getName();

    public String getTemplateId() {
        if (this.row != null && this.row.getTable().getFieldsName().contains("ID_MODELE")) {
            SQLRow rowModele = this.row.getForeignRow("ID_MODELE");
            if (rowModele.isUndefined()) {
                TypeModeleSQLElement typeModele = Configuration.getInstance().getDirectory().getElement(TypeModeleSQLElement.class);
                String modele = typeModele.getTemplateMapping().get(this.row.getTable().getName());
                if (modele == null) {
                    System.err.println("No default modele in table TYPE_MODELE for table " + this.row.getTable().getName());
                    Thread.dumpStack();
                    return this.getDefaultTemplateId();
                }
                return modele;
            }
            return rowModele.getString("NOM");
        }
        return this.getDefaultTemplateId();
    }

    public abstract Future<SheetXml> createDocumentAsynchronous();

    public void createDocument() throws InterruptedException, ExecutionException {
        this.createDocumentAsynchronous().get();
    }

    public abstract File getGeneratedFile();

    public File getGeneratedPDFFile() {
        return SheetUtils.getFileWithExtension(this.getGeneratedFile(), ".pdf");
    }

    public SQLRow getRowLanguage() {
        return this.rowLanguage;
    }

    public String getReference() {
        return "";
    }

    public File getOrCreateDocumentFile() throws Exception {
        File f = this.getGeneratedFile();
        if (!f.exists()) {
            return this.createDocumentAsynchronous().get().getGeneratedFile();
        }
        return f;
    }

    public File getOrCreatePDFDocumentFile(boolean createRecent) throws Exception {
        return this.getOrCreatePDFDocumentFile(createRecent, Boolean.getBoolean("org.openconcerto.oo.useODSViewer"));
    }

    public File getOrCreatePDFDocumentFile(boolean createRecent, boolean useODSViewer) throws Exception {
        File f = this.getGeneratedPDFFile();
        if (!f.exists()) {
            this.getOrCreateDocumentFile();
            this.showPrintAndExport(false, false, true, useODSViewer);
            return f;
        }
        File fODS = this.getOrCreateDocumentFile();
        if (fODS.lastModified() > f.lastModified()) {
            this.showPrintAndExport(false, false, true, useODSViewer);
        }
        return f;
    }

    public void openDocument(boolean synchronous) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    File f = SheetXml.this.getOrCreateDocumentFile();
                    OOUtils.open((File)f);
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Impossible d'ouvrir le document.", e);
                }
            }
        };
        if (synchronous) {
            r.run();
        } else {
            Thread thread = new Thread(r, "openDocument: " + this.getGeneratedFile().getAbsolutePath());
            thread.setDaemon(true);
            thread.start();
        }
    }

    public void showPreviewDocument() throws Exception {
        File f = null;
        f = this.getOrCreateDocumentFile();
        PreviewFrame.show(f);
    }

    public void fastPrintDocument() {
        FastPrintAskFrame f = new FastPrintAskFrame(this);
        f.display();
    }

    public void fastPrintDocument(short copies) {
        try {
            File f = this.getOrCreateDocumentFile();
            if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
                Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(f, true);
                HashMap<String, String> map = new HashMap<String, String>();
                if (this.printer == null || this.printer.trim().length() == 0) {
                    PrintService printer = PrintServiceLookup.lookupDefaultPrintService();
                    this.printer = printer.getName();
                }
                map.put("Name", this.printer);
                HashMap<String, Comparable<Short>> map2 = new HashMap<String, Comparable<Short>>();
                map2.put("CopyCount", Short.valueOf(copies));
                map2.put("Collate", Boolean.TRUE);
                doc.printDocument(map, map2);
                doc.close();
            } else {
                OpenDocument doc = new OpenDocument(f);
                DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter(this.printer, copies);
                printer.print(doc);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de charger le document OpentOffice", e);
            e.printStackTrace();
        }
    }

    public void printDocument() {
        try {
            File f = this.getOrCreateDocumentFile();
            if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
                Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(f, true);
                doc.printDocument();
                doc.close();
            } else {
                OpenDocument doc = new OpenDocument(f);
                DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter();
                printer.print(doc);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de charger le document OpentOffice", e);
            e.printStackTrace();
        }
    }

    public SQLRow getSQLRow() {
        return this.row;
    }

    static String getValidFileName(String fileName) {
        StringBuffer result = new StringBuffer(fileName.length());
        int i = 0;
        while (i < fileName.length()) {
            char ch = fileName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == ' ') {
                result.append(ch);
            } else {
                result.append('-');
            }
            ++i;
        }
        return result.toString();
    }

    public String getPrinter() {
        return this.printer;
    }

    public static interface StorageDirs {
        public File getDocumentOutputDirectory(SheetXml var1);

        public String getStoragePath(SheetXml var1);
    }
}

