/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.erp.generationDoc.OOXMLElement;
import org.openconcerto.erp.generationDoc.OOXMLField;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.GestionDevise;

public class OOXMLTableField
extends OOXMLField {
    private String type;
    private int filterId;
    private int line;
    private String lineOption;
    private int idRef;
    private String style = "";

    public OOXMLTableField(Element eltField, SQLRowAccessor row, SQLElement sqlElt, int id, int filterId, SQLRow rowLanguage, int idRef, OOXMLCache cache) {
        super(eltField, row, sqlElt, id, rowLanguage, cache);
        String style;
        this.type = eltField.getAttributeValue("type");
        this.lineOption = eltField.getAttributeValue("lineOption");
        this.filterId = filterId;
        String s = eltField.getAttributeValue("line");
        this.line = 1;
        this.idRef = idRef;
        if (s != null && s.trim().length() > 0) {
            this.line = Integer.valueOf(s);
        }
        if ((style = eltField.getAttributeValue("style")) != null && style.trim().length() > 0) {
            this.style = style;
        }
    }

    @Override
    public Object getValue() {
        Object value = null;
        SpreadSheetCellValueProvider provider = SpreadSheetCellValueProviderManager.get(this.type);
        if (provider != null) {
            SpreadSheetCellValueContext context = new SpreadSheetCellValueContext(this.row);
            List attrs = this.elt.getAttributes();
            for (Attribute attr : attrs) {
                context.put(attr.getName(), attr.getValue());
            }
            return provider.getValue(context);
        }
        if (this.type.equalsIgnoreCase("LineReference")) {
            return this.idRef;
        }
        if (this.type.equalsIgnoreCase("DescriptifArticle")) {
            value = OOXMLTableField.getDescriptifArticle(this.row);
        } else if (this.type.equalsIgnoreCase("DateEcheance")) {
            value = this.getDateEcheance(this.row.getInt("ID_MODE_REGLEMENT"), (Date)this.row.getObject("DATE"), this.elt.getAttributeValue("DatePattern"));
        } else if (this.type.equalsIgnoreCase("MontantRevise")) {
            value = this.getMontantRevise(this.row);
        } else if (this.type.equalsIgnoreCase("Localisation")) {
            value = OOXMLTableField.getLocalisation(this.row);
        } else {
            OOXMLElement eltXml = new OOXMLElement(this.elt, this.sqlElt, this.id, this.row, this.rowLanguage, this.cache);
            value = eltXml.getValue();
        }
        return value;
    }

    public boolean isNeeding2Lines() {
        return this.type.equalsIgnoreCase("DescriptifArticle") || this.type.equalsIgnoreCase("propositionFacture") || this.type.equalsIgnoreCase("DateEcheance") || this.type.equalsIgnoreCase("MontantRevise");
    }

    public int getLine() {
        return this.line;
    }

    public boolean isLineOption() {
        return Boolean.valueOf(this.lineOption);
    }

    private static String getDescriptifArticle(SQLRowAccessor row) {
        float longueur = row.getFloat("VALEUR_METRIQUE_1");
        float largeur = row.getFloat("VALEUR_METRIQUE_2");
        StringBuffer result = new StringBuffer();
        if (longueur != 0.0f) {
            result.append(" Longueur: " + longueur + " m");
        }
        if (largeur != 0.0f) {
            result.append(" Largeur: " + largeur + " m");
        }
        if (largeur != 0.0f && longueur != 0.0f) {
            result.append(" Surface : " + (double)Math.round(largeur * longueur * 1000.0f) / 1000.0 + " m\u00b2");
        }
        return result.toString();
    }

    private static String getLocalisation(SQLRowAccessor row) {
        StringBuffer string = new StringBuffer();
        String site = row.getString("LOCAL_OBJET_INSPECTE");
        if (site != null) {
            string.append(site);
        }
        Object date = row.getObject("DATE");
        Object dateFin = row.getObject("DATE_FIN");
        if (date != null) {
            String stringDate = format.format((Date)date);
            if (dateFin != null) {
                String stringDateFin = format.format((Date)dateFin);
                string.append(" du " + stringDate + " au " + stringDateFin);
            } else {
                string.append(" le " + stringDate);
            }
        }
        return string.toString();
    }

    private String getMontantRevise(SQLRowAccessor row) {
        long indice0 = (Long)row.getObject("INDICE_0");
        long indiceN = (Long)row.getObject("INDICE_N");
        long montantInit = (Long)row.getObject("MONTANT_INITIAL");
        if (indice0 == indiceN || indice0 == 0L) {
            return null;
        }
        Boolean clientPrive = false;
        try {
            SQLRowAccessor rowClient;
            SQLRowAccessor rowFact = row.getTable().getName().startsWith("SAISIE_VENTE_FACTURE") ? this.cache.getForeignRow(row, row.getTable().getField("ID_SAISIE_VENTE_FACTURE")) : this.cache.getForeignRow(row, row.getTable().getField("ID_AVOIR_CLIENT"));
            if (rowFact != null && (rowClient = this.cache.getForeignRow(rowFact, rowFact.getTable().getField("ID_CLIENT"))) != null) {
                clientPrive = rowClient.getBoolean("MARCHE_PRIVE");
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        StringBuffer result = new StringBuffer();
        result.append("D\u00e9tail : ");
        if (clientPrive.booleanValue()) {
            result.append(GestionDevise.currencyToString(indiceN));
            result.append(" / ");
            result.append(GestionDevise.currencyToString(indice0));
            result.append(" x ");
            result.append(GestionDevise.currencyToString(montantInit));
            result.append(" \u20ac HT");
            return result.toString();
        }
        result.append("(0,15 + 0,85 x (");
        result.append(GestionDevise.currencyToString(indiceN));
        result.append(" / ");
        result.append(GestionDevise.currencyToString(indice0));
        result.append(")) x ");
        result.append(GestionDevise.currencyToString(montantInit));
        result.append(" \u20ac HT");
        return result.toString();
    }

    public List<String> getBlankStyle() {
        String blankOnStyle = this.elt.getAttributeValue("blankOnStyle");
        List<String> listBlankStyle = new ArrayList<String>();
        if (blankOnStyle != null) {
            listBlankStyle = SQLRow.toList(blankOnStyle.trim());
        }
        return listBlankStyle;
    }

    public String getStyle() {
        return this.style;
    }
}

