/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import org.openconcerto.erp.generationDoc.AbstractLocalTemplateProvider;

public class DefaultLocalTemplateProvider
extends AbstractLocalTemplateProvider {
    private static final String[] EXTS = new String[]{".ods", ".odsp", ".xml"};
    private File baseDirectory = new File("Configuration/Template/Default");

    public void setBaseDirectory(File dir) {
        this.baseDirectory = dir;
    }

    @Override
    public File getTemplateFromLocalFile(String templateIdWithExtension, String language, String type) {
        File file = this.getLocalFile(templateIdWithExtension, language, type);
        if (!file.exists()) {
            file = this.getFile(templateIdWithExtension, language, type);
        }
        return file;
    }

    private File getLocalFile(String templateIdWithExtension, String language, String type) {
        String localPath = templateIdWithExtension;
        if (type != null) {
            localPath = DefaultLocalTemplateProvider.insertBeforeExtenstion(localPath, type);
        }
        localPath = language != null && language.trim().length() > 0 ? String.valueOf(language) + File.separatorChar + "local_" + localPath : "local_" + localPath;
        File file = new File(this.baseDirectory, localPath);
        return file;
    }

    private File getFile(String templateIdWithExtension, String language, String type) {
        File file;
        String path = templateIdWithExtension;
        if (type != null) {
            path = DefaultLocalTemplateProvider.insertBeforeExtenstion(path, type);
        }
        if (language != null && language.trim().length() > 0) {
            path = String.valueOf(language) + File.separatorChar + path;
        }
        if (!(file = new File(this.baseDirectory, path)).exists()) {
            file = new File("Configuration/Template/Default", path);
        }
        return file;
    }
}

