/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.openconcerto.erp.generationDoc.TemplateProvider;

public abstract class AbstractLocalTemplateProvider
implements TemplateProvider {
    @Override
    public InputStream getTemplate(String templateId, String language, String type) {
        File file = this.getFileTemplate(templateId, language, type);
        return file == null ? null : this.getInputStream(file);
    }

    private FileInputStream getInputStream(File f) {
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: no file:" + f.getAbsolutePath());
            e.printStackTrace();
            return null;
        }
    }

    public File getFileTemplate(String templateId, String language, String type) {
        File templateFile = this.getTemplateFromLocalFile(templateId, language, type);
        if (templateFile != null && templateFile.exists()) {
            return templateFile;
        }
        templateFile = this.getTemplateFromLocalFile(String.valueOf(templateId) + ".ods", language, type);
        if (templateFile != null && templateFile.exists()) {
            return templateFile;
        }
        templateFile = this.getTemplateFromLocalFile(String.valueOf(templateId) + ".odt", language, type);
        if (templateFile != null && templateFile.exists()) {
            return templateFile;
        }
        return null;
    }

    @Override
    public InputStream getTemplatePrintConfiguration(String templateId, String language, String type) {
        File file = this.getFileTemplatePrintConfiguration(templateId, language, type);
        return this.getInputStream(file);
    }

    public File getFileTemplatePrintConfiguration(String templateId, String language, String type) {
        File file = this.getTemplateFromLocalFile(String.valueOf(templateId) + ".odsp", language, type);
        return file;
    }

    @Override
    public InputStream getTemplateConfiguration(String templateId, String language, String type) {
        File file = this.getFileTemplateConfiguration(templateId, language, type);
        return this.getInputStream(file);
    }

    public File getFileTemplateConfiguration(String templateId, String language, String type) {
        File file = this.getTemplateFromLocalFile(String.valueOf(templateId) + ".xml", language, type);
        return file;
    }

    protected abstract File getTemplateFromLocalFile(String var1, String var2, String var3);

    public static String insertBeforeExtenstion(String fileName, String text) {
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            throw new IllegalArgumentException("No extension found in fileName '" + fileName + "'");
        }
        if (index == 0) {
            return String.valueOf(fileName) + text;
        }
        String name = fileName.substring(0, index);
        String ext = fileName.substring(index);
        return String.valueOf(name) + text + ext;
    }
}

