/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.supplychain.order.component.CommandeSQLComponent;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.core.supplychain.supplier.component.MouvementStockSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.ExceptionHandler;

public class MouvementStockSQLElement
extends ComptaSQLConfElement {
    private final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");

    public MouvementStockSQLElement() {
        super("MOUVEMENT_STOCK", "un mouvement de stock", "mouvements de stock");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("ID_ARTICLE");
        l.add("QTE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("QTE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new MouvementStockSQLComponent(this);
    }

    @Override
    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        super.archive(row, cutLinks);
        this.updateStock(Arrays.asList(row.getID()), true);
    }

    public void createMouvement(SQLRow rowOrigin, SQLTable eltTable, StockLabel label, boolean entry) {
        SQLSelect selEltfact = new SQLSelect(rowOrigin.getTable().getBase());
        selEltfact.addSelectStar(eltTable);
        selEltfact.setWhere(new Where((FieldRef)((SQLField)eltTable.getForeignKeys(rowOrigin.getTable()).toArray()[0]), "=", rowOrigin.getID()));
        List<SQLRow> lElt = SQLRowListRSH.execute(selEltfact);
        boolean modeAvance = DefaultNXProps.getInstance().getBooleanValue("ArticleModeVenteAvance", false);
        SQLPreferences prefs = new SQLPreferences(eltTable.getDBRoot());
        boolean createArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        if (lElt != null) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (SQLRow rowElt : lElt) {
                SQLRowValues rowVals;
                int idArticle;
                SQLRow rowArticleAssocie;
                SQLRow sQLRow = rowArticleAssocie = rowElt.getTable().contains("ID_ARTICLE") ? rowElt.getForeign("ID_ARTICLE") : null;
                if ((rowArticleAssocie == null || rowArticleAssocie.isUndefined()) && rowElt.getString("CODE").trim().length() <= 0) continue;
                if (rowArticleAssocie == null || rowArticleAssocie.isUndefined()) {
                    SQLRowValues rowArticle = new SQLRowValues(this.sqlTableArticle);
                    for (SQLField field : this.sqlTableArticle.getFields()) {
                        if (!rowElt.getTable().getFieldsName().contains(field.getName())) continue;
                        rowArticle.put(field.getName(), rowElt.getObject(field.getName()));
                    }
                    idArticle = modeAvance ? ReferenceArticleSQLElement.getIdForCNM(rowArticle, createArticle) : ReferenceArticleSQLElement.getIdForCN(rowArticle, createArticle);
                    if (idArticle > 0 && idArticle != this.sqlTableArticle.getUndefinedID()) {
                        rowVals = rowElt.asRowValues();
                        rowVals.put("ID_ARTICLE", idArticle);
                        try {
                            rowVals.update();
                        }
                        catch (SQLException exn) {
                            exn.printStackTrace();
                        }
                    }
                } else {
                    idArticle = rowArticleAssocie.getID();
                }
                SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
                rowVals = new SQLRowValues(eltMvtStock.getTable());
                if (entry) {
                    rowVals.put("QTE", rowElt.getInt("QTE"));
                } else {
                    rowVals.put("QTE", -rowElt.getInt("QTE"));
                }
                rowVals.put("NOM", label.getLabel(rowOrigin, rowElt));
                rowVals.put("IDSOURCE", rowOrigin.getID());
                rowVals.put("SOURCE", rowOrigin.getTable().getName());
                rowVals.put("ID_ARTICLE", idArticle);
                rowVals.put("DATE", rowOrigin.getObject("DATE"));
                try {
                    SQLRow row = rowVals.insert();
                    l.add(row.getID());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            CollectionMap<SQLRow, List<SQLRowValues>> map = this.updateStock(l, false);
            if (map.keySet().size() > 0) {
                if (!rowOrigin.getTable().contains("ID_TARIF")) {
                    System.err.println("Attention la table " + rowOrigin.getTable().getName() + " ne contient pas le champ ID_TARIF. La cr\u00e9ation automatique d'une commande fournisseur est donc impossible!");
                    Thread.dumpStack();
                } else if (JOptionPane.showConfirmDialog(null, "Certains articles sont en dessous du stock minimum.\n Voulez cr\u00e9er une commande?") == 0) {
                    MouvementStockSQLElement.createCommandeF(map, rowOrigin.getForeignRow("ID_TARIF").getForeignRow("ID_DEVISE"));
                }
            }
        }
    }

    public CollectionMap<SQLRow, List<SQLRowValues>> updateStock(List<Integer> ids, boolean archive) {
        CollectionMap<SQLRow, List<SQLRowValues>> map = new CollectionMap<SQLRow, List<SQLRowValues>>();
        SQLTable tableCmdElt = Configuration.getInstance().getBase().getTable("COMMANDE_ELEMENT");
        for (Integer id : ids) {
            boolean gestionStockMin;
            DefaultProps props;
            String stockMin;
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLRow rowMvtStock = eltMvtStock.getTable().getRow(id);
            SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
            SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
            SQLElement eltStock = Configuration.getInstance().getDirectory().getElement("STOCK");
            SQLRow rowArticle = rowMvtStock.getForeignRow("ID_ARTICLE");
            SQLRow rowStock = rowArticle.getForeignRow("ID_STOCK");
            float qte = rowStock.getFloat("QTE_REEL");
            float qteMvt = rowMvtStock.getFloat("QTE");
            SQLRowValues rowVals = new SQLRowValues(eltStock.getTable());
            float qteNvlle = archive ? qte - qteMvt : qte + qteMvt;
            rowVals.put("QTE_REEL", Float.valueOf(qteNvlle));
            try {
                if (rowStock.getID() <= 1) {
                    SQLRow row = rowVals.insert();
                    SQLRowValues rowValsArt = new SQLRowValues(eltArticle.getTable());
                    rowValsArt.put("ID_STOCK", row.getID());
                    int idArticle = rowArticle.getID();
                    if (idArticle > 1) {
                        rowValsArt.update(idArticle);
                    }
                } else {
                    rowVals.update(rowStock.getID());
                }
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour du stock pour l'article " + rowArticle.getString("CODE"));
                e.printStackTrace();
            }
            Boolean bStockMin = !(stockMin = (props = DefaultNXProps.getInstance()).getStringProperty("ArticleStockMin")).equalsIgnoreCase("false");
            boolean bl = gestionStockMin = bStockMin == null || bStockMin != false;
            if (archive || !rowArticle.getTable().getFieldsName().contains("QTE_MIN") || !gestionStockMin || !(qteNvlle < (float)rowArticle.getInt("QTE_MIN"))) continue;
            SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
            SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticle));
            rowValsElt.put("ID_STYLE", 2);
            rowValsElt.put("QTE", Math.round((float)rowArticle.getInt("QTE_MIN") - qteNvlle));
            rowValsElt.put("ID_TAXE", rowValsElt.getObject("ID_TAXE"));
            rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_HT", rowValsElt.getLong("PA_HT") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_TTC", (double)rowValsElt.getLong("T_PA_HT") * ((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0));
            map.put((Object)rowArticle.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
        }
        return map;
    }

    public static void createCommandeF(final CollectionMap<SQLRow, List<SQLRowValues>> col, final SQLRow rowDevise) {
        if (col.keySet().size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SQLElement commande = Configuration.getInstance().getDirectory().getElement("COMMANDE");
                    for (SQLRow fournisseur : col.keySet()) {
                        CommandeSQLComponent cmp;
                        EditFrame frame;
                        SQLSelect sel = new SQLSelect(commande.getTable().getBase());
                        sel.addSelectStar(commande.getTable());
                        Where w = new Where((FieldRef)commande.getTable().getField("EN_COURS"), "=", (Object)Boolean.TRUE);
                        w = w.and(new Where((FieldRef)commande.getTable().getField("ID_FOURNISSEUR"), "=", fournisseur.getID()));
                        sel.setWhere(w);
                        List rowsCmd = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
                        SQLRow commandeExistante = null;
                        if (rowsCmd != null && rowsCmd.size() > 0) {
                            commandeExistante = (SQLRow)rowsCmd.get(0);
                        }
                        if (commandeExistante != null) {
                            frame = new EditFrame(commande, EditPanel.EditMode.MODIFICATION);
                            cmp = (CommandeSQLComponent)frame.getSQLComponent();
                            cmp.select(commandeExistante);
                        } else {
                            frame = new EditFrame(commande);
                            cmp = (CommandeSQLComponent)frame.getSQLComponent();
                            SQLRowValues rowVals = new SQLRowValues(commande.getTable());
                            SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
                            int idUser = UserManager.getInstance().getCurrentUser().getId();
                            SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
                            if (rowsComm != null) {
                                rowVals.put("ID_COMMERCIAL", rowsComm.getID());
                            }
                            rowVals.put("ID_FOURNISSEUR", fournisseur.getID());
                            if (rowDevise != null) {
                                rowVals.put("ID_DEVISE", rowDevise.getID());
                            }
                            cmp.select(rowVals);
                            cmp.getRowValuesTable().getRowValuesTable().getRowValuesTableModel().clearRows();
                        }
                        RowValuesTableModel model = cmp.getRowValuesTable().getRowValuesTable().getRowValuesTableModel();
                        for (SQLRowValues rowValsElt : (List)col.get(fournisseur)) {
                            SQLRowAccessor rowValsMatch = null;
                            int index = 0;
                            int i = 0;
                            while (i < model.getRowCount()) {
                                SQLRowValues rowValsCmdElt = model.getRowValuesAt(i);
                                if (ReferenceArticleSQLElement.isReferenceEquals(rowValsCmdElt, rowValsElt)) {
                                    rowValsMatch = rowValsCmdElt;
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                            if (rowValsMatch != null) {
                                int qte = rowValsMatch.getInt("QTE");
                                model.putValue(qte + rowValsElt.getInt("QTE"), index, "QTE");
                                continue;
                            }
                            model.addRow(rowValsElt);
                        }
                        frame.pack();
                        frame.setVisible(true);
                    }
                }
            });
        }
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".transaction";
    }
}

