/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.ui.ArticleModel;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.CategorieListCellRenderer;
import org.openconcerto.erp.core.sales.pos.ui.CategorieModel;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;

public class CategorieSelector
extends JPanel
implements ListSelectionListener,
CaisseListener {
    private CategorieModel model;
    private JList list;
    private StatusBar comp;
    private Categorie previous;
    private ArticleModel articleModel;
    private CaisseControler controller;

    CategorieSelector(CaisseControler controller, final ArticleModel articleModel) {
        this.articleModel = articleModel;
        this.controller = controller;
        controller.addCaisseListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 1;
        this.comp = new StatusBar();
        this.comp.setTitle("Cat\u00e9gories");
        this.add((Component)this.comp, c);
        c.weighty = 1.0;
        ++c.gridy;
        this.model = new CategorieModel();
        this.model.setRoot(null);
        this.list = new JList(this.model);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new CategorieListCellRenderer());
        this.list.setFixedCellHeight(64);
        this.add((Component)this.list, c);
        this.list.getSelectionModel().addListSelectionListener(this);
        this.comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Categorie prev = CategorieSelector.this.previous;
                CategorieSelector.this.model.setRoot(prev);
                CategorieSelector.this.list.clearSelection();
                if (prev == null) {
                    CategorieSelector.this.comp.setTitle("Cat\u00e9gories");
                    CategorieSelector.this.comp.setPrevious(false);
                    articleModel.setCategorie(null);
                } else {
                    CategorieSelector.this.comp.setTitle(prev.getName());
                    CategorieSelector.this.comp.setPrevious(true);
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object sel = this.list.getSelectedValue();
        if (sel != null && !e.getValueIsAdjusting()) {
            Categorie c = (Categorie)sel;
            if (!c.getSubCategories().isEmpty()) {
                this.previous = this.model.getRoot();
                this.model.setRoot(c);
                this.comp.setTitle(c.getName());
                this.comp.setPrevious(true);
                this.list.clearSelection();
            }
            this.articleModel.setCategorie(c);
            this.controller.setArticleSelected(null);
        }
    }

    @Override
    public void caisseStateChanged() {
        Article articleSelected = this.controller.getArticleSelected();
        if (articleSelected != null) {
            Categorie c = articleSelected.getCategorie();
            if (c.getParent() != null) {
                this.previous = c.getParent().getParent();
                this.model.setRoot(c.getParent());
                this.comp.setTitle(c.getParent().getName());
            }
            this.comp.setPrevious(true);
            this.list.setSelectedValue(c, true);
        }
    }
}

