/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialPrinter;
import org.openconcerto.erp.core.sales.pos.io.JPOSTicketPrinter;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationEcritures.GenerationMvtTicketCaisse;
import org.openconcerto.erp.generationEcritures.GenerationMvtVirement;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Pair;

public class Caisse {
    private static Document document;
    private static SQLRow rowClient;

    static {
        rowClient = null;
    }

    public static File getConfigFile(String appName, File wd) {
        File confFile;
        File wdFile = new File(wd + "/Configuration", "pos.xml");
        if (wdFile.isFile()) {
            confFile = wdFile;
        } else {
            File preferencesFolder = DesktopEnvironment.getDE().getPreferencesFolder(appName);
            if (!preferencesFolder.exists()) {
                preferencesFolder.mkdir();
            }
            confFile = new File(preferencesFolder, "pos.xml");
        }
        return confFile;
    }

    private static Document getDocument() {
        if (document != null) {
            return document;
        }
        SAXBuilder constructeur = new SAXBuilder();
        File file = Caisse.getConfigFile();
        document = new Document();
        if (!file.exists()) {
            System.err.println("Erreur le fichier " + file.getAbsolutePath() + " n'existe pas!");
            document.setRootElement(new Element("config"));
            return document;
        }
        try {
            System.out.println("Loading:" + file.getAbsolutePath());
            document = constructeur.build(file);
        }
        catch (Exception e) {
            document.setRootElement(new Element("config"));
        }
        return document;
    }

    public static File getConfigFile() {
        return Caisse.getConfigFile(ComptaPropsConfiguration.APP_NAME, new File("."));
    }

    public static void createConnexion() {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
        conf.setupLogging("logs");
        Configuration.setInstance(conf);
        try {
            conf.getBase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Document d = Caisse.getDocument();
            ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
            comptaPropsConfiguration.setUpSocieteDataBaseConnexion(Caisse.getSocieteID());
            UserManager.getInstance().setCurrentUser(Caisse.getUserID());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Impossible de configurer la connexion \u00e0 la base de donn\u00e9e.\n ID soci\u00e9t\u00e9: " + Caisse.getSocieteID() + " \n ID utilisateur: " + Caisse.getUserID());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static void commitAll(final List<Ticket> tickets) {
        try {
            SQLUtils.executeAtomic(Configuration.getInstance().getSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    SQLElement elt = Configuration.getInstance().getDirectory().getElement("TICKET_CAISSE");
                    SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
                    SQLElement eltEnc = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
                    SQLElement eltMode = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    for (Ticket ticket : tickets) {
                        Integer idMvt;
                        SQLRowValues rowValsElt;
                        SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
                        sel.addSelect(elt.getTable().getField("NUMERO"));
                        sel.setWhere(new Where((FieldRef)elt.getTable().getField("NUMERO"), "=", (Object)ticket.getCode()));
                        List l = Configuration.getInstance().getBase().getDataSource().executeCol(sel.asString());
                        if (l == null || l.size() != 0) continue;
                        SQLRowValues rowVals = new SQLRowValues(elt.getTable());
                        rowVals.put("NUMERO", ticket.getCode());
                        rowVals.put("DATE", ticket.getCreationDate());
                        rowVals.put("ID_CAISSE", Caisse.getID());
                        long total = 0L;
                        long totalHT = 0L;
                        for (Pair<Article, Integer> item : ticket.getArticles()) {
                            rowValsElt = new SQLRowValues(eltFact.getTable());
                            Article article = item.getFirst();
                            Integer nb = item.getSecond();
                            rowValsElt.put("QTE", nb);
                            rowValsElt.put("PV_HT", (Object)article.getPriceHTInCents());
                            long value = Long.valueOf(article.getPriceInCents()) * (long)nb.intValue();
                            long valueHT = Long.valueOf(article.getPriceHTInCents()) * (long)nb.intValue();
                            total += value;
                            totalHT += valueHT;
                            rowValsElt.put("T_PV_HT", valueHT);
                            rowValsElt.put("T_PV_TTC", value);
                            rowValsElt.put("ID_TAXE", article.getIdTaxe());
                            rowValsElt.put("CODE", article.getCode());
                            rowValsElt.put("NOM", article.getName());
                            rowValsElt.put("ID_TICKET_CAISSE", rowVals);
                            rowValsElt.put("ID_ARTICLE", article.getId());
                        }
                        rowVals.put("TOTAL_HT", totalHT);
                        rowVals.put("TOTAL_TTC", total);
                        rowVals.put("TOTAL_TVA", total - totalHT);
                        for (Paiement paiement : ticket.getPaiements()) {
                            if (paiement.getMontantInCents() <= 0) continue;
                            rowValsElt = new SQLRowValues(eltEnc.getTable());
                            SQLRowValues rowValsEltMode = new SQLRowValues(eltMode.getTable());
                            if (paiement.getType() == 3) {
                                rowValsEltMode.put("ID_TYPE_REGLEMENT", 3);
                            } else if (paiement.getType() == 2) {
                                rowValsEltMode.put("ID_TYPE_REGLEMENT", 2);
                            } else if (paiement.getType() == 1) {
                                rowValsEltMode.put("ID_TYPE_REGLEMENT", 4);
                            }
                            rowValsElt.put("ID_MODE_REGLEMENT", rowValsEltMode);
                            try {
                                rowValsElt.put("ID_CLIENT", Caisse.getClientCaisse().getID());
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            long montant = paiement.getMontantInCents();
                            if (ticket.getPaiements().size() == 1 && paiement.getType() == 1) {
                                montant = total;
                            }
                            rowValsElt.put("MONTANT", montant);
                            rowValsElt.put("NOM", "Ticket " + ticket.getCode());
                            rowValsElt.put("DATE", ticket.getCreationDate());
                            rowValsElt.put("ID_TICKET_CAISSE", rowVals);
                        }
                        SQLRow rowFinal = rowVals.insert();
                        GenerationMvtTicketCaisse mvt = new GenerationMvtTicketCaisse(rowFinal);
                        try {
                            idMvt = mvt.genereMouvement().call();
                        }
                        catch (Exception exn) {
                            exn.printStackTrace();
                            throw new SQLException(exn);
                        }
                        SQLRowValues valTicket = rowFinal.asRowValues();
                        valTicket.put("ID_MOUVEMENT", idMvt);
                        rowFinal = valTicket.update();
                        Collection rowsEnc = rowFinal.getReferentRows(eltEnc.getTable());
                        long totalEnc = 0L;
                        for (SQLRow sqlRow : rowsEnc) {
                            long montant = sqlRow.getLong("MONTANT");
                            PrixTTC ttc = new PrixTTC(montant);
                            totalEnc += montant;
                            new GenerationReglementVenteNG("R\u00e8glement " + sqlRow.getForeignRow("ID_MODE_REGLEMENT").getForeignRow("ID_TYPE_REGLEMENT").getString("NOM") + " Ticket " + rowFinal.getString("NUMERO"), Caisse.getClientCaisse(), ttc, sqlRow.getDate("DATE").getTime(), sqlRow.getForeignRow("ID_MODE_REGLEMENT"), rowFinal, rowFinal.getForeignRow("ID_MOUVEMENT"), false);
                        }
                        if (totalEnc > total) {
                            SQLTable table = Configuration.getInstance().getDirectory().getElement("TYPE_REGLEMENT").getTable();
                            int idComptePceCaisse = table.getRow(4).getInt("ID_COMPTE_PCE_CLIENT");
                            if (idComptePceCaisse == table.getUndefinedID()) {
                                idComptePceCaisse = ComptePCESQLElement.getId(ComptePCESQLElement.getComptePceDefault("VenteEspece"));
                            }
                            new GenerationMvtVirement(idComptePceCaisse, Caisse.getClientCaisse().getInt("ID_COMPTE_PCE"), 0L, totalEnc - total, "Rendu sur r\u00e8glement  Ticket " + rowFinal.getString("NUMERO"), new Date(), 5, " Ticket " + rowFinal.getString("NUMERO")).genereMouvement();
                        }
                        Caisse.updateStock(rowFinal.getID());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Cl\u00f4ture de la caisse termin\u00e9e.");
                        }
                    });
                    return null;
                }
            });
        }
        catch (Exception exn) {
            ExceptionHandler.handle("Une erreur est survenue pendant la cl\u00f4ture.", exn);
        }
    }

    private static SQLRow getClientCaisse() throws SQLException {
        if (rowClient == null) {
            SQLElement elt = Configuration.getInstance().getDirectory().getElement("CLIENT");
            SQLSelect sel = new SQLSelect(elt.getTable().getBase());
            sel.addSelectStar(elt.getTable());
            sel.setWhere(new Where((FieldRef)elt.getTable().getField("NOM"), "=", (Object)"Caisse OpenConcerto"));
            List l = (List)elt.getTable().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
            if (l.size() > 0) {
                rowClient = (SQLRow)l.get(0);
            } else {
                SQLRowValues rowValues = new SQLRowValues(elt.getTable());
                rowValues.put("NOM", "Caisse OpenConcerto");
                SQLRowValues rowValuesMode = new SQLRowValues(elt.getTable().getTable("MODE_REGLEMENT"));
                rowValuesMode.put("ID_TYPE_REGLEMENT", 3);
                rowValues.put("ID_MODE_REGLEMENT", rowValuesMode);
                SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
                SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
                int idDefaultCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT");
                if (idDefaultCompteClient <= 1) {
                    try {
                        idDefaultCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                rowValues.put("ID_COMPTE_PCE", idDefaultCompteClient);
                rowClient = rowValues.insert();
            }
        }
        return rowClient;
    }

    private static void updateStock(int id) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("TICKET_CAISSE");
        SQLElement eltArticleFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        MouvementStockSQLElement mvtStock = (MouvementStockSQLElement)Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
        mvtStock.createMouvement(elt.getTable().getRow(id), eltArticleFact.getTable(), new StockLabel(){

            @Override
            public String getLabel(SQLRow rowOrigin, SQLRow rowElt) {
                return "Ticket N\u00b0" + rowOrigin.getString("NUMERO");
            }
        }, false);
    }

    public static int getID() {
        Document d = Caisse.getDocument();
        return Integer.valueOf(d.getRootElement().getAttributeValue("caisseID", "-1"));
    }

    public static List<Ticket> allTickets() {
        ArrayList<Ticket> l = new ArrayList<Ticket>();
        Ticket t = new Ticket(Caisse.getID());
        String[] names = t.getCompatibleFileNames();
        int i = 0;
        while (i < names.length) {
            String code = names[i].substring(0, 17);
            Ticket ticket = Ticket.getTicketFromCode(code);
            l.add(ticket);
            ++i;
        }
        return l;
    }

    public static int getUserID() {
        Document d = Caisse.getDocument();
        return Integer.valueOf(d.getRootElement().getAttributeValue("userID", "-1"));
    }

    public static int getSocieteID() {
        Document d = Caisse.getDocument();
        return Integer.valueOf(d.getRootElement().getAttributeValue("societeID", "-1"));
    }

    public static TicketPrinter getTicketPrinter() {
        if (Caisse.isUsingJPos()) {
            JPOSTicketPrinter prt = new JPOSTicketPrinter(Caisse.getJPosPrinter());
            return prt;
        }
        return new ESCSerialPrinter(Caisse.getESCPPort());
    }

    public static boolean isUsingJPos() {
        Document d = Caisse.getDocument();
        Element child = d.getRootElement().getChild("printer");
        if (child == null) {
            child = new Element("printer");
            d.getRootElement().addContent(child);
            return false;
        }
        String type = child.getAttributeValue("type");
        return type != null && type.equalsIgnoreCase("jpos");
    }

    public static String getJPosPrinter() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("jpos");
        if (children != null) {
            for (Element e : children) {
                if (e.getAttribute("printer") == null) continue;
                return e.getAttributeValue("printer");
            }
        }
        return "";
    }

    public static String getESCPPort() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("escp");
        if (children != null) {
            for (Element e : children) {
                if (e.getAttribute("port") == null) continue;
                return e.getAttributeValue("port", "COM1:");
            }
        }
        return "COM1:";
    }

    public static String getJPosDirectory() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("jpos");
        if (children != null) {
            for (Element e : children) {
                if (e.getValue() == null) continue;
                return e.getValue();
            }
        }
        return "";
    }

    public static List<TicketLine> getHeaders() {
        ArrayList<TicketLine> l = new ArrayList<TicketLine>();
        Document d = Caisse.getDocument();
        List list = d.getRootElement().getChildren("header");
        if (list != null) {
            for (Element element : list) {
                l.add(new TicketLine(element.getValue(), element.getAttributeValue("style")));
            }
        }
        return l;
    }

    public static List<TicketLine> getFooters() {
        ArrayList<TicketLine> l = new ArrayList<TicketLine>();
        Document d = Caisse.getDocument();
        List list = d.getRootElement().getChildren("footer");
        if (list != null) {
            for (Element element : list) {
                l.add(new TicketLine(element.getValue(), element.getAttributeValue("style")));
            }
        }
        return l;
    }

    public static int getTicketWidth() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("printer");
        if (children != null) {
            for (Element e : children) {
                if (e.getAttribute("printWidth") == null) continue;
                String attributeValue = e.getAttributeValue("printWidth");
                return Integer.parseInt(attributeValue);
            }
        }
        return 20;
    }
}

