/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.GestionDevise;

public class TotalPanel
extends JPanel
implements TableModelListener {
    public static String MARGE_MARQUE = "MargeMarque";
    private RowValuesTable table;
    private int columnIndexHT;
    private int columnIndexTVA;
    private int columnIndexService;
    private int columnIndexHA;
    private int columnIndexQte;
    private int columnIndexDevise;
    private int columnIndexPoids;
    private DeviseField textTotalHT;
    private DeviseField textTotalHTSel;
    private DeviseField textTotalTVA;
    private DeviseField textTotalTVASel;
    private DeviseField textTotalTTC;
    private DeviseField textTotalTTCSel;
    private DeviseField textPortHT;
    private DeviseField textRemiseHT;
    private JTextField textPoids;
    private DeviseField textTotalDevise;
    private DeviseField textTotalDeviseSel;
    private DeviseField textService;
    private DeviseField textServiceSel;
    private DeviseField textHA;
    private DeviseField textHASel;
    private JTextField marge;
    private JTextField margeSel;
    private boolean gestionHA = false;
    private PropertyChangeSupport supp;
    private int columnIndexEchHT = -1;
    private int columnIndexEchTTC = -1;
    SQLTableElement ha;

    public TotalPanel(AbstractArticleItemTable articleItemTable, DeviseField textTotalHT, DeviseField textTotalTVA, DeviseField textTotalTTC, DeviseField textPortHT, DeviseField textRemiseHT, DeviseField textService, DeviseField textTotalHA, DeviseField textTotalDevise, JTextField textTotalPoids, JPanel tableEchantillon) {
        this.ha = articleItemTable.getPrebilanElement() == null ? articleItemTable.getHaElement() : articleItemTable.getPrebilanElement();
        this.supp = new PropertyChangeSupport(this);
        this.table = articleItemTable.getRowValuesTable();
        this.columnIndexHT = this.table.getRowValuesTableModel().getColumnIndexForElement(articleItemTable.getPrixTotalHTElement());
        this.columnIndexTVA = this.table.getRowValuesTableModel().getColumnIndexForElement(articleItemTable.getTVAElement());
        this.columnIndexDevise = articleItemTable.getTableElementTotalDevise() == null ? -1 : this.table.getRowValuesTableModel().getColumnIndexForElement(articleItemTable.getTableElementTotalDevise());
        this.columnIndexService = this.table.getRowValuesTableModel().getColumnIndexForElement(articleItemTable.getPrixServiceElement());
        this.columnIndexPoids = this.table.getRowValuesTableModel().getColumnIndexForElement(articleItemTable.getPoidsTotalElement());
        boolean bl = this.gestionHA = this.ha != null && articleItemTable.getQteElement() != null;
        if (this.gestionHA) {
            this.columnIndexHA = this.table.getRowValuesTableModel().getColumnIndexForElement(this.ha);
            this.columnIndexQte = this.table.getRowValuesTableModel().getColumnIndexForElement(articleItemTable.getQteElement());
        }
        this.textPoids = textTotalPoids == null ? new JTextField() : textTotalPoids;
        this.textTotalHT = textTotalHT;
        this.textTotalHT.setBold();
        this.textTotalTVA = textTotalTVA;
        this.textTotalTTC = textTotalTTC;
        this.textPortHT = textPortHT;
        this.textRemiseHT = textRemiseHT;
        this.textService = textService;
        this.textHA = textTotalHA == null ? new DeviseField() : textTotalHA;
        this.textHASel = new DeviseField();
        this.textTotalHTSel = new DeviseField(true);
        this.textServiceSel = new DeviseField();
        this.textTotalTTCSel = new DeviseField();
        this.textTotalTVASel = new DeviseField();
        this.marge = new JTextField();
        this.margeSel = new JTextField();
        if (articleItemTable.getTableElementTotalDevise() != null) {
            this.textTotalDevise = textTotalDevise;
            this.textTotalDeviseSel = new DeviseField();
            this.reconfigure(this.textTotalDevise);
            this.reconfigure(this.textTotalDeviseSel);
        }
        this.reconfigure(this.textTotalHT);
        this.reconfigure(this.textTotalTVA);
        this.reconfigure(this.textTotalTTC);
        this.reconfigure(this.textService);
        this.reconfigure(this.textHA);
        this.reconfigure(this.marge);
        this.reconfigure(this.textTotalHTSel);
        this.reconfigure(this.textTotalTVASel);
        this.reconfigure(this.textTotalTTCSel);
        this.reconfigure(this.textServiceSel);
        this.reconfigure(this.textHASel);
        this.reconfigure(this.margeSel);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (this.columnIndexHT < 0 || this.columnIndexTVA < 0 || b != null && b.booleanValue() && this.columnIndexService < 0) {
            throw new IllegalArgumentException("Impossible de trouver la colonne de " + articleItemTable.getPrixTotalHTElement() + " / " + articleItemTable.getTVAElement() + " / " + articleItemTable.getPrixServiceElement());
        }
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.0;
        c.fill = 2;
        ++c.gridx;
        this.add((Component)new JLabelBold("S\u00e9lection"), c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        if (this.gestionHA) {
            ++c.gridy;
            this.add((Component)new JLabel("Total achat HT"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textHASel, c);
            ++c.gridy;
            c.gridx = 1;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Marge"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.margeSel, c);
            ++c.gridy;
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 1;
            this.add((Component)this.createSeparator(), c);
            c.gridwidth = 1;
            c.weightx = 0.0;
        }
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalHT.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalHTSel, c);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleService", false)) {
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Service HT inclus "), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textServiceSel, c);
        }
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelFor(textTotalTVA.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalTVASel, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        if (articleItemTable.getTableElementTotalDevise() != null) {
            c.gridwidth = 1;
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)TotalPanel.getLabelFor(textTotalDevise.getField()), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textTotalDeviseSel, c);
        }
        c.gridwidth = 1;
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelFor(textTotalTTC.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalTTCSel, c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 0;
        c.weighty = 1.0;
        c.fill = 3;
        c.weightx = 0.0;
        this.add((Component)this.createSeparator(), c);
        c.gridheight = 1;
        c.fill = 2;
        c.weighty = 0.0;
        ++c.gridx;
        this.add((Component)new JLabelBold("Global"), c);
        ++c.gridy;
        c.gridx = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.add((Component)this.createSeparator(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        if (this.gestionHA) {
            ++c.gridy;
            this.add((Component)new JLabel("Total achat HT"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textHA, c);
            ++c.gridy;
            c.gridx = 4;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Marge"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.marge, c);
            ++c.gridy;
            c.gridx = 4;
            c.gridwidth = 2;
            c.weightx = 1.0;
            this.add((Component)this.createSeparator(), c);
            c.gridwidth = 1;
            c.weightx = 0.0;
        }
        ++c.gridy;
        c.gridx = 4;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalHT.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textTotalHT, c);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleService", false)) {
            c.gridx = 4;
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabelBold("Service HT inclus "), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textService, c);
        }
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalTVA.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textTotalTVA, c);
        c.gridwidth = 2;
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        if (articleItemTable.getTableElementTotalDevise() != null) {
            c.gridwidth = 1;
            c.gridx = 4;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)TotalPanel.getLabelBoldFor(textTotalDevise.getField()), c);
            ++c.gridx;
            c.weightx = 1.0;
            textTotalDevise.setFont(textTotalHT.getFont());
            this.add((Component)textTotalDevise, c);
        }
        c.gridwidth = 1;
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalTTC.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        textTotalTTC.setFont(textTotalHT.getFont());
        this.add((Component)textTotalTTC, c);
        this.updateTotal();
        this.table.getRowValuesTableModel().addTableModelListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TotalPanel.this.updateTotal();
            }
        });
    }

    private void reconfigure(JTextField field) {
        field.setEditable(false);
        field.setHorizontalAlignment(4);
        field.setBorder(null);
        field.setColumns(11);
        field.setOpaque(true);
        field.setMinimumSize(new Dimension(150, 20));
        field.setPreferredSize(new Dimension(150, 20));
        field.setBackground(UIManager.getColor("control"));
        field.setEditable(false);
        field.setEnabled(false);
        field.setDisabledTextColor(Color.BLACK);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == -1 || e.getColumn() == this.columnIndexHT || e.getColumn() == this.columnIndexTVA || e.getColumn() == this.columnIndexEchHT || e.getColumn() == this.columnIndexEchTTC || e.getColumn() == this.columnIndexDevise) {
            this.updateTotal();
        }
    }

    public void updateTotal() {
        try {
            long totalHT = 0L;
            long totalHA = 0L;
            long totalService = 0L;
            long totalHTSel = 0L;
            long totalHASel = 0L;
            long totalServiceSel = 0L;
            long totalDeviseSel = 0L;
            long totalDevise = 0L;
            double totalPoids = 0.0;
            int[] selectedRows = this.table.getSelectedRows();
            HashMap<SQLRowAccessor, Long> mapHtTVA = new HashMap<SQLRowAccessor, Long>();
            HashMap<SQLRowAccessor, Long> mapHtTVASel = new HashMap<SQLRowAccessor, Long>();
            int i = 0;
            while (i < this.table.getRowValuesTableModel().getRowCount()) {
                Boolean b;
                String val;
                Boolean bServiceActive;
                Number nHT = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexHT);
                totalHT += nHT.longValue();
                if (this.gestionHA) {
                    Number nHA = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexHA);
                    Number nQte = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexQte);
                    totalHA = this.ha != null && this.ha.getField().getName().equalsIgnoreCase("PREBILAN") ? (totalHA += nHA.longValue()) : (totalHA += nHA.longValue() * (long)nQte.intValue());
                }
                if ((bServiceActive = Boolean.valueOf(val = DefaultNXProps.getInstance().getStringProperty("ArticleService"))) != null && bServiceActive.booleanValue() && (b = (Boolean)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexService)) != null && b.booleanValue()) {
                    totalService += nHT.longValue();
                }
                Number nDevise = null;
                if (this.textTotalDevise != null) {
                    nDevise = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexDevise);
                    totalDevise += nDevise.longValue();
                }
                if (mapHtTVA.get(this.table.getRowValuesTableModel().getRowValuesAt(i).getForeign("ID_TAXE")) == null) {
                    mapHtTVA.put(this.table.getRowValuesTableModel().getRowValuesAt(i).getForeign("ID_TAXE"), nHT.longValue());
                } else {
                    Long l = (Long)mapHtTVA.get(this.table.getRowValuesTableModel().getRowValuesAt(i).getForeign("ID_TAXE"));
                    mapHtTVA.put(this.table.getRowValuesTableModel().getRowValuesAt(i).getForeign("ID_TAXE"), l + nHT.longValue());
                }
                Number nPoids = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexPoids);
                totalPoids += nPoids == null ? 0.0 : nPoids.doubleValue();
                if (TotalPanel.containsInt(selectedRows, i)) {
                    Boolean b2;
                    totalHTSel += nHT.longValue();
                    if (this.gestionHA) {
                        Number nHA = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexHA);
                        Number nQte = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexQte);
                        totalHASel = this.ha != null && this.ha.getField().getName().equalsIgnoreCase("PREBILAN") ? (totalHASel += nHA.longValue()) : (totalHASel += nHA.longValue() * (long)nQte.intValue());
                    }
                    if (bServiceActive != null && bServiceActive.booleanValue() && (b2 = (Boolean)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexService)).booleanValue()) {
                        totalServiceSel += nHT.longValue();
                    }
                    if (mapHtTVASel.get(this.table.getRowValuesTableModel().getRowValuesAt(i).getForeign("ID_TAXE")) == null) {
                        mapHtTVASel.put(this.table.getRowValuesTableModel().getRowValuesAt(i).getForeign("ID_TAXE"), nHT.longValue());
                    } else {
                        Long l = (Long)mapHtTVASel.get(this.table.getRowValuesTableModel().getRowValuesAt(i).getForeign("ID_TAXE"));
                        mapHtTVASel.put(this.table.getRowValuesTableModel().getRowValuesAt(i).getForeign("ID_TAXE"), l + nHT.longValue());
                    }
                    if (this.textTotalDevise != null) {
                        totalDeviseSel += nDevise.longValue();
                    }
                }
                ++i;
            }
            long valPortHT = this.textPortHT.getText().trim().length() > 0 ? (!this.textPortHT.getText().trim().equals("-") ? GestionDevise.parseLongCurrency(this.textPortHT.getText().trim()) : 0L) : 0L;
            long valRemiseHT = this.textRemiseHT.getText().trim().length() > 0 ? (!this.textRemiseHT.getText().trim().equals("-") ? GestionDevise.parseLongCurrency(this.textRemiseHT.getText().trim()) : 0L) : 0L;
            long realTotalHT = totalHT + valPortHT - valRemiseHT;
            long portTTC = new PrixHT(valPortHT).calculLongTTC(0.196f);
            long remiseTTC = new PrixHT(valRemiseHT).calculLongTTC(0.196f);
            long realTotalTVA = 0L;
            for (SQLRowAccessor row : mapHtTVA.keySet()) {
                BigDecimal d = new BigDecimal(TaxeCache.getCache().getTauxFromId(row.getID()).floatValue());
                BigDecimal result = d.multiply(new BigDecimal((Long)mapHtTVA.get(row)), MathContext.DECIMAL128).movePointLeft(2);
                realTotalTVA += result.setScale(0, 4).longValue();
            }
            long realTotalTTC = totalHT + realTotalTVA + portTTC - remiseTTC;
            if (this.textTotalDevise != null) {
                this.textTotalDevise.setText(GestionDevise.currencyToString(totalDevise));
                this.textTotalDeviseSel.setText(GestionDevise.currencyToString(totalDeviseSel));
            }
            this.textPoids.setText(String.valueOf(totalPoids));
            this.textTotalHT.setText(GestionDevise.currencyToString(realTotalHT));
            this.textService.setText(GestionDevise.currencyToString(totalService));
            this.textTotalTVA.setText(GestionDevise.currencyToString(realTotalTVA));
            this.textTotalTTC.setText(GestionDevise.currencyToString(realTotalTTC));
            this.textTotalHTSel.setText(GestionDevise.currencyToString(totalHTSel));
            this.textServiceSel.setText(GestionDevise.currencyToString(totalServiceSel));
            long realTotalTVASel = 0L;
            for (SQLRowAccessor row : mapHtTVASel.keySet()) {
                BigDecimal d = new BigDecimal(TaxeCache.getCache().getTauxFromId(row.getID()).floatValue());
                BigDecimal result = d.multiply(new BigDecimal((Long)mapHtTVASel.get(row)), MathContext.DECIMAL128).movePointLeft(2);
                realTotalTVASel += result.setScale(0, 4).longValue();
            }
            this.textTotalTVASel.setText(GestionDevise.currencyToString(realTotalTVASel));
            this.textTotalTTCSel.setText(GestionDevise.currencyToString(realTotalTVASel + totalHTSel));
            if (this.gestionHA) {
                this.textHA.setText(GestionDevise.currencyToString(totalHA));
                double m = 0.0;
                long d = 0L;
                if (totalHA > 0L) {
                    d = totalHT - valRemiseHT - totalHA;
                    m = DefaultNXProps.getInstance().getBooleanValue(MARGE_MARQUE, false) ? (double)Math.round((double)d / (double)totalHT * 10000.0) / 100.0 : (double)Math.round((double)d / (double)totalHA * 10000.0) / 100.0;
                }
                if (d <= 0L) {
                    this.marge.setForeground(Color.red);
                    this.marge.setDisabledTextColor(Color.RED);
                } else {
                    this.marge.setForeground(this.textTotalTTC.getForeground());
                    this.marge.setDisabledTextColor(this.textTotalTTC.getForeground());
                }
                this.marge.setText("(" + m + "%) " + GestionDevise.currencyToString(d));
                this.textHASel.setText(GestionDevise.currencyToString(totalHASel));
                double m2 = 0.0;
                long e = 0L;
                if (totalHASel > 0L) {
                    e = totalHTSel - totalHASel;
                    m2 = DefaultNXProps.getInstance().getBooleanValue(MARGE_MARQUE, false) ? (double)Math.round((double)e / (double)totalHTSel * 10000.0) / 100.0 : (double)Math.round((double)e / (double)totalHASel * 10000.0) / 100.0;
                }
                this.margeSel.setText("(" + m2 + "%) " + GestionDevise.currencyToString(e));
                if (e <= 0L) {
                    this.margeSel.setForeground(Color.red);
                    this.margeSel.setDisabledTextColor(Color.RED);
                } else {
                    this.margeSel.setForeground(this.textTotalTTC.getForeground());
                    this.margeSel.setDisabledTextColor(this.textTotalTTC.getForeground());
                }
            }
            this.supp.firePropertyChange("value", null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean containsInt(int[] tab, int i) {
        if (tab == null) {
            return false;
        }
        int j = 0;
        while (j < tab.length) {
            if (tab[j] == i) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private static final JLabel getLabelFor(SQLField field) {
        return new JLabel(Configuration.getInstance().getTranslator().getLabelFor(field));
    }

    private static final JLabel getLabelBoldFor(SQLField field) {
        return new JLabelBold(Configuration.getInstance().getTranslator().getLabelFor(field));
    }

    private final JSeparator createSeparator() {
        JSeparator sep = new JSeparator(0);
        DefaultGridBagConstraints.lockMinimumSize(sep);
        return sep;
    }
}

