/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.util;

import java.util.ArrayList;
import java.util.Stack;
import org.jgrapht.util.FibonacciHeapNode;

public class FibonacciHeap<T> {
    private FibonacciHeapNode<T> minNode;
    private int nNodes;

    public void clear() {
        this.minNode = null;
        this.nNodes = 0;
    }

    public void decreaseKey(FibonacciHeapNode<T> x, double k) {
        if (k > x.key) {
            throw new IllegalArgumentException("decreaseKey() got larger key value");
        }
        x.key = k;
        FibonacciHeapNode y = x.parent;
        if (y != null && x.key < y.key) {
            this.cut(x, y);
            this.cascadingCut(y);
        }
        if (x.key < this.minNode.key) {
            this.minNode = x;
        }
    }

    public void insert(FibonacciHeapNode<T> node, double key) {
        node.key = key;
        if (this.minNode != null) {
            node.left = this.minNode;
            node.right = this.minNode.right;
            this.minNode.right = node;
            node.right.left = node;
            if (key < this.minNode.key) {
                this.minNode = node;
            }
        } else {
            this.minNode = node;
        }
        ++this.nNodes;
    }

    public FibonacciHeapNode<T> min() {
        return this.minNode;
    }

    public FibonacciHeapNode<T> removeMin() {
        FibonacciHeapNode<T> z = this.minNode;
        if (z != null) {
            int numKids = z.degree;
            FibonacciHeapNode x = z.child;
            while (numKids > 0) {
                FibonacciHeapNode tempRight = x.right;
                x.left.right = x.right;
                x.right.left = x.left;
                x.left = this.minNode;
                x.right = this.minNode.right;
                this.minNode.right = x;
                x.right.left = x;
                x.parent = null;
                x = tempRight;
                --numKids;
            }
            z.left.right = z.right;
            z.right.left = z.left;
            if (z == z.right) {
                this.minNode = null;
            } else {
                this.minNode = z.right;
                this.consolidate();
            }
            --this.nNodes;
        }
        return z;
    }

    public int size() {
        return this.nNodes;
    }

    public String toString() {
        if (this.minNode == null) {
            return "FibonacciHeap=[]";
        }
        Stack stack = new Stack();
        stack.push(this.minNode);
        StringBuffer buf = new StringBuffer(512);
        buf.append("FibonacciHeap=[");
        while (!stack.empty()) {
            FibonacciHeapNode curr = (FibonacciHeapNode)stack.pop();
            buf.append(curr);
            buf.append(", ");
            if (curr.child != null) {
                stack.push(curr.child);
            }
            FibonacciHeapNode start = curr;
            curr = curr.right;
            while (curr != start) {
                buf.append(curr);
                buf.append(", ");
                if (curr.child != null) {
                    stack.push(curr.child);
                }
                curr = curr.right;
            }
        }
        buf.append(']');
        return buf.toString();
    }

    protected void cascadingCut(FibonacciHeapNode<T> y) {
        FibonacciHeapNode z = y.parent;
        if (z != null) {
            if (!y.mark) {
                y.mark = true;
            } else {
                this.cut(y, z);
                this.cascadingCut(z);
            }
        }
    }

    protected void consolidate() {
        int arraySize = this.nNodes + 1;
        ArrayList<FibonacciHeapNode<T>> array = new ArrayList<FibonacciHeapNode<T>>(arraySize);
        int i = 0;
        while (i < arraySize) {
            array.add(null);
            ++i;
        }
        int numRoots = 0;
        FibonacciHeapNode<T> x = this.minNode;
        if (x != null) {
            ++numRoots;
            x = x.right;
            while (x != this.minNode) {
                ++numRoots;
                x = x.right;
            }
        }
        while (numRoots > 0) {
            int d = x.degree;
            FibonacciHeapNode next = x.right;
            while (array.get(d) != null) {
                FibonacciHeapNode<T> y = (FibonacciHeapNode<T>)array.get(d);
                if (x.key > y.key) {
                    FibonacciHeapNode<T> temp = y;
                    y = x;
                    x = temp;
                }
                this.link(y, x);
                array.set(d, null);
                ++d;
            }
            array.set(d, x);
            x = next;
            --numRoots;
        }
        this.minNode = null;
        int i2 = 0;
        while (i2 < arraySize) {
            if (array.get(i2) != null) {
                if (this.minNode != null) {
                    ((FibonacciHeapNode)array.get((int)i2)).left.right = ((FibonacciHeapNode)array.get((int)i2)).right;
                    ((FibonacciHeapNode)array.get((int)i2)).right.left = ((FibonacciHeapNode)array.get((int)i2)).left;
                    ((FibonacciHeapNode)array.get((int)i2)).left = this.minNode;
                    ((FibonacciHeapNode)array.get((int)i2)).right = this.minNode.right;
                    this.minNode.right = (FibonacciHeapNode)array.get(i2);
                    ((FibonacciHeapNode)array.get((int)i2)).right.left = (FibonacciHeapNode)array.get(i2);
                    if (((FibonacciHeapNode)array.get((int)i2)).key < this.minNode.key) {
                        this.minNode = (FibonacciHeapNode)array.get(i2);
                    }
                } else {
                    this.minNode = (FibonacciHeapNode)array.get(i2);
                }
            }
            ++i2;
        }
    }

    protected void cut(FibonacciHeapNode<T> x, FibonacciHeapNode<T> y) {
        x.left.right = x.right;
        x.right.left = x.left;
        --y.degree;
        if (y.child == x) {
            y.child = x.right;
        }
        if (y.degree == 0) {
            y.child = null;
        }
        x.left = this.minNode;
        x.right = this.minNode.right;
        this.minNode.right = x;
        x.right.left = x;
        x.parent = null;
        x.mark = false;
    }

    protected void link(FibonacciHeapNode<T> y, FibonacciHeapNode<T> x) {
        y.left.right = y.right;
        y.right.left = y.left;
        y.parent = x;
        if (x.child == null) {
            x.child = y;
            y.right = y;
            y.left = y;
        } else {
            y.left = x.child;
            y.right = x.child.right;
            x.child.right = y;
            y.right.left = y;
        }
        ++x.degree;
        y.mark = false;
    }
}

