/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.MAC;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class KnownHosts
implements HostKeyRepository {
    private JSch jsch = null;
    private String known_hosts = null;
    private Vector pool = null;
    private MAC hmacsha1 = null;
    private static final byte[] space = new byte[]{32};
    private static final byte[] cr = Util.str2byte("\n");

    KnownHosts(JSch jSch) {
        this.jsch = jSch;
        this.pool = new Vector();
    }

    public String getKnownHostsRepositoryID() {
        return this.known_hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int check(String string, byte[] byArray) {
        int n = 1;
        if (string == null) {
            return n;
        }
        int n2 = this.getType(byArray);
        Vector vector = this.pool;
        synchronized (vector) {
            int n3 = 0;
            while (n3 < this.pool.size()) {
                HostKey hostKey = (HostKey)this.pool.elementAt(n3);
                if (hostKey.isMatched(string) && hostKey.type == n2) {
                    if (Util.array_equals(hostKey.key, byArray)) {
                        return 0;
                    }
                    n = 2;
                }
                ++n3;
            }
        }
        if (n != 1) return n;
        if (!string.startsWith("[")) return n;
        if (string.indexOf("]:") <= 1) return n;
        return this.check(string.substring(1, string.indexOf("]:")), byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(HostKey hostKey, UserInfo userInfo) {
        int n = hostKey.type;
        String string = hostKey.getHost();
        byte[] byArray = hostKey.key;
        HostKey hostKey2 = null;
        Vector vector = this.pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.pool.size()) {
                hostKey2 = (HostKey)this.pool.elementAt(n2);
                if (!hostKey2.isMatched(string) || hostKey2.type == n) {
                    // empty if block
                }
                ++n2;
            }
        }
        hostKey2 = hostKey;
        this.pool.addElement(hostKey2);
        String string2 = this.getKnownHostsRepositoryID();
        if (string2 != null) {
            boolean bl = true;
            File file = new File(string2);
            if (!file.exists()) {
                bl = false;
                if (userInfo != null) {
                    bl = userInfo.promptYesNo(string2 + " does not exist.\n" + "Are you sure you want to create it?");
                    file = file.getParentFile();
                    if (bl && file != null && !file.exists() && (bl = userInfo.promptYesNo("The parent directory " + file + " does not exist.\n" + "Are you sure you want to create it?"))) {
                        if (!file.mkdirs()) {
                            userInfo.showMessage(file + " has not been created.");
                            bl = false;
                        } else {
                            userInfo.showMessage(file + " has been succesfully created.\nPlease check its access permission.");
                        }
                    }
                    if (file == null) {
                        bl = false;
                    }
                }
            }
            if (bl) {
                try {
                    this.sync(string2);
                }
                catch (Exception exception) {
                    System.err.println("sync known_hosts: " + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string, String string2, byte[] byArray) {
        boolean bl = false;
        Vector vector = this.pool;
        synchronized (vector) {
            int n = 0;
            while (n < this.pool.size()) {
                HostKey hostKey = (HostKey)this.pool.elementAt(n);
                if (string == null || hostKey.isMatched(string) && (string2 == null || hostKey.getType().equals(string2) && (byArray == null || Util.array_equals(byArray, hostKey.key)))) {
                    String string3 = hostKey.getHost();
                    if (string3.equals(string) || hostKey instanceof HashedHostKey && ((HashedHostKey)hostKey).isHashed()) {
                        this.pool.removeElement(hostKey);
                    } else {
                        hostKey.host = this.deleteSubString(string3, string);
                    }
                    bl = true;
                }
                ++n;
            }
        }
        if (bl) {
            try {
                this.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void sync() throws IOException {
        if (this.known_hosts != null) {
            this.sync(this.known_hosts);
        }
    }

    protected synchronized void sync(String string) throws IOException {
        if (string == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.dump(fileOutputStream);
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(OutputStream outputStream) throws IOException {
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                int n = 0;
                while (n < this.pool.size()) {
                    HostKey hostKey = (HostKey)this.pool.elementAt(n);
                    String string = hostKey.getHost();
                    String string2 = hostKey.getType();
                    if (string2.equals("UNKNOWN")) {
                        outputStream.write(Util.str2byte(string));
                        outputStream.write(cr);
                    } else {
                        outputStream.write(Util.str2byte(string));
                        outputStream.write(space);
                        outputStream.write(Util.str2byte(string2));
                        outputStream.write(space);
                        outputStream.write(Util.str2byte(hostKey.getKey()));
                        outputStream.write(cr);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private int getType(byte[] byArray) {
        if (byArray[8] == 100) {
            return 1;
        }
        if (byArray[8] == 114) {
            return 2;
        }
        return 3;
    }

    private String deleteSubString(String string, String string2) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string.length();
        while (n < n3) {
            int n4 = string.indexOf(44, n);
            if (n4 == -1) break;
            if (!string2.equals(string.substring(n, n4))) {
                n = n4 + 1;
                continue;
            }
            return string.substring(0, n) + string.substring(n4 + 1);
        }
        if (string.endsWith(string2) && n3 - n == n2) {
            return string.substring(0, n2 == n3 ? 0 : n3 - n2 - 1);
        }
        return string;
    }

    private synchronized MAC getHMACSHA1() {
        if (this.hmacsha1 == null) {
            try {
                Class<?> clazz = Class.forName(JSch.getConfig("hmac-sha1"));
                this.hmacsha1 = (MAC)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("hmacsha1: " + exception);
            }
        }
        return this.hmacsha1;
    }

    HostKey createHashedHostKey(String string, byte[] byArray) throws JSchException {
        HashedHostKey hashedHostKey = new HashedHostKey(string, byArray);
        hashedHostKey.hash();
        return hashedHostKey;
    }

    class HashedHostKey
    extends HostKey {
        private boolean hashed = false;
        byte[] salt = null;
        byte[] hash = null;

        HashedHostKey(String string, byte[] byArray) throws JSchException {
            this(string, 0, byArray);
        }

        HashedHostKey(String string, int n, byte[] byArray) throws JSchException {
            super(string, n, byArray);
            if (this.host.startsWith("|1|") && this.host.substring("|1|".length()).indexOf("|") > 0) {
                String string2 = this.host.substring("|1|".length());
                String string3 = string2.substring(0, string2.indexOf("|"));
                String string4 = string2.substring(string2.indexOf("|") + 1);
                this.salt = Util.fromBase64(Util.str2byte(string3), 0, string3.length());
                this.hash = Util.fromBase64(Util.str2byte(string4), 0, string4.length());
                if (this.salt.length != 20 || this.hash.length != 20) {
                    this.salt = null;
                    this.hash = null;
                    return;
                }
                this.hashed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isMatched(String string) {
            if (!this.hashed) {
                return super.isMatched(string);
            }
            MAC mAC = KnownHosts.this.getHMACSHA1();
            try {
                MAC mAC2 = mAC;
                synchronized (mAC2) {
                    mAC.init(this.salt);
                    byte[] byArray = Util.str2byte(string);
                    mAC.update(byArray, 0, byArray.length);
                    byte[] byArray2 = new byte[mAC.getBlockSize()];
                    mAC.doFinal(byArray2, 0);
                    boolean bl = Util.array_equals(this.hash, byArray2);
                    return bl;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                return false;
            }
        }

        boolean isHashed() {
            return this.hashed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void hash() {
            Object object;
            Object object2;
            if (this.hashed) {
                return;
            }
            MAC mAC = KnownHosts.this.getHMACSHA1();
            if (this.salt == null) {
                object = object2 = Session.random;
                synchronized (object) {
                    this.salt = new byte[mAC.getBlockSize()];
                    object2.fill(this.salt, 0, this.salt.length);
                }
            }
            try {
                object2 = mAC;
                synchronized (object2) {
                    mAC.init(this.salt);
                    object = Util.str2byte(this.host);
                    mAC.update((byte[])object, 0, ((Object)object).length);
                    this.hash = new byte[mAC.getBlockSize()];
                    mAC.doFinal(this.hash, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.host = "|1|" + Util.byte2str(Util.toBase64(this.salt, 0, this.salt.length)) + "|" + Util.byte2str(Util.toBase64(this.hash, 0, this.hash.length));
            this.hashed = true;
        }
    }
}

