/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.google.docs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.UIManager;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModulePackager;
import org.openconcerto.erp.modules.ModulePreferencePanelDesc;
import org.openconcerto.erp.modules.RuntimeModuleFactory;
import org.openconcerto.erp.storage.StorageEngine;
import org.openconcerto.erp.storage.StorageEngines;
import org.openconcerto.modules.google.docs.GoogleDocsListAction;
import org.openconcerto.modules.google.docs.GoogleDocsPreferencePanel;
import org.openconcerto.modules.google.docs.GoogleDocsStorageEngine;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.ui.preferences.PreferencePanel;
import org.openconcerto.utils.FileUtils;

public final class Module
extends AbstractModule {
    private final GoogleDocsStorageEngine engine = new GoogleDocsStorageEngine();

    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void install(DBContext ctxt) {
        super.install(ctxt);
    }

    protected void setupElements(SQLElementDirectory dir) {
        super.setupElements(dir);
    }

    protected void setupComponents(ComponentsContext ctxt) {
        ctxt.addListAction("SAISIE_VENTE_FACTURE", (IListeAction)new GoogleDocsListAction());
        ctxt.addListAction("DEVIS", (IListeAction)new GoogleDocsListAction());
    }

    protected void start() {
        StorageEngines.getInstance().addEngine((StorageEngine)this.engine);
    }

    public List<ModulePreferencePanelDesc> getPrefDescriptors() {
        return Arrays.asList(new ModulePreferencePanelDesc("OVH"){

            protected PreferencePanel createPanel() {
                return new GoogleDocsPreferencePanel();
            }
        });
    }

    protected void stop() {
        StorageEngines.getInstance().removeEngine((StorageEngine)this.engine);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.setProperty("org.openconcerto.quickLogin", "true");
        File propsFile = new File("gestionModule.properties");
        RuntimeModuleFactory factory = new RuntimeModuleFactory(propsFile);
        File distDir = new File("dist");
        FileUtils.mkdir_p((File)distDir);
        new ModulePackager(propsFile, new File("bin/")).writeToDir(distDir);
        new ModulePackager(propsFile, new File("bin/")).writeToDir(new File("../OpenConcerto/Modules"));
        ModuleManager.getInstance().addFactoryAndStart((ModuleFactory)factory, false);
        Gestion.main((String[])args);
    }
}

