/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.google.docs;

import com.google.gdata.util.AuthenticationException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.openconcerto.erp.storage.StorageEngine;
import org.openconcerto.modules.google.docs.GoogleDocsPreferencePanel;
import org.openconcerto.modules.google.docs.GoogleDocsUtils;

public class GoogleDocsStorageEngine
implements StorageEngine {
    private GoogleDocsUtils gUtils;

    public boolean isConfigured() {
        try {
            Properties props = GoogleDocsPreferencePanel.getProperties();
            return !props.getProperty("accountLogin", "").isEmpty() && !props.getProperty("accountPassword", "").isEmpty();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void connect() throws IOException {
        Properties props = GoogleDocsPreferencePanel.getProperties();
        this.gUtils = new GoogleDocsUtils("OpenConcerto");
        try {
            this.gUtils.login(props.getProperty("accountLogin", ""), props.getProperty("accountPassword", ""));
        }
        catch (AuthenticationException e) {
            throw new IOException("Identifiant ou mot de passe incorrect");
        }
    }

    public void disconnect() throws IOException {
    }

    public void store(InputStream inStream, String remotePath, String title, boolean synchronous) throws IOException {
        if (this.gUtils == null) {
            throw new IllegalStateException("Cannot upload before login is done");
        }
        remotePath = remotePath.replace('\\', '/');
        File f = File.createTempFile("openconcerto", "googledocs_" + title);
        FileOutputStream fOut = new FileOutputStream(f);
        BufferedOutputStream bOut = new BufferedOutputStream(fOut);
        byte[] buffer = new byte[32768];
        int len = 0;
        do {
            if ((len = inStream.read(buffer)) <= 0) continue;
            fOut.write(buffer, 0, len);
        } while (len > 0);
        bOut.close();
        fOut.close();
        try {
            this.gUtils.uploadFile(f, remotePath, title, synchronous);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (synchronous) {
            f.delete();
        } else {
            f.deleteOnExit();
        }
    }

    public void store(File file, String remotePath, String title, boolean synchronous) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        this.store(fIn, remotePath, title, synchronous);
        fIn.close();
    }

    public boolean allowAutoStorage() {
        try {
            Properties props = GoogleDocsPreferencePanel.getProperties();
            return props.getProperty("auto", "true").equals("true");
        }
        catch (IOException e) {
            return false;
        }
    }
}

