/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.google.docs;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Calendar;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.modules.google.docs.GoogleDocsStorageEngine;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.utils.ExceptionHandler;

public class GoogleDocsListAction
implements IListeAction {
    public IListeAction.ButtonsBuilder getHeaderButtons() {
        return IListeAction.ButtonsBuilder.emptyInstance();
    }

    public Action getDefaultAction(IListeAction.IListeEvent evt) {
        return null;
    }

    public IListeAction.PopupBuilder getPopupContent(IListeAction.PopupEvent evt) {
        IListeAction.PopupBuilder actions = new IListeAction.PopupBuilder(this.getClass().getPackage().getName());
        List rows = evt.getSelectedRows();
        JMenuItem createCallAction = this.createAction("Envoyer sur Google Docs", rows);
        actions.addItem(createCallAction);
        return actions;
    }

    private JMenuItem createAction(String label, final List<SQLRowAccessor> rows) {
        return new JMenuItem(new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public final void run() {
                            try {
                                GoogleDocsStorageEngine engine = new GoogleDocsStorageEngine();
                                engine.connect();
                                SQLElementDirectory directory = Configuration.getInstance().getDirectory();
                                SQLTable invoiceTable = ((SaisieVenteFactureSQLElement)directory.getElement(SaisieVenteFactureSQLElement.class)).getTable();
                                SQLTable quoteTable = ((DevisSQLElement)directory.getElement(DevisSQLElement.class)).getTable();
                                for (SQLRowAccessor sqlRowAccessor : rows) {
                                    File pdf;
                                    Calendar c;
                                    SQLRow row;
                                    if (sqlRowAccessor.getTable().equals(invoiceTable)) {
                                        row = sqlRowAccessor.asRow();
                                        c = row.getDate("DATE");
                                        VenteFactureXmlSheet venteFactureXmlSheet = new VenteFactureXmlSheet(row);
                                        pdf = venteFactureXmlSheet.getGeneratedPDFFile();
                                        if (!pdf.exists()) {
                                            venteFactureXmlSheet.getOrCreateDocumentFile();
                                            venteFactureXmlSheet.showPrintAndExport(false, false, true);
                                        }
                                        engine.store(pdf, "Factures/" + c.get(1), pdf.getName(), true);
                                        continue;
                                    }
                                    if (!sqlRowAccessor.getTable().equals(quoteTable)) continue;
                                    row = sqlRowAccessor.asRow();
                                    c = row.getDate("DATE");
                                    DevisXmlSheet devisXmlSheet = new DevisXmlSheet(row);
                                    pdf = devisXmlSheet.getGeneratedPDFFile();
                                    if (!pdf.exists()) {
                                        devisXmlSheet.getOrCreateDocumentFile();
                                        devisXmlSheet.showPrintAndExport(false, false, true);
                                    }
                                    engine.store(pdf, "Devis/" + c.get(1), pdf.getName(), true);
                                }
                                engine.disconnect();
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(null, e.getMessage());
                            }
                        }
                    });
                    t.start();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((String)"Echec de l'envoi", (Throwable)ex);
                }
            }
        });
    }
}

