/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.xml.JDOMUtils;

public class Link
extends DirectedEdge<SQLTable> {
    private final List<SQLField> cols;
    private final List<String> colsNames;
    private final List<SQLField> refCols;
    private final List<String> refColsNames;
    private final String name;
    private final Rule updateRule;
    private final Rule deleteRule;

    public Link(List<SQLField> keys, List<SQLField> referredCols, String foreignKeyName, Rule updateRule, Rule deleteRule) {
        super(keys.get(0).getTable(), referredCols.get(0).getTable());
        if (keys.size() != referredCols.size()) {
            throw new IllegalArgumentException("size mismatch: " + keys + " != " + referredCols);
        }
        this.cols = new ArrayList<SQLField>(keys);
        this.colsNames = new ArrayList<String>(this.cols.size());
        for (SQLField f : this.cols) {
            this.colsNames.add(f.getName());
        }
        this.refCols = new ArrayList<SQLField>(referredCols);
        this.refColsNames = new ArrayList<String>(this.refCols.size());
        for (SQLField f : this.refCols) {
            this.refColsNames.add(f.getName());
        }
        this.name = foreignKeyName;
        this.updateRule = updateRule;
        this.deleteRule = deleteRule;
    }

    public final List<SQLField> getFields() {
        return this.cols;
    }

    public final List<String> getCols() {
        return this.colsNames;
    }

    public final SQLField getLabel() {
        if (this.cols.size() == 1) {
            return this.cols.get(0);
        }
        throw new IllegalStateException(this + " has more than 1 foreign column: " + this.getFields());
    }

    public List<SQLField> getRefFields() {
        return this.refCols;
    }

    public final String getName() {
        return this.name;
    }

    public final Rule getUpdateRule() {
        return this.updateRule;
    }

    public final Rule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public String toString() {
        return "<" + this.getFields() + " -> " + this.getTarget() + (this.getName() != null ? " '" + this.getName() + "'" : "") + ">";
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Link)) {
            return false;
        }
        Link o = (Link)other;
        return this.getFields().equals(o.getFields()) && this.getRefFields().equals(o.getRefFields()) && this.getUpdateRule() == o.getUpdateRule() && this.getDeleteRule() == o.getDeleteRule();
    }

    @Override
    public int hashCode() {
        return this.getFields().hashCode() + this.getRefFields().hashCode();
    }

    void toXML(PrintWriter pWriter) {
        pWriter.print("  <link to=\"" + JDOMUtils.OUTPUTTER.escapeAttributeEntities(((SQLTable)this.getTarget()).getSQLName().toString()) + "\" ");
        if (this.getName() != null) {
            pWriter.print("name=\"" + JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getName()) + "\" ");
        }
        if (this.getUpdateRule() != null) {
            pWriter.print("updateRule=\"" + JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getUpdateRule().name()) + "\" ");
        }
        if (this.getDeleteRule() != null) {
            pWriter.print("deleteRule=\"" + JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getDeleteRule().name()) + "\" ");
        }
        if (this.getFields().size() == 1) {
            this.toXML(pWriter, 0);
            pWriter.println("/>");
        } else {
            pWriter.println(">");
            int i = 0;
            while (i < this.getFields().size()) {
                pWriter.print("    <l ");
                this.toXML(pWriter, i);
                pWriter.println("/>");
                ++i;
            }
            pWriter.println("  </link>");
        }
    }

    private void toXML(PrintWriter pWriter, int i) {
        pWriter.print("col=\"");
        pWriter.print(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getFields().get(i).getName()));
        pWriter.print("\" refCol=\"");
        pWriter.print(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getRefFields().get(i).getName()));
        pWriter.print("\"");
    }

    static Link fromXML(SQLTable t, Element linkElem) {
        SQLName to = SQLName.parse(linkElem.getAttributeValue("to"));
        SQLTable foreignTable = t.getDBSystemRoot().getDesc(to, SQLTable.class);
        String linkName = linkElem.getAttributeValue("name");
        Rule updateRule = Rule.fromName(linkElem.getAttributeValue("updateRule"));
        Rule deleteRule = Rule.fromName(linkElem.getAttributeValue("deleteRule"));
        List lElems = linkElem.getAttribute("col") != null ? Collections.singletonList(linkElem) : linkElem.getChildren("l");
        ArrayList<SQLField> cols = new ArrayList<SQLField>();
        ArrayList<SQLField> refcols = new ArrayList<SQLField>();
        for (Element l : lElems) {
            cols.add(t.getField(l.getAttributeValue("col")));
            refcols.add(foreignTable.getField(l.getAttributeValue("refCol")));
        }
        return new Link(cols, refcols, linkName, updateRule, deleteRule);
    }

    public static enum Rule {
        SET_NULL("SET NULL"),
        SET_DEFAULT("SET DEFAULT"),
        CASCADE("CASCADE"),
        RESTRICT("RESTRICT"),
        NO_ACTION("NO ACTION");

        private final String sql;

        private Rule(String sql) {
            this.sql = sql;
        }

        public static Rule fromShort(short s) {
            switch (s) {
                case 0: {
                    return CASCADE;
                }
                case 2: {
                    return SET_NULL;
                }
                case 4: {
                    return SET_DEFAULT;
                }
                case 1: {
                    return RESTRICT;
                }
                case 3: {
                    return NO_ACTION;
                }
            }
            throw new IllegalArgumentException("Unknown rule " + s);
        }

        public static Rule fromName(String n) {
            return n == null ? null : Rule.valueOf(n);
        }

        public String asString() {
            return this.sql;
        }
    }
}

