/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public class Where {
    public static final Where FALSE = Where.createRaw("1=0", new FieldRef[0]);
    public static final Where TRUE = Where.createRaw("1=1", new FieldRef[0]);
    public static final String NULL_IS_DATA_EQ = new String("===");
    public static final String NULL_IS_DATA_NEQ = new String("IS DISTINCT FROM");
    private static Combiner AndCombiner = new Combiner(){

        @Override
        protected Where combineNotNull(Where where1, Where where2) {
            return where1.and(where2);
        }
    };
    private static Combiner OrCombiner = new Combiner(){

        @Override
        protected Where combineNotNull(Where where1, Where where2) {
            return where1.or(where2);
        }
    };
    private final List<FieldRef> fields = new ArrayList<FieldRef>();
    private String clause = "";

    public static Where and(Where where1, Where where2) {
        return AndCombiner.combine(where1, where2);
    }

    public static Where createRaw(String clause, FieldRef ... refs) {
        return new Where(clause, Arrays.asList(refs));
    }

    private static final String comparison(FieldRef ref, String op, String y) {
        if (op == NULL_IS_DATA_EQ || op == NULL_IS_DATA_NEQ) {
            return ref.getField().getServer().getSQLSystem().getSyntax().getNullIsDataComparison(ref.getFieldRef(), op == NULL_IS_DATA_EQ, y);
        }
        return String.valueOf(ref.getFieldRef()) + " " + op + " " + y;
    }

    public Where(FieldRef field1, String op, FieldRef field2) {
        this.fields.add(field1);
        this.fields.add(field2);
        this.clause = Where.comparison(field1, op, field2.getFieldRef());
    }

    public Where(FieldRef field1, String op, int scalar) {
        this(field1, op, (Object)scalar);
    }

    public Where(FieldRef ref, String op, Object o) {
        this.fields.add(ref);
        if (o == null) {
            if (op.trim().equals("=")) {
                op = "is";
            } else if (op.trim().equals("<>")) {
                op = "is not";
            }
        }
        this.clause = Where.comparison(ref, op, ref.getField().getType().toString(o));
    }

    public Where(FieldRef field1, Collection<?> values) {
        this(field1, true, values);
    }

    public Where(final FieldRef field1, boolean in, Collection<?> values) {
        if (values.isEmpty()) {
            this.clause = in ? FALSE.getClause() : TRUE.getClause();
        } else {
            this.fields.add(field1);
            String op = in ? " in (" : " not in (";
            this.clause = String.valueOf(field1.getFieldRef()) + op + CollectionUtils.join(values, ",", new ITransformer<Object, String>(){

                @Override
                public String transformChecked(Object input) {
                    return field1.getField().getType().toString(input);
                }
            }) + ")";
        }
    }

    public Where(FieldRef ref, Object borneInf, Object borneSup) {
        SQLField field1 = ref.getField();
        this.fields.add(ref);
        this.clause = String.valueOf(ref.getFieldRef()) + " BETWEEN " + field1.getType().toString(borneInf) + " AND " + field1.getType().toString(borneSup);
    }

    private Where(String clause, Collection<? extends FieldRef> refs) {
        this.fields.addAll(refs);
        this.clause = clause;
    }

    private Where() {
    }

    public Where(Where orig) {
        this(orig.clause, orig.fields);
    }

    public Where or(Where w) {
        return this.combine(w, "OR");
    }

    public Where and(Where w) {
        return this.combine(w, "AND");
    }

    private Where combine(Where w, String op) {
        if (w == null) {
            return this;
        }
        Where res = new Where();
        res.fields.addAll(this.fields);
        res.fields.addAll(w.fields);
        res.clause = "(" + this.clause + ") " + op + " (" + w.clause + ")";
        return res;
    }

    public String getClause() {
        return this.clause;
    }

    public List<FieldRef> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.getClause();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Where) {
            Where o = (Where)obj;
            return this.getClause().equals(o.getClause()) && this.getFields().equals(o.getFields());
        }
        return false;
    }

    public int hashCode() {
        return this.getClause().hashCode() + this.getFields().hashCode();
    }

    private static abstract class Combiner {
        private Combiner() {
        }

        public final Where combine(Where w1, Where w2) {
            if (w1 == null) {
                return w2;
            }
            return this.combineNotNull(w1, w2);
        }

        protected abstract Where combineNotNull(Where var1, Where var2);
    }
}

