/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;

public class FixSerial
extends Changer<SQLTable> {
    private static final Pattern seqPattern = Pattern.compile("nextval\\('(.+)'.*\\)");

    public FixSerial(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.of(SQLSystem.POSTGRESQL);
    }

    @Override
    protected void changeImpl(SQLTable t) {
        this.getStream().print(t + "... ");
        if (!t.isRowable()) {
            this.getStream().println("not rowable");
        } else {
            String seqName = FixSerial.getPrimaryKeySeq(t);
            if (seqName != null) {
                SQLSelect sel = new SQLSelect(t.getBase(), true);
                sel.addSelect(t.getKey(), "max");
                Number maxID = (Number)this.getDS().executeScalar(sel.asString());
                long nextID = maxID == null ? 1L : maxID.longValue() + 1L;
                String s = "ALTER SEQUENCE " + seqName + " RESTART " + nextID;
                this.getDS().executeScalar(s);
                this.getStream().println("done");
            } else {
                this.getStream().println("no sequence: " + t.getKey().getDefaultValue());
            }
        }
    }

    public static String getPrimaryKeySeq(SQLTable t) throws IllegalStateException {
        if (!t.isRowable()) {
            return null;
        }
        return FixSerial.getSeq(t.getKey());
    }

    public static String getSeq(SQLField f) throws IllegalStateException {
        if (f == null) {
            return null;
        }
        String def = ((String)f.getDefaultValue()).trim();
        if (def.startsWith("nextval")) {
            Matcher matcher = seqPattern.matcher(def);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            throw new IllegalStateException("could not parse: " + def + " with " + seqPattern.pattern());
        }
        return null;
    }
}

