/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer;

import java.io.PrintStream;
import java.sql.SQLException;
import java.util.EnumSet;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.StreamUtils;

public abstract class Changer<L extends DBStructureItem> {
    private final DBSystemRoot base;
    private PrintStream stream;
    private boolean quiet;

    public Changer(DBSystemRoot b) {
        if (!this.getCompatibleSystems().contains((Object)b.getServer().getSQLSystem())) {
            throw new IllegalArgumentException(b + " of " + b.getServer() + " doesn't belong to " + this.getCompatibleSystems());
        }
        this.base = b;
        this.setQuiet(false);
    }

    public final DBSystemRoot getSystemRoot() {
        return this.base;
    }

    public final void setQuiet(boolean quiet) {
        this.quiet = quiet;
        this.stream = this.quiet ? new PrintStream(StreamUtils.NULL_OS) : System.err;
    }

    public final void change(L root) throws SQLException {
        this.changeAll((DBStructureItem<?>)root);
    }

    public final void changeAll(DBStructureItem<?> root) throws SQLException {
        if (!root.getAnc(DBSystemRoot.class).equals(this.getSystemRoot())) {
            throw new IllegalArgumentException(root + " not in " + this.getSystemRoot());
        }
        if (this.getMinLevel() != null && root.getHopsTo(this.getMinLevel()) < 0) {
            throw new IllegalArgumentException(root + " must be at least " + this.getMinLevel());
        }
        if (this.getMaxLevel() != null && root.getHopsTo(this.getMaxLevel()) > 0) {
            throw new IllegalArgumentException(root + " must be at most " + this.getMaxLevel());
        }
        this.getStream().println("Beginning " + this);
        long t1 = System.currentTimeMillis();
        try {
            for (DBStructureItem t : root.getDescs(this.getL())) {
                this.changeImpl(t);
            }
        }
        finally {
            long t2 = System.currentTimeMillis();
            this.getStream().println("Done " + this + " in " + (t2 - t1) + "ms.");
        }
    }

    private final Class<L> getL() {
        return ReflectUtils.getTypeArguments(this.getClass(), Changer.class).get(0);
    }

    protected abstract void changeImpl(L var1) throws SQLException;

    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.allOf(SQLSystem.class);
    }

    protected Class<? extends DBStructureItem> getMinLevel() {
        return null;
    }

    protected Class<? extends DBStructureItem> getMaxLevel() {
        return null;
    }

    protected final PrintStream getStream() {
        return this.stream;
    }

    public final SQLDataSource getDS() {
        return this.getSystemRoot().getDataSource();
    }

    protected final SQLSyntax getSyntax() {
        return SQLSyntax.get(this.getSystemRoot().getServer().getSQLSystem());
    }
}

