/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionUtils;

public final class State
extends Thread {
    public static final State INSTANCE = new State();
    public static final DateFormat TIME_FMT = DateFormat.getTimeInstance();
    private final List<String> requests;
    private final List<String> failed;
    private int failedStmts;
    private int connectionTotalCount;
    private int connectionCount;
    private int requestsTotalCount;
    private final long upDate;
    private int frameCount;
    private int framesVisible;
    private PrintWriter out;
    private Thread thread;
    private int cacheHit;
    private final ScriptEngine engine;
    private final Bindings ognlCtxt;

    static {
        TIME_FMT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private State() {
        super("State thread");
        this.setDaemon(true);
        this.requests = new ArrayList<String>();
        this.requestsTotalCount = 0;
        this.failed = new ArrayList<String>();
        this.failedStmts = 0;
        this.connectionTotalCount = 0;
        this.connectionCount = 0;
        this.frameCount = 0;
        this.framesVisible = 0;
        this.cacheHit = 0;
        this.upDate = System.currentTimeMillis();
        this.engine = new ScriptEngineManager().getEngineByName("javascript");
        this.ognlCtxt = new SimpleBindings();
        if (!Boolean.getBoolean("org.openconcerto.sql.deafState")) {
            this.start();
        }
    }

    private Bindings getContext() {
        this.ognlCtxt.put("base", (Object)this.getBase());
        this.ognlCtxt.put("dir", (Object)Configuration.getInstance().getDirectory());
        return this.ognlCtxt;
    }

    private ServerSocket createSocket() {
        ServerSocket serverSocket = null;
        int port = 1394;
        while (serverSocket == null) {
            try {
                serverSocket = new ServerSocket(port);
                Log.get().info("listening on " + port);
            }
            catch (BindException e) {
                Log.get().config("port " + port + " already in use");
                ++port;
            }
            catch (IOException e) {
                Log.get().warning("cannot create a socket");
                e.printStackTrace();
                return null;
            }
        }
        return serverSocket;
    }

    @Override
    public void run() {
        ServerSocket serverSocket = this.createSocket();
        if (serverSocket == null) {
            return;
        }
        while (true) {
            try {
                while (true) {
                    String inputLine;
                    Socket clientSocket = serverSocket.accept();
                    Log.get().info("accepted");
                    BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    this.out = new PrintWriter(clientSocket.getOutputStream(), true);
                    this.out.println("Console d'administration: " + clientSocket.getLocalSocketAddress() + " <-> " + clientSocket.getRemoteSocketAddress());
                    this.out.println("help (ou h) pour l'aide");
                    this.out.println("quit (ou q) pour quitter");
                    this.out.flush();
                    while ((inputLine = in.readLine()) != null) {
                        if (inputLine.equals("q") || inputLine.startsWith("quit")) break;
                        if (inputLine.equals("h") || inputLine.startsWith("help")) {
                            this.printHelp();
                        }
                        try {
                            this.out.println(this.getAnswer(inputLine));
                        }
                        catch (Exception exn) {
                            exn.printStackTrace();
                            exn.printStackTrace(this.out);
                        }
                        this.out.print(">");
                        this.out.flush();
                    }
                    in.close();
                    if (this.thread != null) {
                        this.thread.interrupt();
                    }
                    this.out.close();
                    clientSocket.close();
                    Log.get().info("closed");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void printHelp() {
        this.out.println("Commandes possibles:");
        this.out.println("req     : affiche la liste des requ\u00eates en cours");
        this.out.println("all     : affiche les stats du logiciels");
        this.out.println("gc      : lance le garbage collector");
        this.out.println("log LEVEL [loggerName] : d\u00e9finit un niveau de log");
        this.out.println("unarchive TABLE ID     : d\u00e9sarchive un \u00e9l\u00e9ment d'une table (et propage le desarchivage)");
        this.out.println("\t ex: unarchive SITE 125 va d\u00e9sarchiver BATIMENTs etc...");
        this.out.println("set    : d\u00e9finit une variable OGNL ou affiche la liste");
        this.out.println("\t ex: set siteT base.getTable('SITE')");
        this.out.println("eval   : evalue une expression OGNL");
        this.out.println("\t ex: #siteT.getRow(123).getReferentRows()");
        this.out.println();
        this.out.flush();
    }

    private String getAnswer(String question) throws SQLException {
        if ((question = question.trim()).equals("req")) {
            return this.requests.toString();
        }
        if (question.equals("all")) {
            return this.getFull();
        }
        if (question.equals("gc")) {
            System.gc();
            return "System.gc() called.";
        }
        if (question.startsWith("log")) {
            Level l;
            String[] args = question.split(" ");
            String level = args[1];
            try {
                Field f = Level.class.getField(level);
                l = (Level)f.get(null);
            }
            catch (Exception e) {
                return "cannot get field '" + level + "' of Level";
            }
            String name = args.length > 2 ? args[2] : "";
            Logger.getLogger(name).setLevel(l);
            return "logger '" + name + "' level set to " + l.getName();
        }
        if (question.equals("allc")) {
            this.thread = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (true) {
                        State.this.out.println("--------------");
                        State.this.out.println("Iteration: " + i++);
                        State.this.out.println("--------------");
                        State.this.out.println(State.this.getFull());
                        State.this.out.println("\n");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
            };
            this.thread.start();
            return "beginning";
        }
        if (question.startsWith("unarchive")) {
            return this.archive(question, false);
        }
        if (question.startsWith("archive")) {
            return this.archive(question, true);
        }
        if (question.startsWith("eval")) {
            try {
                return this.ognlResult(this.eval(question.substring("eval".length())));
            }
            catch (ScriptException e) {
                return ExceptionUtils.getStackTrace(e);
            }
        }
        if (question.startsWith("set")) {
            String[] args = question.split(" ", 3);
            if (args.length == 1) {
                return CollectionUtils.join(this.ognlCtxt.entrySet(), "\n");
            }
            try {
                Object res = this.eval(args[2]);
                this.ognlCtxt.put(args[1], res);
                return this.ognlResult(res);
            }
            catch (ScriptException e) {
                return ExceptionUtils.getStackTrace(e);
            }
        }
        return "commande non connue.";
    }

    private String archive(String question, boolean arch) throws SQLException {
        String s;
        String[] args = question.split(" ");
        String tableName = args[1];
        int id = Integer.parseInt(args[2]);
        if (arch) {
            this.getElement(tableName).archive(id);
            s = "archived";
        } else {
            this.getElement(tableName).unarchive(id);
            s = "unarchived";
        }
        return String.valueOf(s) + " " + this.getBase().getTable(tableName).getRow(id);
    }

    public final Object eval(String s) throws ScriptException {
        return this.engine.eval(s, this.getContext());
    }

    private String ognlResult(Object res) {
        return res == null ? "<no result>" : res.toString();
    }

    private final SQLBase getBase() {
        return Configuration.getInstance().getBase();
    }

    private final SQLElement getElement(String tableName) {
        return Configuration.getInstance().getDirectory().getElement(tableName);
    }

    private String getFull() {
        String res = "failed requests: " + this.failed.size();
        res = String.valueOf(res) + "\nfailed statements: " + this.failedStmts;
        res = String.valueOf(res) + "\nrequests: " + this.requests.size();
        res = String.valueOf(res) + "\ntotal requests: " + this.requestsTotalCount;
        res = String.valueOf(res) + "\nconnections: " + this.connectionCount;
        res = String.valueOf(res) + "\ntotal connections: " + this.connectionTotalCount;
        res = String.valueOf(res) + "\ncache hit: " + this.cacheHit;
        res = String.valueOf(res) + "\nuptime: " + this.getUptime();
        res = String.valueOf(res) + "\n\nvisible frames: " + this.framesVisible;
        res = String.valueOf(res) + "\ntotal: " + this.frameCount;
        res = String.valueOf(res) + "\n\nhost: " + this.getHostDesc();
        return res;
    }

    private String getUptime() {
        return TIME_FMT.format(new Long(System.currentTimeMillis() - this.upDate));
    }

    private String getHostDesc() {
        Runtime rt = Runtime.getRuntime();
        String res = "processors: " + rt.availableProcessors();
        res = String.valueOf(res) + "\nfree memory: " + this.formatBytes(rt.freeMemory());
        res = String.valueOf(res) + "\ntotal memory: " + this.formatBytes(rt.totalMemory());
        return res;
    }

    private String formatBytes(long b) {
        return String.valueOf(b / 1024L / 1024L) + "MB";
    }

    public synchronized void beginRequest(String req) {
        this.requests.add(req);
        ++this.requestsTotalCount;
    }

    public synchronized void endRequest(String req) {
        this.requests.remove(req);
    }

    public synchronized void addFailedRequest(String query) {
        this.failed.add(query);
    }

    public synchronized void connectionCreated() {
        ++this.connectionTotalCount;
        ++this.connectionCount;
    }

    public synchronized void connectionRemoved() {
        --this.connectionCount;
    }

    public synchronized void addCacheHit() {
        ++this.cacheHit;
    }
}

