/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ServerFinder {
    private static int PING_TIMEOUT = 50;

    public List<String> getIPsToScan() {
        ArrayList<String> ips = new ArrayList<String>();
        ips.add("127.0.0.1");
        List<InetAddress> addrs = this.getMyLocalAdresses();
        for (InetAddress inetAddress : addrs) {
            String myIp = inetAddress.getHostAddress();
            int i = myIp.lastIndexOf(46);
            if (i <= 0) continue;
            String s = myIp.substring(0, i + 1);
            int j = 0;
            while (j < 255) {
                String ip = String.valueOf(s) + j;
                if (!ips.contains(ip) && !ip.equals(myIp)) {
                    ips.add(ip);
                }
                ++j;
            }
        }
        return ips;
    }

    public List<InetAddress> getMyLocalAdresses() {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                if (ni.getHardwareAddress() == null || ni.isLoopback() || ni.getDisplayName().toLowerCase().contains("vmware") || ni.getName().toLowerCase().contains("vmnet")) continue;
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    result.add(addrs.nextElement());
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isPortOpen(String ip, int port) {
        try {
            InetAddress addr = InetAddress.getByName(ip);
            InetSocketAddress sockaddr = new InetSocketAddress(addr, port);
            Socket sock = new Socket();
            int timeoutMs = 2000;
            sock.connect(sockaddr, timeoutMs);
            sock.close();
            System.err.println("->" + ip + " " + port + "open");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean ping(InetAddress host) {
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                int exit = Runtime.getRuntime().exec("ping -n 1 -w " + PING_TIMEOUT + " " + host.getHostAddress()).waitFor();
                return exit == 0;
            }
            int exit = Runtime.getRuntime().exec("ping -c 1 -w " + PING_TIMEOUT + " " + host.getHostAddress()).waitFor();
            return exit == 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

