/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import org.h2.constant.SysProperties;
import org.h2.message.TraceWriter;
import org.h2.util.StringUtils;

public class Trace {
    private TraceWriter traceWriter;
    private String module;
    private String lineSeparator;
    private int traceLevel = -1;

    Trace(TraceWriter traceWriter, String string) {
        this.traceWriter = traceWriter;
        this.module = string;
        this.lineSeparator = SysProperties.LINE_SEPARATOR;
    }

    public void setLevel(int n) {
        this.traceLevel = n;
    }

    private boolean isEnabled(int n) {
        if (this.traceLevel == -1) {
            return this.traceWriter.isEnabled(n);
        }
        return n <= this.traceLevel;
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(2);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(3);
    }

    public void error(String string, Throwable throwable) {
        if (this.isEnabled(1)) {
            this.traceWriter.write(1, this.module, string, throwable);
        }
    }

    public void info(String string) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, string, null);
        }
    }

    void info(String string, Throwable throwable) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, string, throwable);
        }
    }

    public void infoSQL(String string, String string2, int n, long l) {
        if (!this.isEnabled(2)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 20);
        stringBuilder.append(this.lineSeparator).append("/*SQL");
        boolean bl = false;
        if (string2.length() > 0) {
            bl = true;
            stringBuilder.append(" l:").append(string.length());
        }
        if (n > 0) {
            bl = true;
            stringBuilder.append(" #:").append(n);
        }
        if (l > 0L) {
            bl = true;
            stringBuilder.append(" t:").append(l);
        }
        if (!bl) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("*/").append(StringUtils.javaEncode(string)).append(StringUtils.javaEncode(string2)).append(';');
        string = stringBuilder.toString();
        this.traceWriter.write(2, this.module, string, null);
    }

    public void debug(String string) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, string, null);
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, string, throwable);
        }
    }

    public void infoCode(String string) {
        if (this.isEnabled(2)) {
            this.traceWriter.write(2, this.module, this.lineSeparator + "/**/" + string, null);
        }
    }

    void debugCode(String string) {
        if (this.isEnabled(3)) {
            this.traceWriter.write(3, this.module, this.lineSeparator + "/**/" + string, null);
        }
    }
}

