/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntry;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class ListOrderedMap
extends AbstractMapDecorator
implements Serializable,
OrderedMap {
    protected final List insertOrder = new ArrayList();

    public static OrderedMap decorate(Map map) {
        return new ListOrderedMap(map);
    }

    public ListOrderedMap() {
        this(new HashMap());
    }

    protected ListOrderedMap(Map map) {
        super(map);
        this.insertOrder.addAll(this.getMap().keySet());
    }

    public Object put(Object key, Object value) {
        if (this.getMap().containsKey(key)) {
            return this.getMap().put(key, value);
        }
        Object result = this.getMap().put(key, value);
        this.insertOrder.add(key);
        return result;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        Object result = this.getMap().remove(key);
        this.insertOrder.remove(key);
        return result;
    }

    public void clear() {
        this.getMap().clear();
        this.insertOrder.clear();
    }

    public Set keySet() {
        return new KeySetView(this);
    }

    public Collection values() {
        return new ValuesView(this);
    }

    public Set entrySet() {
        return new EntrySetView(this, this.insertOrder);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        boolean first = true;
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append((Object)(key == this ? "(this Map)" : key));
            buf.append('=');
            buf.append((Object)(value == this ? "(this Map)" : value));
        }
        buf.append('}');
        return buf.toString();
    }

    public List asList() {
        return UnmodifiableList.decorate(this.insertOrder);
    }

    static class ListOrderedMapEntry
    extends AbstractMapEntry {
        private final ListOrderedMap parent;

        ListOrderedMapEntry(ListOrderedMap parent, Object key) {
            super(key, null);
            this.parent = parent;
        }

        public Object getValue() {
            return this.parent.get(this.key);
        }

        public Object setValue(Object value) {
            return this.parent.getMap().put(this.key, value);
        }
    }

    static class ListOrderedIterator
    extends AbstractIteratorDecorator {
        private final ListOrderedMap parent;
        private Object last = null;

        ListOrderedIterator(ListOrderedMap parent, List insertOrder) {
            super(insertOrder.iterator());
            this.parent = parent;
        }

        public Object next() {
            this.last = super.next();
            return new ListOrderedMapEntry(this.parent, this.last);
        }

        public void remove() {
            super.remove();
            this.parent.getMap().remove(this.last);
        }
    }

    static class EntrySetView
    extends AbstractSet {
        private final ListOrderedMap parent;
        private final List insertOrder;
        private Set entrySet;

        public EntrySetView(ListOrderedMap parent, List insertOrder) {
            this.parent = parent;
            this.insertOrder = insertOrder;
        }

        private Set getEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = this.parent.getMap().entrySet();
            }
            return this.entrySet;
        }

        public int size() {
            return this.parent.size();
        }

        public boolean isEmpty() {
            return this.parent.isEmpty();
        }

        public boolean contains(Object obj) {
            return this.getEntrySet().contains(obj);
        }

        public boolean containsAll(Collection coll) {
            return this.getEntrySet().containsAll(coll);
        }

        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            if (this.getEntrySet().contains(obj)) {
                Object key = ((Map.Entry)obj).getKey();
                this.parent.remove(key);
                return true;
            }
            return false;
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return this.getEntrySet().equals(obj);
        }

        public int hashCode() {
            return this.getEntrySet().hashCode();
        }

        public String toString() {
            return this.getEntrySet().toString();
        }

        public Iterator iterator() {
            return new ListOrderedIterator(this.parent, this.insertOrder);
        }
    }

    static class KeySetView
    extends AbstractSet {
        private final ListOrderedMap parent;

        KeySetView(ListOrderedMap parent) {
            this.parent = parent;
        }

        public int size() {
            return this.parent.size();
        }

        public boolean contains(Object value) {
            return this.parent.containsKey(value);
        }

        public void clear() {
            this.parent.clear();
        }

        public Iterator iterator() {
            return new AbstractIteratorDecorator(this, this.parent.entrySet().iterator()){
                private final /* synthetic */ KeySetView this$0;
                {
                    this.this$0 = this$0;
                }

                public Object next() {
                    return ((Map.Entry)super.next()).getKey();
                }
            };
        }
    }

    static class ValuesView
    extends AbstractCollection {
        private final ListOrderedMap parent;

        ValuesView(ListOrderedMap parent) {
            this.parent = parent;
        }

        public int size() {
            return this.parent.size();
        }

        public boolean contains(Object value) {
            return this.parent.containsValue(value);
        }

        public void clear() {
            this.parent.clear();
        }

        public Iterator iterator() {
            return new AbstractIteratorDecorator(this, this.parent.entrySet().iterator()){
                private final /* synthetic */ ValuesView this$0;
                {
                    this.this$0 = this$0;
                }

                public Object next() {
                    return ((Map.Entry)this.iterator.next()).getValue();
                }
            };
        }
    }
}

